/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.matchers.psystem.rewriters;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PDisjunction;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.incquery.runtime.matchers.psystem.rewriters.FlattenerCopier;
import org.eclipse.incquery.runtime.matchers.psystem.rewriters.IConstraintFilter;
import org.eclipse.incquery.runtime.matchers.psystem.rewriters.IVariableRenamer;
import org.eclipse.incquery.runtime.matchers.psystem.rewriters.PDisjunctionRewriter;
import org.eclipse.incquery.runtime.matchers.psystem.rewriters.RewriterException;

public class PQueryFlattener
extends PDisjunctionRewriter {
    private static final String FLATTENING_ERROR_MESSAGE = "Error occured while flattening";

    @Override
    public PDisjunction rewrite(PDisjunction disjunction) throws RewriterException {
        PQuery query = disjunction.getQuery();
        if (disjunction.getAllReferredQueries().contains(query)) {
            throw new RewriterException("Recursive queries are not supported, can't flatten query named \"{1}\"", new String[]{query.getFullyQualifiedName()}, "Unsupported recursive query", query);
        }
        try {
            return this.doFlatten(disjunction);
        }
        catch (Exception e) {
            throw new RewriterException(FLATTENING_ERROR_MESSAGE, null, FLATTENING_ERROR_MESSAGE, query, e);
        }
    }

    public PDisjunction flatten(PQuery pQuery) {
        try {
            return this.rewrite(pQuery.getDisjunctBodies());
        }
        catch (RewriterException e) {
            throw new RuntimeException(e);
        }
    }

    private PDisjunction doFlatten(PDisjunction disjunction) {
        Set<PBody> bodies = disjunction.getBodies();
        HashSet flattenedBodies = Sets.newHashSet();
        for (PBody pBody : bodies) {
            flattenedBodies.addAll(this.doFlatten(pBody));
        }
        return new PDisjunction(disjunction.getQuery(), flattenedBodies);
    }

    private Set<PBody> doFlatten(PBody pBody) {
        Set<PConstraint> constraints = pBody.getConstraints();
        if (!this.isFlatteningNeeded(constraints)) {
            return this.prepareFlatPBody(pBody);
        }
        ArrayList flattenedCalls = Lists.newArrayList();
        ArrayList flattenedDisjunctions = Lists.newArrayList();
        for (PConstraint pConstraint : constraints) {
            PositivePatternCall positivePatternCall;
            if (!(pConstraint instanceof PositivePatternCall) || !this.shouldFlatten(positivePatternCall = (PositivePatternCall)pConstraint)) continue;
            PQuery referredQuery = positivePatternCall.getReferredQuery();
            PDisjunction flattenedDisjunction = this.doFlatten(referredQuery.getDisjunctBodies());
            flattenedDisjunctions.add(flattenedDisjunction);
            flattenedCalls.add(positivePatternCall);
        }
        return this.createFlatPDisjunction(pBody, flattenedDisjunctions, flattenedCalls);
    }

    private Set<PBody> createFlatPDisjunction(PBody pBody, List<PDisjunction> flattenedDisjunctions, List<PositivePatternCall> flattenedCalls) {
        PQuery pQuery = pBody.getPattern();
        Set<List<PBody>> conjunctBodySets = this.combineBodies(flattenedDisjunctions);
        HashSet conjunctedBodies = Sets.newHashSet();
        for (List<PBody> bodySet : conjunctBodySets) {
            FlattenerCopier copier = new FlattenerCopier(pQuery, flattenedCalls, bodySet);
            for (PBody calledBody : bodySet) {
                copier.mergeBody(calledBody, new IVariableRenamer.HierarchicalName(), new IConstraintFilter.ExportedParameterFilter());
            }
            copier.mergeBody(pBody);
            PBody copiedBody = copier.getCopiedBody();
            copiedBody.setStatus(PQuery.PQueryStatus.OK);
            conjunctedBodies.add(copiedBody);
        }
        return conjunctedBodies;
    }

    private Set<PBody> prepareFlatPBody(PBody pBody) {
        HashSet bodySet = Sets.newHashSet();
        FlattenerCopier copier = new FlattenerCopier(pBody.getPattern(), Lists.newArrayList(), Lists.newArrayList());
        copier.mergeBody(pBody, new IVariableRenamer.SameName(), new IConstraintFilter.AllowAllFilter());
        FlattenerCopier flattenerCopier = copier;
        bodySet.add(flattenerCopier.getCopiedBody());
        return bodySet;
    }

    private boolean isFlatteningNeeded(Set<PConstraint> constraints) {
        for (PConstraint pConstraint : constraints) {
            if (!(pConstraint instanceof PositivePatternCall) || !this.shouldFlatten((PositivePatternCall)pConstraint)) continue;
            return true;
        }
        return false;
    }

    private Set<List<PBody>> combineBodies(List<PDisjunction> pDisjunctions) {
        ArrayList setsToCombine = Lists.newArrayList();
        Set result = Sets.newHashSet();
        if (pDisjunctions.size() != 0) {
            for (PDisjunction pDisjunction : pDisjunctions) {
                setsToCombine.add(pDisjunction.getBodies());
            }
            result = Sets.cartesianProduct((List)setsToCombine);
        }
        return result;
    }

    private boolean shouldFlatten(PositivePatternCall positivePatternCall) {
        boolean shouldFlatten = true;
        return shouldFlatten;
    }
}

