/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.emf;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.incquery.runtime.api.AdvancedIncQueryEngine;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.scope.IEngineContext;
import org.eclipse.incquery.runtime.api.scope.IIndexingErrorListener;
import org.eclipse.incquery.runtime.api.scope.IncQueryScope;
import org.eclipse.incquery.runtime.base.api.BaseIndexOptions;
import org.eclipse.incquery.runtime.base.api.NavigationHelper;
import org.eclipse.incquery.runtime.emf.EMFBaseIndexWrapper;
import org.eclipse.incquery.runtime.emf.EMFEngineContext;
import org.eclipse.incquery.runtime.exception.IncQueryException;

public class EMFScope
extends IncQueryScope {
    private Set<? extends Notifier> scopeRoots;
    private BaseIndexOptions options;

    public EMFScope(Notifier scopeRoot) throws IncQueryException {
        this((Set<? extends Notifier>)ImmutableSet.of((Object)scopeRoot), new BaseIndexOptions());
    }

    public EMFScope(Notifier scopeRoot, BaseIndexOptions options) throws IncQueryException {
        this((Set<? extends Notifier>)ImmutableSet.of((Object)scopeRoot), options);
    }

    public EMFScope(Set<? extends ResourceSet> scopeRoots) throws IncQueryException {
        this(scopeRoots, new BaseIndexOptions());
    }

    public EMFScope(Set<? extends Notifier> scopeRoots, BaseIndexOptions options) throws IncQueryException {
        if (scopeRoots.isEmpty()) {
            throw new IllegalArgumentException("No scope roots given");
        }
        if (scopeRoots.size() == 1) {
            this.checkScopeRoots(scopeRoots, (Predicate<Object>)Predicates.or((Iterable)ImmutableSet.of((Object)Predicates.instanceOf(EObject.class), (Object)Predicates.instanceOf(Resource.class), (Object)Predicates.instanceOf(ResourceSet.class))));
        } else {
            this.checkScopeRoots(scopeRoots, (Predicate<Object>)Predicates.instanceOf(ResourceSet.class));
        }
        this.scopeRoots = ImmutableSet.copyOf(scopeRoots);
        this.options = options.copy();
    }

    private void checkScopeRoots(Set<? extends Notifier> scopeRoots, Predicate<Object> predicate) throws IncQueryException {
        for (Notifier notifier : scopeRoots) {
            if (predicate.apply((Object)notifier)) continue;
            throw new IncQueryException("Incremental EMF query engine can only be attached on the contents of an EMF EObject, Resource, ResourceSet or multiple ResourceSets. Received instead: " + (notifier == null ? "(null)" : notifier.getClass().getName()), "Invalid EMF model root");
        }
    }

    public Set<? extends Notifier> getScopeRoots() {
        return this.scopeRoots;
    }

    @Deprecated
    public Notifier getScopeRoot() {
        if (this.scopeRoots.size() == 1) {
            return this.scopeRoots.iterator().next();
        }
        throw new IllegalStateException("This is a multi-root scope");
    }

    public BaseIndexOptions getOptions() {
        return this.options.copy();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.options == null ? 0 : this.options.hashCode());
        result = 31 * result + (this.scopeRoots == null ? 0 : this.scopeRoots.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EMFScope)) {
            return false;
        }
        EMFScope other = (EMFScope)obj;
        if (this.options == null ? other.options != null : !this.options.equals((Object)other.options)) {
            return false;
        }
        return !(this.scopeRoots == null ? other.scopeRoots != null : !this.scopeRoots.equals(other.scopeRoots));
    }

    public String toString() {
        return String.format("EMFScope(%s):%s", this.options, this.scopeRoots);
    }

    @Override
    protected IEngineContext createEngineContext(IncQueryEngine engine, IIndexingErrorListener errorListener, Logger logger) {
        return new EMFEngineContext(this, engine, errorListener, logger);
    }

    public static NavigationHelper extractUnderlyingEMFIndex(IncQueryEngine engine) throws IncQueryException {
        IncQueryScope scope = engine.getScope();
        if (scope instanceof EMFScope) {
            return ((EMFBaseIndexWrapper)AdvancedIncQueryEngine.from(engine).getBaseIndex()).getNavigationHelper();
        }
        throw new IllegalArgumentException("Cannot extract EMF base index from IncQuery engine instantiated on non-EMF scope " + scope);
    }
}

