/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.testing.ui.handlers;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.snapshot.EIQSnapshot.EIQSnapshotFactory;
import org.eclipse.incquery.snapshot.EIQSnapshot.IncQuerySnapshot;
import org.eclipse.incquery.testing.core.ModelLoadHelper;
import org.eclipse.incquery.testing.core.SnapshotHelper;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher.PatternMatcherContent;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher.PatternMatcherRootContent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class SaveSnapshotHandler
extends AbstractHandler {
    @Inject
    SnapshotHelper helper;
    @Inject
    ModelLoadHelper loader;
    @Inject
    private Logger logger;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof TreeSelection) {
            this.saveSnapshot((TreeSelection)selection, event);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveSnapshot(TreeSelection selection, ExecutionEvent event) {
        IncQuerySnapshot snapshot;
        ArrayList<PatternMatcherContent> matchers;
        IEditorPart editor;
        block18: {
            Object obj = selection.getFirstElement();
            editor = null;
            matchers = new ArrayList<PatternMatcherContent>();
            IncQueryEngine engine = null;
            if (obj instanceof PatternMatcherContent) {
                PatternMatcherContent observablePatternMatcher = (PatternMatcherContent)obj;
                editor = ((PatternMatcherRootContent)observablePatternMatcher.getParent()).getEditorPart();
                matchers.add(observablePatternMatcher);
                IncQueryMatcher matcher = observablePatternMatcher.getMatcher();
                if (matcher != null) {
                    engine = matcher.getEngine();
                }
            } else if (obj instanceof PatternMatcherRootContent) {
                PatternMatcherRootContent matcherRoot = (PatternMatcherRootContent)obj;
                editor = matcherRoot.getEditorPart();
                Iterator iterator = matcherRoot.getChildrenIterator();
                while (iterator.hasNext()) {
                    PatternMatcherContent patternMatcherContent = (PatternMatcherContent)iterator.next();
                    matchers.add(patternMatcherContent);
                    IncQueryMatcher matcher = patternMatcherContent.getMatcher();
                    if (matcher == null || matcher.getEngine() == null) continue;
                    engine = matcher.getEngine();
                }
            }
            if (engine == null) {
                this.logger.error((Object)"Cannot save snapshot without IncQueryEngine!");
                return;
            }
            ResourceSet resourceSet = this.getResourceSetForNotifier(engine.getEMFRoot());
            if (resourceSet == null) {
                this.logger.error((Object)"Cannot save snapshot, models not in ResourceSet!");
                return;
            }
            IFile snapshotFile = null;
            IFile[] files = WorkspaceResourceDialog.openFileSelection((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"Existing snapshot", (String)"Select existing EMF-IncQuery snapshot file (Cancel for new file)", (boolean)false, null, null);
            snapshot = null;
            if (files.length == 0) {
                snapshotFile = WorkspaceResourceDialog.openNewFile((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"New snapshot", (String)"Select EMF-IncQuery snapshot target file (.eiqsnapshot extension)", null, null);
                if (snapshotFile != null && !snapshotFile.exists()) {
                    snapshot = EIQSnapshotFactory.eINSTANCE.createIncQuerySnapshot();
                    Resource res = resourceSet.createResource(URI.createPlatformResourceURI((String)snapshotFile.getFullPath().toString(), (boolean)true));
                    res.getContents().add((Object)snapshot);
                    break block18;
                } else {
                    this.logger.error((Object)"Selected file name must use .eiqsnapshot extension!");
                    return;
                }
            }
            snapshotFile = files[0];
            if (snapshotFile != null && snapshotFile.getFileExtension().equals("eiqsnapshot")) {
                snapshot = this.loader.loadExpectedResultsFromFile(resourceSet, snapshotFile);
                if (snapshot == null) {
                    this.logger.error((Object)"Selected file does not contain snapshot!");
                    return;
                }
                if (!this.validateInputSpecification(engine, snapshot)) {
                    return;
                }
            } else {
                this.logger.error((Object)"Selected file not .eiqsnapshot!");
                return;
            }
        }
        for (PatternMatcherContent matcher : matchers) {
            if (matcher.getMatcher() == null) continue;
            IPatternMatch filter = matcher.getMatcher().newMatch(matcher.getFilter());
            this.helper.saveMatchesToSnapshot(matcher.getMatcher(), filter, snapshot);
        }
        if (editor != null) {
            editor.doSave((IProgressMonitor)new NullProgressMonitor());
            return;
        }
        try {
            snapshot.eResource().save(null);
            return;
        }
        catch (IOException e) {
            this.logger.error((Object)"Error during saving snapshot into file!", (Throwable)e);
        }
    }

    private boolean validateInputSpecification(IncQueryEngine engine, IncQuerySnapshot snapshot) {
        if (snapshot.getInputSpecification() != null) {
            Notifier root = this.helper.getEMFRootForSnapshot(snapshot);
            Notifier matcherRoot = engine.getEMFRoot();
            if (matcherRoot != root) {
                this.logger.error((Object)("Existing snapshot model root (" + root + ") not equal to selected input (" + matcherRoot + ")!"));
                return false;
            }
            return true;
        }
        return true;
    }

    private ResourceSet getResourceSetForNotifier(Notifier notifier) {
        if (notifier instanceof EObject) {
            Resource resource = ((EObject)notifier).eResource();
            if (resource != null) {
                return resource.getResourceSet();
            }
        } else {
            if (notifier instanceof Resource) {
                return ((Resource)notifier).getResourceSet();
            }
            if (notifier instanceof ResourceSet) {
                return (ResourceSet)notifier;
            }
        }
        return null;
    }
}

