package org.eclipse.incquery.uml.derivedfeatures.util;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.uml.derivedfeatures.NamedElementClientDependencyMatch;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.NamedElement;

/**
 * A match processor tailored for the org.eclipse.incquery.uml.derivedfeatures.namedElementClientDependency pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class NamedElementClientDependencyProcessor implements IMatchProcessor<NamedElementClientDependencyMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pSelf the value of pattern parameter self in the currently processed match
   * @param pD the value of pattern parameter d in the currently processed match
   * 
   */
  public abstract void process(final NamedElement pSelf, final Dependency pD);
  
  @Override
  public void process(final NamedElementClientDependencyMatch match) {
    process(match.getSelf(), match.getD());
  }
}
