/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.databinding.runtime.adapter;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.incquery.databinding.runtime.adapter.ObservableDefinition;
import org.eclipse.incquery.databinding.runtime.api.IncQueryObservables;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.Annotation;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.patternlanguage.patternLanguage.StringValue;
import org.eclipse.incquery.patternlanguage.patternLanguage.Variable;
import org.eclipse.incquery.runtime.api.IPatternMatch;

public final class DatabindingAdapterUtil {
    public static final String OBSERVABLEVALUE_ANNOTATION = "ObservableValue";

    private DatabindingAdapterUtil() {
    }

    @Deprecated
    public static IObservableValue getObservableValue(IPatternMatch match, String expression) {
        return IncQueryObservables.getObservableValue(match, expression);
    }

    @Deprecated
    public static List<IObservableValue> observeFeatures(IPatternMatch match, IValueChangeListener changeListener, String message) {
        return IncQueryObservables.observeFeatures(match, changeListener, message);
    }

    @Deprecated
    public static List<IObservableValue> observeAllAttributes(IValueChangeListener changeListener, Object object) {
        return IncQueryObservables.observeAllAttributes(changeListener, object);
    }

    public static EStructuralFeature getFeature(Object o, String featureName) {
        if (o instanceof EObject) {
            EStructuralFeature feature = ((EObject)o).eClass().getEStructuralFeature(featureName);
            return feature;
        }
        return null;
    }

    public static String getMessage(IPatternMatch match, String message) {
        String[] tokens = message.split("\\$");
        StringBuilder newText = new StringBuilder();
        int i = 0;
        while (i < tokens.length) {
            if (i % 2 == 0) {
                newText.append(tokens[i]);
            } else {
                String[] objectTokens = tokens[i].split("\\.");
                if (objectTokens.length > 0) {
                    Object o = null;
                    EStructuralFeature feature = null;
                    if (objectTokens.length == 1) {
                        o = match.get(objectTokens[0]);
                        feature = DatabindingAdapterUtil.getFeature(o, "name");
                    }
                    if (objectTokens.length == 2) {
                        o = match.get(objectTokens[0]);
                        feature = DatabindingAdapterUtil.getFeature(o, objectTokens[1]);
                    }
                    if (o != null && feature != null) {
                        Object value = ((EObject)o).eGet(feature);
                        if (value != null) {
                            newText.append(value.toString());
                        } else {
                            newText.append("null");
                        }
                    } else if (o != null) {
                        newText.append(o.toString());
                    }
                } else {
                    newText.append("[no such parameter]");
                }
            }
            ++i;
        }
        return newText.toString();
    }

    public static Map<String, ObservableDefinition> calculateObservableValues(Pattern pattern) {
        HashMap propertyMap = Maps.newHashMap();
        for (Variable v : pattern.getParameters()) {
            ObservableDefinition def = new ObservableDefinition(v.getName(), v.getName(), ObservableDefinition.ObservableType.OBSERVABLE_FEATURE);
            propertyMap.put(v.getName(), def);
        }
        for (Annotation annotation : CorePatternLanguageHelper.getAnnotationsByName((Pattern)pattern, (String)OBSERVABLEVALUE_ANNOTATION)) {
            ObservableDefinition.ObservableType type;
            String expr;
            StringValue nameRef = (StringValue)CorePatternLanguageHelper.getFirstAnnotationParameter((Annotation)annotation, (String)"name");
            StringValue exprRef = (StringValue)CorePatternLanguageHelper.getFirstAnnotationParameter((Annotation)annotation, (String)"expression");
            StringValue labelRef = (StringValue)CorePatternLanguageHelper.getFirstAnnotationParameter((Annotation)annotation, (String)"labelExpression");
            if (nameRef == null) {
                Preconditions.checkArgument((exprRef == null && labelRef == null ? 1 : 0) != 0, (Object)"Name attribute must not be empty");
                continue;
            }
            String name = nameRef.getValue();
            Preconditions.checkArgument((boolean)(exprRef != null ^ labelRef != null), (Object)"Either expression or label expression attribute must not be empty.");
            if (exprRef != null) {
                expr = exprRef.getValue();
                type = ObservableDefinition.ObservableType.OBSERVABLE_FEATURE;
            } else {
                expr = labelRef.getValue();
                type = ObservableDefinition.ObservableType.OBSERVABLE_LABEL;
            }
            ObservableDefinition def = new ObservableDefinition(name, expr, type);
            propertyMap.put(name, def);
        }
        return propertyMap;
    }
}

