/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.databinding.runtime.collection;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.set.AbstractObservableSet;
import org.eclipse.core.databinding.observable.set.SetDiff;
import org.eclipse.incquery.databinding.runtime.collection.IObservablePatternMatchCollectionUpdate;
import org.eclipse.incquery.databinding.runtime.collection.ObservableCollectionHelper;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.evm.api.RuleEngine;
import org.eclipse.incquery.runtime.evm.api.RuleSpecification;
import org.eclipse.incquery.runtime.evm.api.event.EventFilter;
import org.eclipse.incquery.runtime.evm.specific.event.IncQueryEventRealm;

public class ObservablePatternMatchSet<Match extends IPatternMatch>
extends AbstractObservableSet {
    private final Set<Match> cache = Collections.synchronizedSet(new HashSet());
    private final SetCollectionUpdate updater = new SetCollectionUpdate();
    private RuleSpecification<Match> specification;

    public <Matcher extends IncQueryMatcher<Match>> ObservablePatternMatchSet(IQuerySpecification<Matcher> querySpecification, IncQueryEngine engine) {
        this((Matcher)querySpecification);
        ObservableCollectionHelper.prepareRuleEngine(engine, this.specification, null);
    }

    public <Matcher extends IncQueryMatcher<Match>> ObservablePatternMatchSet(IQuerySpecification<Matcher> querySpecification, IncQueryEngine engine, Match filter) {
        this((Matcher)querySpecification);
        ObservableCollectionHelper.prepareRuleEngine(engine, this.specification, filter);
    }

    public <Matcher extends IncQueryMatcher<Match>> ObservablePatternMatchSet(IQuerySpecification<Matcher> querySpecification, RuleEngine engine) {
        this((Matcher)querySpecification);
        engine.addRule(this.specification, true);
    }

    public <Matcher extends IncQueryMatcher<Match>> ObservablePatternMatchSet(IQuerySpecification<Matcher> querySpecification, RuleEngine engine, Match filter) {
        this((Matcher)querySpecification);
        engine.addRule(this.specification, true, (EventFilter)IncQueryEventRealm.createFilter(filter));
    }

    protected <Matcher extends IncQueryMatcher<Match>> ObservablePatternMatchSet(IQuerySpecification<Matcher> querySpecification) {
        this.specification = ObservableCollectionHelper.createRuleSpecification(this.updater, querySpecification);
    }

    public <Matcher extends IncQueryMatcher<Match>> ObservablePatternMatchSet(Matcher matcher) {
        this.specification = ObservableCollectionHelper.createRuleSpecification(this.updater, matcher);
        ObservableCollectionHelper.prepareRuleEngine(matcher.getEngine(), this.specification, null);
    }

    public Object getElementType() {
        return IPatternMatch.class;
    }

    protected Set<Match> getWrappedSet() {
        return this.cache;
    }

    protected RuleSpecification<Match> getSpecification() {
        return this.specification;
    }

    public class SetCollectionUpdate
    implements IObservablePatternMatchCollectionUpdate<Match> {
        @Override
        public void addMatch(Match match) {
            ObservablePatternMatchSet.this.cache.add(match);
            SetDiff diff = Diffs.createSetDiff((Set)Sets.newHashSet((Object[])new IPatternMatch[]{match}), (Set)Collections.EMPTY_SET);
            ObservablePatternMatchSet.this.fireSetChange(diff);
        }

        @Override
        public void removeMatch(Match match) {
            ObservablePatternMatchSet.this.cache.remove(match);
            SetDiff diff = Diffs.createSetDiff((Set)Collections.EMPTY_SET, (Set)Sets.newHashSet((Object[])new IPatternMatch[]{match}));
            ObservablePatternMatchSet.this.fireSetChange(diff);
        }
    }
}

