/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.patternlanguage.emf.ui.highlight;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.incquery.patternlanguage.annotations.PatternAnnotationProvider;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.ClassType;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.ReferenceType;
import org.eclipse.incquery.patternlanguage.patternLanguage.Annotation;
import org.eclipse.incquery.patternlanguage.patternLanguage.AnnotationParameter;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XNumberLiteral;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.ui.highlighting.XbaseHighlightingCalculator;

public class EMFPatternLanguageHighlightingCalculator
extends XbaseHighlightingCalculator {
    @Inject
    private PatternAnnotationProvider annotationProvider;

    protected void searchAndHighlightElements(XtextResource resource, IHighlightedPositionAcceptor acceptor) {
        TreeIterator iterator = resource.getAllContents();
        while (iterator.hasNext()) {
            EObject object = (EObject)iterator.next();
            if (object instanceof XAbstractFeatureCall) {
                this.computeFeatureCallHighlighting((XAbstractFeatureCall)object, acceptor);
                continue;
            }
            if (object instanceof XNumberLiteral) {
                this.highlightNumberLiterals((XNumberLiteral)object, acceptor);
                continue;
            }
            if (object instanceof XAnnotation) {
                this.highlightAnnotation((XAnnotation)object, acceptor);
                continue;
            }
            if (object instanceof ClassType || object instanceof ReferenceType) {
                ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)object);
                this.highlightNode((INode)node, "incquery.metamodel.reference", acceptor);
                continue;
            }
            if (object instanceof Annotation && this.annotationProvider.isDeprecated((Annotation)object)) {
                Annotation annotation = (Annotation)object;
                ICompositeNode compositeNode = NodeModelUtils.findActualNodeFor((EObject)annotation);
                ICompositeNode node = null;
                for (ILeafNode leafNode : compositeNode.getLeafNodes()) {
                    if (!leafNode.getText().equals(annotation.getName())) continue;
                    node = leafNode;
                    break;
                }
                node = node == null ? compositeNode : node;
                this.highlightNode((INode)node, "xbase.deprecated.members", acceptor);
                continue;
            }
            if (object instanceof AnnotationParameter && this.annotationProvider.isDeprecated((AnnotationParameter)object)) {
                ICompositeNode compositeNode = NodeModelUtils.findActualNodeFor((EObject)object);
                ICompositeNode node = null;
                for (ILeafNode leafNode : compositeNode.getLeafNodes()) {
                    if (!leafNode.getText().equals(((AnnotationParameter)object).getName())) continue;
                    node = leafNode;
                    break;
                }
                node = node == null ? compositeNode : node;
                this.highlightNode((INode)node, "xbase.deprecated.members", acceptor);
                continue;
            }
            this.computeReferencedJvmTypeHighlighting(acceptor, object);
        }
    }
}

