/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.base.itc.alg.misc.topsort;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.incquery.runtime.base.itc.igraph.IGraphDataSource;

public class TopSort<V> {
    private IGraphDataSource<V> gds;
    private HashMap<Integer, V> forwardNodeMap;
    private HashMap<V, Integer> backwardNodeMap;
    private int nodeCount;
    private int[] visited;
    private int[] finishNumber;
    private int[] depthNumber;
    private int[] sourceNumber;
    private int depthCount = 0;
    private int finishCount = 0;
    private List<V> topologicalSorting = null;

    public TopSort(IGraphDataSource<V> g) {
        this.gds = g;
        this.nodeCount = this.gds.getAllNodes().size();
        this.topologicalSorting = new ArrayList<V>();
        this.visited = new int[this.nodeCount];
        this.finishNumber = new int[this.nodeCount];
        this.depthNumber = new int[this.nodeCount];
        this.sourceNumber = new int[this.nodeCount];
        this.forwardNodeMap = new HashMap();
        this.backwardNodeMap = new HashMap();
        int j = 0;
        for (V n : this.gds.getAllNodes()) {
            this.forwardNodeMap.put(j, n);
            this.backwardNodeMap.put((Integer)n, j);
            ++j;
        }
        int i = 0;
        while (i < this.nodeCount) {
            this.visited[i] = 0;
            this.finishNumber[i] = -1;
            this.depthNumber[i] = -1;
            this.sourceNumber[i] = -1;
            ++i;
        }
    }

    public void doDFS() {
        int i = 0;
        while (i < this.nodeCount) {
            if (this.visited[i] == 0) {
                this.oneDFS(i);
            }
            ++i;
        }
        Collections.reverse(this.topologicalSorting);
    }

    private void oneDFS(int v) {
        this.visited[v] = 1;
        this.depthNumber[v] = ++this.depthCount;
        List<V> targets = this.gds.getTargetNodes(this.forwardNodeMap.get(v));
        if (targets != null) {
            for (V t : targets) {
                int u = this.backwardNodeMap.get(t);
                this.sourceNumber[u] = v;
                if (this.visited[u] != 0) continue;
                this.oneDFS(u);
            }
        }
        this.finishNumber[v] = ++this.finishCount;
        this.topologicalSorting.add(this.forwardNodeMap.get(v));
    }

    public static List<?> getTopologicalSorting(IGraphDataSource<?> g) {
        TopSort da = new TopSort(g);
        da.doDFS();
        return da.topologicalSorting;
    }
}

