package org.eclipse.incquery.uml.derivedfeatures.util;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.uml.derivedfeatures.ClassifierFeatureMatch;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Feature;

/**
 * A match processor tailored for the org.eclipse.incquery.uml.derivedfeatures.classifierFeature pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class ClassifierFeatureProcessor implements IMatchProcessor<ClassifierFeatureMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pSource the value of pattern parameter source in the currently processed match
   * @param pTarget the value of pattern parameter target in the currently processed match
   * 
   */
  public abstract void process(final Classifier pSource, final Feature pTarget);
  
  @Override
  public void process(final ClassifierFeatureMatch match) {
    process(match.getSource(), match.getTarget());
  }
}
