/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewers.runtime.sources;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import org.eclipse.incquery.viewers.runtime.model.Item;
import org.eclipse.incquery.viewers.runtime.model.ViewerState;
import org.eclipse.incquery.viewers.runtime.model.listeners.AbstractViewerStateListener;
import org.eclipse.jface.viewers.AbstractListViewer;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ListContentProvider
extends AbstractViewerStateListener
implements IStructuredContentProvider {
    AbstractListViewer viewer;
    ViewerState state;

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        Preconditions.checkArgument((boolean)(viewer instanceof AbstractListViewer));
        this.viewer = (AbstractListViewer)viewer;
        if (oldInput instanceof ViewerState) {
            ((ViewerState)oldInput).removeStateListener(this);
        }
        if (newInput instanceof ViewerState) {
            this.state = (ViewerState)newInput;
            this.state.addStateListener(this);
        } else if (newInput != null) {
            throw new IllegalArgumentException(String.format("Invalid input type %s for List Viewer.", newInput.getClass().getName()));
        }
    }

    public Object[] getElements(Object inputElement) {
        return Iterables.toArray((Iterable)this.state.getItems(), Item.class);
    }

    @Override
    public void itemAppeared(Item item) {
        this.viewer.add((Object)item);
    }

    @Override
    public void itemDisappeared(Item item) {
        this.viewer.remove((Object)item);
    }

    public void dispose() {
        if (this.state != null) {
            this.state.removeStateListener(this);
        }
    }
}

