/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewers.runtime.model;

import com.google.common.base.Supplier;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.viewers.runtime.model.Containment;
import org.eclipse.incquery.viewers.runtime.model.Edge;
import org.eclipse.incquery.viewers.runtime.model.Item;
import org.eclipse.incquery.viewers.runtime.model.ViewerDataFilter;
import org.eclipse.incquery.viewers.runtime.model.ViewerDataModel;
import org.eclipse.incquery.viewers.runtime.model.ViewerState;
import org.eclipse.incquery.viewers.runtime.model.listeners.IViewerStateListener;

public final class ViewerStateList
extends ViewerState {
    private IObservableList itemList;
    private IObservableList edgeList;
    private IObservableList containmentList;
    private IListChangeListener itemListener = new IListChangeListener(){

        public void handleListChange(ListChangeEvent event) {
            ListDiff diff = event.diff;
            ListDiffEntry[] listDiffEntryArray = diff.getDifferences();
            int n = listDiffEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener;
                int n3;
                int n4;
                Object[] objectArray;
                ListDiffEntry entry = listDiffEntryArray[n2];
                Item item = (Item)entry.getElement();
                if (entry.isAddition()) {
                    objectArray = ViewerStateList.this.stateListeners.getListeners();
                    n4 = objectArray.length;
                    n3 = 0;
                    while (n3 < n4) {
                        listener = objectArray[n3];
                        ((IViewerStateListener)listener).itemAppeared(item);
                        item.getLabel().addChangeListener(ViewerStateList.this.labelChangeListener);
                        ++n3;
                    }
                } else {
                    objectArray = ViewerStateList.this.stateListeners.getListeners();
                    n4 = objectArray.length;
                    n3 = 0;
                    while (n3 < n4) {
                        listener = objectArray[n3];
                        item.getLabel().removeChangeListener(ViewerStateList.this.labelChangeListener);
                        ((IViewerStateListener)listener).itemDisappeared(item);
                        ++n3;
                    }
                }
                ++n2;
            }
        }
    };
    private IListChangeListener edgeListener = new IListChangeListener(){

        public void handleListChange(ListChangeEvent event) {
            ListDiff diff = event.diff;
            ListDiffEntry[] listDiffEntryArray = diff.getDifferences();
            int n = listDiffEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener;
                int n3;
                int n4;
                Object[] objectArray;
                ListDiffEntry entry = listDiffEntryArray[n2];
                Edge edge = (Edge)entry.getElement();
                if (entry.isAddition()) {
                    objectArray = ViewerStateList.this.stateListeners.getListeners();
                    n4 = objectArray.length;
                    n3 = 0;
                    while (n3 < n4) {
                        listener = objectArray[n3];
                        ((IViewerStateListener)listener).edgeAppeared(edge);
                        edge.getLabel().addChangeListener(ViewerStateList.this.labelChangeListener);
                        ++n3;
                    }
                } else {
                    objectArray = ViewerStateList.this.stateListeners.getListeners();
                    n4 = objectArray.length;
                    n3 = 0;
                    while (n3 < n4) {
                        listener = objectArray[n3];
                        edge.getLabel().removeChangeListener(ViewerStateList.this.labelChangeListener);
                        ((IViewerStateListener)listener).edgeDisappeared(edge);
                        ++n3;
                    }
                }
                ++n2;
            }
        }
    };
    private IListChangeListener containmentListener = new IListChangeListener(){

        public void handleListChange(ListChangeEvent event) {
            ListDiff diff = event.diff;
            ListDiffEntry[] listDiffEntryArray = diff.getDifferences();
            int n = listDiffEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                ListDiffEntry entry = listDiffEntryArray[n2];
                Containment edge = (Containment)entry.getElement();
                if (entry.isAddition()) {
                    ViewerStateList.this.containmentAppeared(edge);
                } else {
                    ViewerStateList.this.containmentDisappeared(edge);
                }
                ++n2;
            }
        }
    };

    ViewerStateList(ResourceSet set, IncQueryEngine engine, Collection<Pattern> patterns, ViewerDataFilter filter, Collection<ViewerState.ViewerStateFeature> features) {
        this.model = new ViewerDataModel(set, patterns, engine);
        this.initializeViewerState(this.model, filter, features);
    }

    ViewerStateList(ViewerDataModel model, ViewerDataFilter filter, Collection<ViewerState.ViewerStateFeature> features) {
        this.model = model;
        this.initializeViewerState(model, filter, features);
    }

    private Multimap<Object, Item> initializeItemMap() {
        HashMap map = Maps.newHashMap();
        return Multimaps.newListMultimap((Map)map, (Supplier)new Supplier<List<Item>>(){

            public List<Item> get() {
                ArrayList list = Lists.newArrayList();
                return new WritableList((List)list, Item.class);
            }
        });
    }

    private void initializeViewerState(ViewerDataModel model, ViewerDataFilter filter, Collection<ViewerState.ViewerStateFeature> features) {
        this.itemMap = this.initializeItemMap();
        this.initializeItemList(model.initializeObservableItemList(filter, (Multimap<Object, Item>)this.itemMap));
        for (ViewerState.ViewerStateFeature feature : features) {
            switch (feature) {
                case EDGE: {
                    this.initializeEdgeList((IObservableList)model.initializeObservableEdgeList(filter, (Multimap<Object, Item>)this.itemMap));
                    break;
                }
                case CONTAINMENT: {
                    this.initializeContainmentList((IObservableList)model.initializeObservableContainmentList(filter, (Multimap<Object, Item>)this.itemMap));
                }
            }
        }
    }

    private IObservableList getItemList() {
        return this.itemList;
    }

    @Override
    public IObservableCollection getItems() {
        return this.getItemList();
    }

    private void initializeItemList(IObservableList itemList) {
        Item item;
        if (this.itemList != null) {
            this.removeItemListener(this.itemList);
            for (Object _item : this.itemList) {
                item = (Item)_item;
                item.getLabel().removeChangeListener(this.labelChangeListener);
            }
        }
        this.itemList = itemList;
        this.addItemListener(itemList);
        for (Object _item : itemList) {
            item = (Item)_item;
            item.getLabel().addChangeListener(this.labelChangeListener);
        }
    }

    private void addItemListener(IObservableList _itemList) {
        _itemList.addListChangeListener(this.itemListener);
    }

    private void removeItemListener(IObservableList _oldItemList) {
        _oldItemList.removeListChangeListener(this.itemListener);
    }

    private IObservableList getEdgeList() {
        return this.edgeList;
    }

    @Override
    public IObservableCollection getEdges() {
        return this.getEdgeList();
    }

    private void initializeEdgeList(IObservableList edgeList) {
        Edge edge;
        if (this.edgeList != null) {
            this.removeEdgeListener(this.edgeList);
            for (Object _edge : edgeList) {
                edge = (Edge)_edge;
                edge.getLabel().removeChangeListener(this.labelChangeListener);
            }
        }
        this.edgeList = edgeList;
        this.addEdgeListener(edgeList);
        for (Object _edge : edgeList) {
            edge = (Edge)_edge;
            edge.getLabel().addChangeListener(this.labelChangeListener);
        }
    }

    private void addEdgeListener(IObservableList edgeList) {
        edgeList.addListChangeListener(this.edgeListener);
    }

    private void removeEdgeListener(IObservableList oldEdgeList) {
        oldEdgeList.removeListChangeListener(this.edgeListener);
    }

    private IObservableList getContainmentList() {
        return this.containmentList;
    }

    @Override
    public IObservableCollection getContainments() {
        return this.getContainmentList();
    }

    private void initializeContainmentList(IObservableList containmentList) {
        if (this.containmentList != null) {
            this.removeContainmentListener(this.containmentList);
        }
        this.containmentList = containmentList;
        this.childrenMap = HashMultimap.create();
        this.parentMap = Maps.newHashMap();
        for (Object obj : containmentList) {
            Containment containment = (Containment)obj;
            this.containmentAppeared(containment);
        }
        this.addContainmentListener(containmentList);
    }

    private void containmentAppeared(Containment containment) {
        this.childrenMap.put((Object)containment.getSource(), (Object)containment.getTarget());
        this.parentMap.put(containment.getTarget(), containment.getSource());
        Object[] objectArray = this.stateListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IViewerStateListener)listener).containmentAppeared(containment);
            ++n2;
        }
    }

    private void containmentDisappeared(Containment containment) {
        this.childrenMap.remove((Object)containment.getSource(), (Object)containment.getTarget());
        this.parentMap.remove(containment.getTarget());
        Object[] objectArray = this.stateListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IViewerStateListener)listener).containmentDisappeared(containment);
            ++n2;
        }
    }

    private void addContainmentListener(IObservableList oldContainmentList) {
        oldContainmentList.addListChangeListener(this.containmentListener);
    }

    private void removeContainmentListener(IObservableList oldContainmentList) {
        oldContainmentList.removeListChangeListener(this.containmentListener);
    }
}

