/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.api;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.runtime.api.IPatternGroup;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.impl.BasePatternGroup;

public class GenericPatternGroup
extends BasePatternGroup {
    private final Set<Pattern> patterns;

    public GenericPatternGroup(Set<Pattern> patterns) {
        this.patterns = patterns;
    }

    @Override
    public Set<Pattern> getPatterns() {
        return this.patterns;
    }

    public static IPatternGroup of(Set<IQuerySpecification<?>> querySpecifications) {
        return new GenericPatternGroup(GenericPatternGroup.patterns(querySpecifications));
    }

    public static IPatternGroup of(Pattern ... patterns) {
        return new GenericPatternGroup(new HashSet<Pattern>(Arrays.asList(patterns)));
    }

    public static IPatternGroup of(IQuerySpecification<?> ... querySpecifications) {
        return GenericPatternGroup.of(new HashSet(Arrays.asList(querySpecifications)));
    }

    public static IPatternGroup of(IPatternGroup ... subGroups) {
        HashSet<Pattern> patterns = new HashSet<Pattern>();
        IPatternGroup[] iPatternGroupArray = subGroups;
        int n = subGroups.length;
        int n2 = 0;
        while (n2 < n) {
            IPatternGroup group = iPatternGroupArray[n2];
            patterns.addAll(group.getPatterns());
            ++n2;
        }
        return new GenericPatternGroup(patterns);
    }
}

