/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.internal.matcherbuilder;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.ClassType;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.EClassifierConstraint;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.EnumValue;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.ReferenceType;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.AggregatedValue;
import org.eclipse.incquery.patternlanguage.patternLanguage.AggregatorExpression;
import org.eclipse.incquery.patternlanguage.patternLanguage.BoolValue;
import org.eclipse.incquery.patternlanguage.patternLanguage.CheckConstraint;
import org.eclipse.incquery.patternlanguage.patternLanguage.CompareConstraint;
import org.eclipse.incquery.patternlanguage.patternLanguage.Constraint;
import org.eclipse.incquery.patternlanguage.patternLanguage.CountAggregator;
import org.eclipse.incquery.patternlanguage.patternLanguage.DoubleValue;
import org.eclipse.incquery.patternlanguage.patternLanguage.IntValue;
import org.eclipse.incquery.patternlanguage.patternLanguage.ParameterRef;
import org.eclipse.incquery.patternlanguage.patternLanguage.PathExpressionConstraint;
import org.eclipse.incquery.patternlanguage.patternLanguage.PathExpressionHead;
import org.eclipse.incquery.patternlanguage.patternLanguage.PathExpressionTail;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.patternlanguage.patternLanguage.PatternBody;
import org.eclipse.incquery.patternlanguage.patternLanguage.PatternCall;
import org.eclipse.incquery.patternlanguage.patternLanguage.PatternCompositionConstraint;
import org.eclipse.incquery.patternlanguage.patternLanguage.StringValue;
import org.eclipse.incquery.patternlanguage.patternLanguage.Type;
import org.eclipse.incquery.patternlanguage.patternLanguage.ValueReference;
import org.eclipse.incquery.patternlanguage.patternLanguage.Variable;
import org.eclipse.incquery.patternlanguage.patternLanguage.VariableReference;
import org.eclipse.incquery.patternlanguage.patternLanguage.VariableValue;
import org.eclipse.incquery.runtime.internal.matcherbuilder.XBaseCheck;
import org.eclipse.incquery.runtime.rete.construction.Buildable;
import org.eclipse.incquery.runtime.rete.construction.RetePatternBuildException;
import org.eclipse.incquery.runtime.rete.construction.psystem.PSystem;
import org.eclipse.incquery.runtime.rete.construction.psystem.PVariable;
import org.eclipse.incquery.runtime.rete.construction.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.rete.construction.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.rete.construction.psystem.basicdeferred.Inequality;
import org.eclipse.incquery.runtime.rete.construction.psystem.basicdeferred.NegativePatternCall;
import org.eclipse.incquery.runtime.rete.construction.psystem.basicdeferred.PatternMatchCounter;
import org.eclipse.incquery.runtime.rete.construction.psystem.basicenumerables.BinaryTransitiveClosure;
import org.eclipse.incquery.runtime.rete.construction.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.incquery.runtime.rete.construction.psystem.basicenumerables.TypeBinary;
import org.eclipse.incquery.runtime.rete.construction.psystem.basicenumerables.TypeTernary;
import org.eclipse.incquery.runtime.rete.construction.psystem.basicenumerables.TypeUnary;
import org.eclipse.incquery.runtime.rete.matcher.IPatternMatcherContext;
import org.eclipse.incquery.runtime.rete.tuple.FlatTuple;
import org.eclipse.incquery.runtime.rete.tuple.Tuple;
import org.eclipse.xtext.xbase.XExpression;

public class EPMBodyToPSystem<StubHandle, Collector> {
    protected Pattern pattern;
    protected PatternBody body;
    protected IPatternMatcherContext<Pattern> context;
    protected Buildable<Pattern, StubHandle, Collector> buildable;
    protected PSystem<Pattern, StubHandle, Collector> pSystem;
    String patternFQN;

    public EPMBodyToPSystem(Pattern pattern, PatternBody body, IPatternMatcherContext<Pattern> context, Buildable<Pattern, StubHandle, Collector> buildable) {
        this.pattern = pattern;
        this.body = body;
        this.context = context;
        this.buildable = buildable;
        this.patternFQN = CorePatternLanguageHelper.getFullyQualifiedName((Pattern)pattern);
    }

    public PSystem<Pattern, StubHandle, Collector> toPSystem() throws RetePatternBuildException {
        try {
            if (this.pSystem == null) {
                this.pSystem = new PSystem(this.context, this.buildable, (Object)this.pattern);
                this.preProcessParameters();
                this.gatherBodyConstraints();
            }
            return this.pSystem;
        }
        catch (RetePatternBuildException e) {
            e.setPatternDescription((Object)this.pattern);
            throw e;
        }
    }

    public PVariable[] symbolicParameterArray() throws RetePatternBuildException {
        this.toPSystem();
        EList symParameters = this.pattern.getParameters();
        int arity = symParameters.size();
        PVariable[] result = new PVariable[arity];
        int i = 0;
        while (i < arity) {
            result[i] = this.getPNode((Variable)symParameters.get(i));
            ++i;
        }
        return result;
    }

    protected PVariable getPNode(Variable variable) {
        if (variable instanceof ParameterRef) {
            return this.getPNode(((ParameterRef)variable).getReferredParam());
        }
        return this.pSystem.getOrCreateVariableByName((Object)variable);
    }

    protected PVariable getPNode(VariableReference variable) {
        return this.getPNode(variable.getVariable());
    }

    protected Tuple getPNodeTuple(List<? extends ValueReference> variables) throws RetePatternBuildException {
        Object[] pNodeArray = this.getPNodeArray(variables);
        return new FlatTuple(pNodeArray);
    }

    public PVariable[] getPNodeArray(List<? extends ValueReference> variables) throws RetePatternBuildException {
        int k = 0;
        PVariable[] pNodeArray = new PVariable[variables.size()];
        for (ValueReference valueReference : variables) {
            pNodeArray[k++] = this.getPNode(valueReference);
        }
        return pNodeArray;
    }

    protected PVariable getPNode(ValueReference reference) throws RetePatternBuildException {
        if (reference instanceof VariableValue) {
            return this.getPNode(((VariableValue)reference).getValue());
        }
        if (reference instanceof AggregatedValue) {
            return this.aggregate((AggregatedValue)reference);
        }
        if (reference instanceof IntValue) {
            return this.pSystem.newConstantVariable((Object)((IntValue)reference).getValue());
        }
        if (reference instanceof StringValue) {
            return this.pSystem.newConstantVariable((Object)((StringValue)reference).getValue());
        }
        if (reference instanceof EnumValue) {
            return this.pSystem.newConstantVariable((Object)((EnumValue)reference).getLiteral().getInstance());
        }
        if (reference instanceof DoubleValue) {
            return this.pSystem.newConstantVariable((Object)((DoubleValue)reference).getValue());
        }
        if (reference instanceof BoolValue) {
            Boolean b = ((BoolValue)reference).isValue();
            return this.pSystem.newConstantVariable((Object)b);
        }
        throw new RetePatternBuildException("Unsupported value reference of type {1} from EPackage {2} currently unsupported by pattern builder in pattern {3}.", new String[]{reference != null ? reference.eClass().getName() : "(null)", reference != null ? reference.eClass().getEPackage().getNsURI() : "(null)", this.pattern.getName()}, "Unsupported value expression", (Object)this.pattern);
    }

    protected PVariable newVirtual() {
        return this.pSystem.newVirtualVariable();
    }

    private void preProcessParameters() {
        EList parameters = this.pattern.getParameters();
        for (Variable variable : parameters) {
            new ExportedParameter(this.pSystem, this.getPNode(variable), variable.getName());
            if (variable.getType() == null || !(variable.getType() instanceof ClassType)) continue;
            EClassifier classname = ((ClassType)variable.getType()).getClassname();
            PVariable pNode = this.getPNode(variable);
            new TypeUnary(this.pSystem, pNode, (Object)classname);
        }
    }

    private void gatherBodyConstraints() throws RetePatternBuildException {
        EList constraints = this.body.getConstraints();
        for (Constraint constraint : constraints) {
            this.gatherConstraint(constraint);
        }
    }

    protected void gatherConstraint(Constraint constraint) throws RetePatternBuildException {
        if (constraint instanceof EClassifierConstraint) {
            EClassifierConstraint constraint2 = (EClassifierConstraint)constraint;
            this.gatherClassifierConstraint(constraint2);
        } else if (constraint instanceof PatternCompositionConstraint) {
            PatternCompositionConstraint constraint2 = (PatternCompositionConstraint)constraint;
            this.gatherCompositionConstraint(constraint2);
        } else if (constraint instanceof CompareConstraint) {
            CompareConstraint compare = (CompareConstraint)constraint;
            this.gatherCompareConstraint(compare);
        } else if (constraint instanceof PathExpressionConstraint) {
            PathExpressionConstraint pathExpression = (PathExpressionConstraint)constraint;
            this.gatherPathExpression(pathExpression);
        } else if (constraint instanceof CheckConstraint) {
            CheckConstraint check = (CheckConstraint)constraint;
            this.gatherCheckConstraint(check);
        } else {
            throw new RetePatternBuildException("Unsupported constraint type {1} in pattern {2}.", new String[]{constraint.eClass().getName(), this.patternFQN}, "Unsupported constraint type", (Object)this.pattern);
        }
    }

    protected void gatherCheckConstraint(CheckConstraint check) {
        XExpression expression = check.getExpression();
        new XBaseCheck(this, expression, this.pattern);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void gatherPathExpression(PathExpressionConstraint pathExpression) throws RetePatternBuildException {
        PathExpressionHead head = pathExpression.getHead();
        PVariable currentSrc = this.getPNode(head.getSrc());
        PVariable finalDst = this.getPNode(head.getDst());
        PathExpressionTail currentTail = head.getTail();
        Type headType = head.getType();
        if (!(headType instanceof ClassType)) {
            throw new RetePatternBuildException("Unsupported path expression head type {1} in pattern {2}: {3}", new String[]{headType.eClass().getName(), this.patternFQN, this.typeStr(headType)}, "Unsupported navigation source", (Object)this.pattern);
        }
        EClassifier headClassname = ((ClassType)headType).getClassname();
        new TypeUnary(this.pSystem, currentSrc, (Object)headClassname);
        while (currentTail != null) {
            Type currentPathSegmentType = currentTail.getType();
            currentTail = currentTail.getTail();
            PVariable intermediate = this.newVirtual();
            this.gatherPathSegment(currentPathSegmentType, currentSrc, intermediate);
            currentSrc = intermediate;
        }
        new Equality(this.pSystem, currentSrc, finalDst);
    }

    protected void gatherCompareConstraint(CompareConstraint compare) throws RetePatternBuildException {
        PVariable left = this.getPNode(compare.getLeftOperand());
        PVariable right = this.getPNode(compare.getRightOperand());
        switch (compare.getFeature()) {
            case EQUALITY: {
                new Equality(this.pSystem, left, right);
                break;
            }
            case INEQUALITY: {
                new Inequality(this.pSystem, left, right, false);
            }
        }
    }

    protected void gatherCompositionConstraint(PatternCompositionConstraint constraint) throws RetePatternBuildException {
        PatternCall call = constraint.getCall();
        Pattern patternRef = call.getPatternRef();
        Tuple pNodeTuple = this.getPNodeTuple((List<ValueReference>)call.getParameters());
        if (!call.isTransitive()) {
            if (constraint.isNegative()) {
                new NegativePatternCall(this.pSystem, pNodeTuple, (Object)patternRef);
            } else {
                new PositivePatternCall(this.pSystem, pNodeTuple, (Object)patternRef);
            }
        } else {
            if (pNodeTuple.getSize() != 2) {
                throw new RetePatternBuildException("Transitive closure of {1} in pattern {2} is unsupported because called pattern is not binary.", new String[]{CorePatternLanguageHelper.getFullyQualifiedName((Pattern)patternRef), this.patternFQN}, "Transitive closure only supported for binary patterns.", (Object)this.pattern);
            }
            if (constraint.isNegative()) {
                throw new RetePatternBuildException("Unsupported negated transitive closure of {1} in pattern {2}", new String[]{CorePatternLanguageHelper.getFullyQualifiedName((Pattern)patternRef), this.patternFQN}, "Unsupported negated transitive closure", (Object)this.pattern);
            }
            new BinaryTransitiveClosure(this.pSystem, pNodeTuple, (Object)patternRef);
        }
    }

    protected void gatherClassifierConstraint(EClassifierConstraint constraint) {
        EClassifier classname = ((ClassType)constraint.getType()).getClassname();
        PVariable pNode = this.getPNode(constraint.getVar());
        new TypeUnary(this.pSystem, pNode, (Object)classname);
    }

    protected void gatherPathSegment(Type segmentType, PVariable src, PVariable trg) throws RetePatternBuildException {
        if (segmentType instanceof ReferenceType) {
            EStructuralFeature typeObject = ((ReferenceType)segmentType).getRefname();
            if (this.context.edgeInterpretation() == IPatternMatcherContext.EdgeInterpretation.TERNARY) {
                new TypeTernary(this.pSystem, this.context, this.newVirtual(), src, trg, (Object)typeObject);
            } else {
                new TypeBinary(this.pSystem, this.context, src, trg, (Object)typeObject);
            }
        } else {
            throw new RetePatternBuildException("Unsupported path segment type {1} in pattern {2}: {3}", new String[]{segmentType.eClass().getName(), this.patternFQN, this.typeStr(segmentType)}, "Unsupported navigation step", (Object)this.pattern);
        }
    }

    protected PVariable aggregate(AggregatedValue reference) throws RetePatternBuildException {
        PVariable result = this.newVirtual();
        PatternCall call = reference.getCall();
        Pattern patternRef = call.getPatternRef();
        Tuple pNodeTuple = this.getPNodeTuple((List<ValueReference>)call.getParameters());
        AggregatorExpression aggregator = reference.getAggregator();
        if (!(aggregator instanceof CountAggregator)) {
            throw new RetePatternBuildException("Unsupported aggregator expression type {1} in pattern {2}.", new String[]{aggregator.eClass().getName(), this.patternFQN}, "Unsupported aggregator expression", (Object)this.pattern);
        }
        new PatternMatchCounter(this.pSystem, pNodeTuple, (Object)patternRef, result);
        return result;
    }

    private String typeStr(Type type) {
        return type.getTypename() == null ? "(null)" : type.getTypename();
    }
}

