/**
 * Copyright (c) 2010-2012, Mark Czotter, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Mark Czotter - initial API and implementation
 */
package org.eclipse.incquery.tooling.core.generator.jvmmodel;

import com.google.inject.Inject;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.patternlanguage.patternLanguage.Variable;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.tooling.core.generator.jvmmodel.JavadocInferrer;
import org.eclipse.incquery.tooling.core.generator.util.EMFJvmTypesBuilder;
import org.eclipse.incquery.tooling.core.generator.util.EMFPatternLanguageJvmModelInferrerUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

/**
 * {@link IncQueryMatcher} implementation inferrer.
 * 
 * @author Mark Czotter
 */
@SuppressWarnings("all")
public class PatternMatcherClassInferrer {
  @Inject
  @Extension
  private EMFJvmTypesBuilder _eMFJvmTypesBuilder;
  
  @Inject
  @Extension
  private EMFPatternLanguageJvmModelInferrerUtil _eMFPatternLanguageJvmModelInferrerUtil;
  
  @Inject
  @Extension
  private JavadocInferrer _javadocInferrer;
  
  @Inject
  @Extension
  private TypeReferences types;
  
  /**
   * Infers fields for Match class based on the input 'pattern'.
   */
  public void inferFields(final JvmDeclaredType matchClass, final Pattern pattern) {
    EList<Variable> _parameters = pattern.getParameters();
    for (final Variable variable : _parameters) {
      EList<JvmMember> _members = matchClass.getMembers();
      String _positionConstant = this._eMFPatternLanguageJvmModelInferrerUtil.positionConstant(variable);
      JvmTypeReference _newTypeRef = this._eMFJvmTypesBuilder.newTypeRef(pattern, int.class);
      final Procedure1<JvmField> _function = new Procedure1<JvmField>() {
          public void apply(final JvmField it) {
            it.setStatic(true);
            it.setFinal(true);
            final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
                public void apply(final ITreeAppendable it) {
                  StringConcatenation _builder = new StringConcatenation();
                  EList<Variable> _parameters = pattern.getParameters();
                  int _indexOf = _parameters.indexOf(variable);
                  _builder.append(_indexOf, "");
                  it.append(_builder);
                }
              };
            PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.setInitializer(it, _function);
          }
        };
      JvmField _field = this._eMFJvmTypesBuilder.toField(variable, _positionConstant, _newTypeRef, _function);
      this._eMFJvmTypesBuilder.<JvmField>operator_add(_members, _field);
    }
  }
  
  /**
   * Infers static methods for Matcher class based on the input 'pattern'.
   * NOTE: queryDefinition() will be inferred later, in EMFPatternLanguageJvmModelInferrer
   */
  public boolean inferStaticMethods(final JvmGenericType type, final Pattern pattern, final JvmGenericType matcherClass) {
    EList<JvmMember> _members = matcherClass.getMembers();
    JvmParameterizedTypeReference _createTypeRef = this.types.createTypeRef(matcherClass);
    final Procedure1<JvmOperation> _function = new Procedure1<JvmOperation>() {
        public void apply(final JvmOperation it) {
          it.setStatic(true);
          it.setVisibility(JvmVisibility.PUBLIC);
          CharSequence _javadocMatcherStaticOnEngine = PatternMatcherClassInferrer.this._javadocInferrer.javadocMatcherStaticOnEngine(pattern);
          String _string = _javadocMatcherStaticOnEngine.toString();
          PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
          EList<JvmFormalParameter> _parameters = it.getParameters();
          JvmTypeReference _newTypeRef = PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.newTypeRef(pattern, IncQueryEngine.class);
          JvmFormalParameter _parameter = PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.toParameter(pattern, "engine", _newTypeRef);
          PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
          EList<JvmTypeReference> _exceptions = it.getExceptions();
          JvmTypeReference _newTypeRef_1 = PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.newTypeRef(pattern, IncQueryException.class);
          PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_exceptions, _newTypeRef_1);
          final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
              public void apply(final ITreeAppendable it) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("// check if matcher already exists");
                _builder.newLine();
                String _simpleName = matcherClass.getSimpleName();
                _builder.append(_simpleName, "");
                _builder.append(" matcher = engine.getExistingMatcher(querySpecification());");
                _builder.newLineIfNotEmpty();
                _builder.append("if (matcher == null) {");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("matcher = new ");
                String _simpleName_1 = matcherClass.getSimpleName();
                _builder.append(_simpleName_1, "	");
                _builder.append("(engine);");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("// do not have to \"put\" it into engine.matchers, reportMatcherInitialized() will take care of it");
                _builder.newLine();
                _builder.append("} \t");
                _builder.newLine();
                _builder.append("return matcher;");
                it.append(_builder);
              }
            };
          PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
        }
      };
    JvmOperation _method = this._eMFJvmTypesBuilder.toMethod(pattern, "on", _createTypeRef, _function);
    boolean _add = this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members, _method);
    return _add;
  }
  
  /**
   * Infers constructors for Matcher class based on the input 'pattern'.
   */
  public boolean inferConstructors(final JvmDeclaredType matcherClass, final Pattern pattern) {
    boolean _xblockexpression = false;
    {
      EList<JvmMember> _members = matcherClass.getMembers();
      final Procedure1<JvmConstructor> _function = new Procedure1<JvmConstructor>() {
          public void apply(final JvmConstructor it) {
            String _matcherClassName = PatternMatcherClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.matcherClassName(pattern);
            it.setSimpleName(_matcherClassName);
            EList<JvmAnnotationReference> _annotations = it.getAnnotations();
            JvmAnnotationReference _annotation = PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.toAnnotation(pattern, Deprecated.class);
            PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotation);
            it.setVisibility(JvmVisibility.PUBLIC);
            CharSequence _javadocMatcherConstructorNotifier = PatternMatcherClassInferrer.this._javadocInferrer.javadocMatcherConstructorNotifier(pattern);
            String _string = _javadocMatcherConstructorNotifier.toString();
            PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
            EList<JvmFormalParameter> _parameters = it.getParameters();
            JvmTypeReference _newTypeRef = PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.newTypeRef(pattern, Notifier.class);
            JvmFormalParameter _parameter = PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.toParameter(pattern, "emfRoot", _newTypeRef);
            PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
            EList<JvmTypeReference> _exceptions = it.getExceptions();
            JvmTypeReference _newTypeRef_1 = PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.newTypeRef(pattern, IncQueryException.class);
            PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_exceptions, _newTypeRef_1);
            final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
                public void apply(final ITreeAppendable it) {
                  StringConcatenation _builder = new StringConcatenation();
                  _builder.append("this(");
                  it.append(_builder);
                  PatternMatcherClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.referClass(it, pattern, IncQueryEngine.class);
                  StringConcatenation _builder_1 = new StringConcatenation();
                  _builder_1.append(".on(emfRoot));");
                  it.append(_builder_1);
                }
              };
            PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
          }
        };
      JvmConstructor _constructor = this._eMFJvmTypesBuilder.toConstructor(pattern, _function);
      this._eMFJvmTypesBuilder.<JvmConstructor>operator_add(_members, _constructor);
      EList<JvmMember> _members_1 = matcherClass.getMembers();
      final Procedure1<JvmConstructor> _function_1 = new Procedure1<JvmConstructor>() {
          public void apply(final JvmConstructor it) {
            String _matcherClassName = PatternMatcherClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.matcherClassName(pattern);
            it.setSimpleName(_matcherClassName);
            EList<JvmAnnotationReference> _annotations = it.getAnnotations();
            JvmAnnotationReference _annotation = PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.toAnnotation(pattern, Deprecated.class);
            PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotation);
            it.setVisibility(JvmVisibility.PUBLIC);
            CharSequence _javadocMatcherConstructorEngine = PatternMatcherClassInferrer.this._javadocInferrer.javadocMatcherConstructorEngine(pattern);
            String _string = _javadocMatcherConstructorEngine.toString();
            PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
            EList<JvmFormalParameter> _parameters = it.getParameters();
            JvmTypeReference _newTypeRef = PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.newTypeRef(pattern, IncQueryEngine.class);
            JvmFormalParameter _parameter = PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.toParameter(pattern, "engine", _newTypeRef);
            PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
            EList<JvmTypeReference> _exceptions = it.getExceptions();
            JvmTypeReference _newTypeRef_1 = PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.newTypeRef(pattern, IncQueryException.class);
            PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_exceptions, _newTypeRef_1);
            final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
                public void apply(final ITreeAppendable it) {
                  StringConcatenation _builder = new StringConcatenation();
                  _builder.append("super(engine, querySpecification());");
                  it.append(_builder);
                }
              };
            PatternMatcherClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
          }
        };
      JvmConstructor _constructor_1 = this._eMFJvmTypesBuilder.toConstructor(pattern, _function_1);
      boolean _add = this._eMFJvmTypesBuilder.<JvmConstructor>operator_add(_members_1, _constructor_1);
      _xblockexpression = (_add);
    }
    return _xblockexpression;
  }
}
