/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.construction.quasitree;

import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.incquery.runtime.matchers.planning.SubPlan;
import org.eclipse.incquery.runtime.matchers.planning.helpers.FunctionalDependencyHelper;
import org.eclipse.incquery.runtime.matchers.psystem.PConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.rete.collections.CollectionsFactory;

class JoinCandidate {
    SubPlan primary;
    SubPlan secondary;
    SubPlan joinedPlan;
    Set<PVariable> varPrimary;
    Set<PVariable> varSecondary;
    Set<PVariable> varCommon;
    private Boolean heath;

    JoinCandidate(SubPlan joinedPlan) {
        this.joinedPlan = joinedPlan;
        this.primary = (SubPlan)joinedPlan.getParentPlans().get(0);
        this.secondary = (SubPlan)joinedPlan.getParentPlans().get(1);
        this.varPrimary = this.getPrimary().getVisibleVariables();
        this.varSecondary = this.getSecondary().getVisibleVariables();
        this.varCommon = CollectionsFactory.getSet(this.varPrimary);
        this.varCommon.retainAll(this.varSecondary);
    }

    public SubPlan getPrimary() {
        return this.primary;
    }

    public SubPlan getSecondary() {
        return this.secondary;
    }

    public SubPlan getJoinedPlan() {
        return this.joinedPlan;
    }

    public String toString() {
        return String.valueOf(this.primary.toString()) + " |x| " + this.secondary.toString();
    }

    public Set<PVariable> getVarPrimary() {
        return this.varPrimary;
    }

    public Set<PVariable> getVarSecondary() {
        return this.varSecondary;
    }

    public boolean isTrivial() {
        return this.getPrimary().equals((Object)this.getSecondary());
    }

    public boolean isCheckOnly() {
        return this.varPrimary.containsAll(this.varSecondary) || this.varSecondary.containsAll(this.varPrimary);
    }

    public boolean isDescartes() {
        return Collections.disjoint(this.varPrimary, this.varSecondary);
    }

    public boolean isHeath() {
        if (this.heath == null) {
            HashMap dependencies = new HashMap();
            for (PConstraint pConstraint : this.primary.getAllEnforcedConstraints()) {
                dependencies.putAll(pConstraint.getFunctionalDependencies());
            }
            for (PConstraint pConstraint : this.secondary.getAllEnforcedConstraints()) {
                dependencies.putAll(pConstraint.getFunctionalDependencies());
            }
            Set varCommonClosure = FunctionalDependencyHelper.closureOf(this.varCommon, dependencies);
            this.heath = varCommonClosure.containsAll(this.varPrimary) || varCommonClosure.containsAll(this.varSecondary);
        }
        return this.heath;
    }
}

