package org.eclipse.incquery.uml.derivedfeatures;

import java.util.Arrays;
import java.util.List;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.impl.BasePatternMatch;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.uml.derivedfeatures.util.DeploymentTargetDeployedElementQuerySpecification;
import org.eclipse.uml2.uml.DeploymentTarget;
import org.eclipse.uml2.uml.PackageableElement;

/**
 * Pattern-specific match representation of the org.eclipse.incquery.uml.derivedfeatures.deploymentTargetDeployedElement pattern,
 * to be used in conjunction with {@link DeploymentTargetDeployedElementMatcher}.
 * 
 * <p>Class fields correspond to parameters of the pattern. Fields with value null are considered unassigned.
 * Each instance is a (possibly partial) substitution of pattern parameters,
 * usable to represent a match of the pattern in the result of a query,
 * or to specify the bound (fixed) input parameters when issuing a query.
 * 
 * @see DeploymentTargetDeployedElementMatcher
 * @see DeploymentTargetDeployedElementProcessor
 * 
 */
@SuppressWarnings("all")
public abstract class DeploymentTargetDeployedElementMatch extends BasePatternMatch {
  private DeploymentTarget fSelf;
  
  private PackageableElement fPackageableElement;
  
  private static List<String> parameterNames = makeImmutableList("self", "packageableElement");
  
  private DeploymentTargetDeployedElementMatch(final DeploymentTarget pSelf, final PackageableElement pPackageableElement) {
    this.fSelf = pSelf;
    this.fPackageableElement = pPackageableElement;
  }
  
  @Override
  public Object get(final String parameterName) {
    if ("self".equals(parameterName)) return this.fSelf;
    if ("packageableElement".equals(parameterName)) return this.fPackageableElement;
    return null;
  }
  
  public DeploymentTarget getSelf() {
    return this.fSelf;
  }
  
  public PackageableElement getPackageableElement() {
    return this.fPackageableElement;
  }
  
  @Override
  public boolean set(final String parameterName, final Object newValue) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    if ("self".equals(parameterName) ) {
    	this.fSelf = (org.eclipse.uml2.uml.DeploymentTarget) newValue;
    	return true;
    }
    if ("packageableElement".equals(parameterName) ) {
    	this.fPackageableElement = (org.eclipse.uml2.uml.PackageableElement) newValue;
    	return true;
    }
    return false;
  }
  
  public void setSelf(final DeploymentTarget pSelf) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fSelf = pSelf;
  }
  
  public void setPackageableElement(final PackageableElement pPackageableElement) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fPackageableElement = pPackageableElement;
  }
  
  @Override
  public String patternName() {
    return "org.eclipse.incquery.uml.derivedfeatures.deploymentTargetDeployedElement";
  }
  
  @Override
  public List<String> parameterNames() {
    return DeploymentTargetDeployedElementMatch.parameterNames;
  }
  
  @Override
  public Object[] toArray() {
    return new Object[]{fSelf, fPackageableElement};
  }
  
  @Override
  public DeploymentTargetDeployedElementMatch toImmutable() {
    return isMutable() ? newMatch(fSelf, fPackageableElement) : this;
  }
  
  @Override
  public String prettyPrint() {
    StringBuilder result = new StringBuilder();
    result.append("\"self\"=" + prettyPrintValue(fSelf) + ", ");
    
    result.append("\"packageableElement\"=" + prettyPrintValue(fPackageableElement)
    );
    return result.toString();
  }
  
  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((fSelf == null) ? 0 : fSelf.hashCode());
    result = prime * result + ((fPackageableElement == null) ? 0 : fPackageableElement.hashCode());
    return result;
  }
  
  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
    	return true;
    if (!(obj instanceof DeploymentTargetDeployedElementMatch)) { // this should be infrequent
    	if (obj == null) {
    		return false;
    	}
    	if (!(obj instanceof IPatternMatch)) {
    		return false;
    	}
    	IPatternMatch otherSig  = (IPatternMatch) obj;
    	if (!specification().equals(otherSig.specification()))
    		return false;
    	return Arrays.deepEquals(toArray(), otherSig.toArray());
    }
    DeploymentTargetDeployedElementMatch other = (DeploymentTargetDeployedElementMatch) obj;
    if (fSelf == null) {if (other.fSelf != null) return false;}
    else if (!fSelf.equals(other.fSelf)) return false;
    if (fPackageableElement == null) {if (other.fPackageableElement != null) return false;}
    else if (!fPackageableElement.equals(other.fPackageableElement)) return false;
    return true;
  }
  
  @Override
  public DeploymentTargetDeployedElementQuerySpecification specification() {
    try {
    	return DeploymentTargetDeployedElementQuerySpecification.instance();
    } catch (IncQueryException ex) {
     	// This cannot happen, as the match object can only be instantiated if the query specification exists
     	throw new IllegalStateException (ex);
    }
  }
  
  /**
   * Returns an empty, mutable match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @return the empty match.
   * 
   */
  public static DeploymentTargetDeployedElementMatch newEmptyMatch() {
    return new Mutable(null, null);
  }
  
  /**
   * Returns a mutable (partial) match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pPackageableElement the fixed value of pattern parameter packageableElement, or null if not bound.
   * @return the new, mutable (partial) match object.
   * 
   */
  public static DeploymentTargetDeployedElementMatch newMutableMatch(final DeploymentTarget pSelf, final PackageableElement pPackageableElement) {
    return new Mutable(pSelf, pPackageableElement);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pPackageableElement the fixed value of pattern parameter packageableElement, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public static DeploymentTargetDeployedElementMatch newMatch(final DeploymentTarget pSelf, final PackageableElement pPackageableElement) {
    return new Immutable(pSelf, pPackageableElement);
  }
  
  private static final class Mutable extends DeploymentTargetDeployedElementMatch {
    Mutable(final DeploymentTarget pSelf, final PackageableElement pPackageableElement) {
      super(pSelf, pPackageableElement);
    }
    
    @Override
    public boolean isMutable() {
      return true;
    }
  }
  
  private static final class Immutable extends DeploymentTargetDeployedElementMatch {
    Immutable(final DeploymentTarget pSelf, final PackageableElement pPackageableElement) {
      super(pSelf, pPackageableElement);
    }
    
    @Override
    public boolean isMutable() {
      return false;
    }
  }
}
