/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.lib.util;

import com.sun.ts.lib.util.TestUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public class ConfigUtil {
    public static final File PROPS_DIR = new File(System.getProperty("TS_HOME", System.getProperty("ts.home")) + File.separator + "src" + File.separator + "com" + File.separator + "sun" + File.separator + "ts" + File.separator + "lib", "harness");
    public static final File SRC_DIR = new File(System.getProperty("TS_HOME", System.getProperty("ts.home")), "src");
    public static final String INTEROP_DIRECTION_PROP_FILE_NAME = "interop-direction.properties";

    public static String[] getMappingValue(Properties mapping, String[] keys, String relativePath) {
        String forwardSlashRelativePath = relativePath.replace(File.separator, "/");
        for (int i = keys.length - 1; i >= 0; --i) {
            if (!forwardSlashRelativePath.startsWith(keys[i])) continue;
            return ConfigUtil.stringToArray(mapping.getProperty(keys[i]));
        }
        return TestUtil.EMPTY_STRING_ARRAY;
    }

    public static String[] loadKeysFrom(Properties mapping) {
        Object[] keys = null;
        if (mapping != null) {
            keys = new String[mapping.size()];
            int i = 0;
            Enumeration<Object> enum1 = mapping.keys();
            while (enum1.hasMoreElements()) {
                keys[i] = (String)enum1.nextElement();
                ++i;
            }
            Arrays.sort(keys);
        }
        return keys;
    }

    public static String[] stringToArray(String s) {
        if (s == null) {
            return TestUtil.EMPTY_STRING_ARRAY;
        }
        StringTokenizer st = new StringTokenizer(s, " ,;\t\r\n\f");
        int tokenCount = st.countTokens();
        if (tokenCount == 0) {
            return TestUtil.EMPTY_STRING_ARRAY;
        }
        String[] result = new String[tokenCount];
        int i = 0;
        while (st.hasMoreTokens()) {
            result[i] = st.nextToken();
            ++i;
        }
        return result;
    }

    public static Properties loadPropertiesFor(String propFileName) {
        File propFile = propFileName.equals("vehicle.properties") ? new File(SRC_DIR, propFileName) : new File(PROPS_DIR, propFileName);
        Properties props = null;
        String propPath = propFile.getPath();
        if (propFile.exists()) {
            props = new Properties();
            try {
                System.out.println("Loading " + propPath);
                props.load(new FileInputStream(propFile));
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return props;
    }
}

