/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.tool.Command;
import com.sun.javatest.tool.CommandContext;
import com.sun.javatest.tool.CommandManager;
import com.sun.javatest.tool.ConfigManager;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.LineParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.net.URLDecoder;
import java.util.ListIterator;

public class CommandParser {
    private CommandManager[] mgrs;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(CommandParser.class);
    static final String TRACE_PREFIX = "+ ";

    public CommandParser(CommandManager[] mgrs) {
        this.mgrs = mgrs;
    }

    public void parse(String[] args, CommandContext ctx) throws Fault {
        this.parse(args, false, ctx);
    }

    public void parse(String[] args, boolean urlEncoded, CommandContext ctx) throws Fault {
        if (urlEncoded) {
            for (int i = 0; i < args.length; ++i) {
                try {
                    args[i] = URLDecoder.decode(args[i], "UTF-8");
                    continue;
                }
                catch (Throwable e) {
                    throw new Fault(i18n, "cmdp.cantDecode", new Object[]{args[i], e.toString()});
                }
            }
        }
        ListIterator iter = CommandParser.getIterator(CommandParser.trim(args));
        while (iter.hasNext()) {
            String arg = (String)iter.next();
            this.decodeArg(arg, iter, ctx);
        }
    }

    private void decodeArg(String arg, ListIterator argIter, CommandContext ctx) throws Fault {
        if (arg.equals("/?")) {
            arg = "-?";
        }
        if (arg.startsWith("@")) {
            File file = new File(arg.substring(1));
            this.read(file, ctx);
            return;
        }
        if (arg.startsWith("-")) {
            String cmd = arg.substring(1);
            if (cmd.equals("read")) {
                if (argIter.hasNext()) {
                    String arg2 = (String)argIter.next();
                    File f = new File(arg2);
                    this.read(f, ctx);
                    return;
                }
                throw new Fault(i18n, "cmdp.badReadOpt");
            }
            for (int i = 0; i < this.mgrs.length; ++i) {
                CommandManager m = this.mgrs[i];
                try {
                    if (!m.parseCommand(cmd, argIter, ctx)) continue;
                    return;
                }
                catch (Command.Fault e) {
                    throw new Fault(e);
                }
            }
            throw new Fault(i18n, "cmdp.badOpt", arg);
        }
        if (arg.indexOf(" ") >= 0) {
            try {
                LineParser p = new LineParser(new StringReader(arg));
                this.read(p, ctx);
                return;
            }
            catch (LineParser.Fault e) {
                throw new Fault(i18n, "cmdp.errorInString", e.getMessage());
            }
        }
        if (!argIter.hasNext()) {
            try {
                File file = new File(arg);
                if (file.exists()) {
                    ctx.addCommand(ConfigManager.getOpenCommand(file));
                    return;
                }
            }
            catch (Command.Fault e) {
                throw new Fault(i18n, "cmdp.badFileOpt", e.getMessage());
            }
        }
        throw new Fault(i18n, "cmdp.badOpt", arg);
    }

    private void read(File file, CommandContext ctx) throws Fault {
        LineParser p;
        try {
            p = new LineParser(file);
        }
        catch (FileNotFoundException e) {
            throw new Fault(i18n, "cmdp.cantFindFile", file);
        }
        catch (IOException e) {
            throw new Fault(i18n, "cmdp.cantOpenFile", new Object[]{file, e});
        }
        try {
            this.read(p, ctx);
        }
        catch (Fault e) {
            throw new Fault(i18n, "cmdp.errorInFile", new Object[]{file, new Integer(p.getLineNumber()), e.getMessage()});
        }
        catch (LineParser.Fault e) {
            throw new Fault(i18n, "cmdp.errorInFile", new Object[]{file, new Integer(p.getLineNumber()), e.getMessage()});
        }
    }

    private void read(LineParser p, CommandContext ctx) throws Fault, LineParser.Fault {
        String[] line;
        File file = p.getFile();
        block2: while ((line = p.readLine()) != null) {
            ListIterator iter = CommandParser.getIterator(line);
            String cmd = (String)iter.next();
            if (cmd.equals("read")) {
                if (iter.hasNext()) {
                    String arg = (String)iter.next();
                    File f = new File(arg);
                    if (!f.isAbsolute()) {
                        f = new File(file.getParentFile(), f.getPath());
                    }
                    if (!iter.hasNext()) {
                        this.read(f, ctx);
                        continue;
                    }
                }
                throw new Fault(i18n, "cmdp.badReadCmd");
            }
            for (int i = 0; i < this.mgrs.length; ++i) {
                CommandManager m = this.mgrs[i];
                try {
                    if (!m.parseCommand(cmd, iter, ctx)) continue;
                    if (!iter.hasNext()) continue block2;
                    throw new Fault(i18n, "cmdp.excessArgs", cmd);
                }
                catch (Command.Fault e) {
                    throw new Fault(e);
                }
            }
            throw new Fault(i18n, "cmdp.badCmd", cmd);
        }
    }

    private static String[] trim(String[] args) {
        String[] trimArgs = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            trimArgs[i] = args[i].trim();
        }
        return trimArgs;
    }

    private static ListIterator getIterator(final String[] args) {
        return new ListIterator(){
            private int index;

            public void add(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                return this.index < args.length;
            }

            @Override
            public boolean hasPrevious() {
                return this.index > 0;
            }

            @Override
            public Object next() {
                return this.index < args.length ? args[this.index++] : null;
            }

            @Override
            public int nextIndex() {
                return this.index;
            }

            public Object previous() {
                return this.index > 0 ? args[--this.index] : null;
            }

            @Override
            public int previousIndex() {
                return this.index - 1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void set(Object obj) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public class Fault
    extends Exception {
        Fault(I18NResourceBundle i18n, String key) {
            super(i18n.getString(key));
        }

        Fault(I18NResourceBundle i18n, String key, Object arg) {
            super(i18n.getString(key, arg));
        }

        Fault(I18NResourceBundle i18n, String key, Object[] args) {
            super(i18n.getString(key, args));
        }

        Fault(Command.Fault e) {
            super(e.getMessage(), e);
        }
    }
}

