/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.api.converter;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.client.api.converter.exceptions.InvalidNodeNameException;
import org.eclipse.jubula.client.api.converter.utils.ProjectCache;
import org.eclipse.jubula.client.api.converter.utils.Utils;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.tools.internal.exception.JBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeInfo {
    private static Map<String, NodeInfo> uuidToClassNameMap;
    private String m_className;
    private String m_packageBasePath;
    private INodePO m_node;
    private String m_defaultToolkit;
    private String m_fqName;
    private String m_packageName;
    private String m_projectName;
    private String m_fileName;
    private String m_fqFileName;

    public NodeInfo(String fqFileName, INodePO node, String packageBasePath, String defaultToolkit) {
        this.m_fqFileName = fqFileName;
        this.m_fileName = StringUtils.substringBeforeLast((String)this.m_fqFileName, (String)".java");
        this.m_className = StringUtils.substringAfterLast((String)this.m_fileName, (String)"/");
        this.m_node = node;
        this.m_packageBasePath = packageBasePath;
        this.m_defaultToolkit = defaultToolkit;
        Logger log = LoggerFactory.getLogger(NodeInfo.class);
        IProjectPO project = null;
        try {
            project = ProjectCache.get(node.getParentProjectId());
        }
        catch (JBException jBException) {
            Plugin.getDefault().writeErrorLineToConsole("Error while loading project.", true);
        }
        try {
            this.m_projectName = Utils.translateToPackageName((INodePO)project);
        }
        catch (InvalidNodeNameException e) {
            log.error(e.getLocalizedMessage());
        }
        this.m_fqName = Utils.getFullyQualifiedTranslatedName(node, this.m_packageBasePath, this.m_projectName);
        this.m_packageName = StringUtils.substringBeforeLast((String)this.m_fqName, (String)".");
    }

    public String getClassName() {
        return this.m_className;
    }

    public String getPackageBasePath() {
        return this.m_packageBasePath;
    }

    public INodePO getNode() {
        return this.m_node;
    }

    public String getDefaultToolkit() {
        return this.m_defaultToolkit;
    }

    public String getFqName() {
        return this.m_fqName;
    }

    public String getPackageName() {
        return this.m_packageName;
    }

    public String getProjectName() {
        return this.m_projectName;
    }

    public String getFqFileName() {
        return this.m_fqFileName;
    }

    public static Map<String, NodeInfo> getUuidToNodeInfoMap() {
        return uuidToClassNameMap;
    }

    public static void setUuidToNodeInfoMap(Map<String, NodeInfo> map) {
        uuidToClassNameMap = map;
    }
}

