/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.command.po.builder;

import org.eclipse.keyple.calypso.command.PoClass;
import org.eclipse.keyple.calypso.command.po.CalypsoPoCommands;
import org.eclipse.keyple.calypso.command.po.PoCommandBuilder;
import org.eclipse.keyple.calypso.command.po.PoModificationCommand;
import org.eclipse.keyple.calypso.command.po.PoSendableInSession;

public final class IncreaseCmdBuild
extends PoCommandBuilder
implements PoSendableInSession,
PoModificationCommand {
    private static final CalypsoPoCommands command = CalypsoPoCommands.INCREASE;

    public IncreaseCmdBuild(PoClass poClass, byte sfi, byte counterNumber, int incValue, String extraInfo) throws IllegalArgumentException {
        super(command, null);
        if (counterNumber < 1) {
            throw new IllegalArgumentException("Counter number out of range!");
        }
        if (incValue < 0 || incValue > 0xFFFFFF) {
            throw new IllegalArgumentException("Increment value out of range!");
        }
        byte[] incValueBuffer = new byte[]{(byte)(incValue >> 16 & 0xFF), (byte)(incValue >> 8 & 0xFF), (byte)(incValue & 0xFF)};
        byte p2 = (byte)(sfi * 8);
        this.request = this.setApduRequest(poClass.getValue(), command, counterNumber, p2, incValueBuffer, (byte)0);
        if (extraInfo != null) {
            this.addSubName(extraInfo);
        }
    }
}

