/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.command.po.parser;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.keyple.command.AbstractApduResponseParser;

public final class IncreaseRespPars
extends AbstractApduResponseParser {
    private static final Map<Integer, AbstractApduResponseParser.StatusProperties> STATUS_TABLE;

    protected Map<Integer, AbstractApduResponseParser.StatusProperties> getStatusTable() {
        return STATUS_TABLE;
    }

    public int getNewValue() throws IllegalStateException {
        byte[] newValueBuffer = this.getApduResponse().getDataOut();
        if (newValueBuffer.length == 3) {
            return (newValueBuffer[0] << 16) + (newValueBuffer[1] << 8) + newValueBuffer[2];
        }
        throw new IllegalStateException("No counter value available in response to the Increase command.");
    }

    public String toString() {
        return String.format("New counter value: %d", this.getNewValue());
    }

    static {
        HashMap<Integer, AbstractApduResponseParser.StatusProperties> m = new HashMap<Integer, AbstractApduResponseParser.StatusProperties>(AbstractApduResponseParser.STATUS_TABLE);
        m.put(25600, new AbstractApduResponseParser.StatusProperties(false, "Too many modifications in session."));
        m.put(26368, new AbstractApduResponseParser.StatusProperties(false, "Lc value not supported."));
        m.put(27009, new AbstractApduResponseParser.StatusProperties(false, "The current EF is not a Counters or Simulated Counter EF."));
        m.put(27010, new AbstractApduResponseParser.StatusProperties(false, "Security conditions not fulfilled (no session, wrong key, encryption required)."));
        m.put(27013, new AbstractApduResponseParser.StatusProperties(false, "Access forbidden (Never access mode, DF is invalidated, etc.)"));
        m.put(27014, new AbstractApduResponseParser.StatusProperties(false, "Command not allowed (no current EF)."));
        m.put(27264, new AbstractApduResponseParser.StatusProperties(false, "Overflow error."));
        m.put(27266, new AbstractApduResponseParser.StatusProperties(false, "File not found."));
        m.put(27392, new AbstractApduResponseParser.StatusProperties(false, "P1 or P2 value not supported."));
        m.put(24835, new AbstractApduResponseParser.StatusProperties(true, "Successful execution."));
        m.put(36864, new AbstractApduResponseParser.StatusProperties(true, "Successful execution."));
        STATUS_TABLE = m;
    }
}

