/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.command.po.parser;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.keyple.calypso.command.po.parser.ReadDataStructure;
import org.eclipse.keyple.command.AbstractApduResponseParser;
import org.eclipse.keyple.util.ByteArrayUtils;

public final class ReadRecordsRespPars
extends AbstractApduResponseParser {
    private static final Map<Integer, AbstractApduResponseParser.StatusProperties> STATUS_TABLE;
    private ReadDataStructure readDataStructure;
    private byte recordNumber;

    protected Map<Integer, AbstractApduResponseParser.StatusProperties> getStatusTable() {
        return STATUS_TABLE;
    }

    public ReadRecordsRespPars(byte recordNumber, ReadDataStructure readDataStructure) {
        this.recordNumber = recordNumber;
        this.readDataStructure = readDataStructure;
    }

    public boolean isCounterFile() {
        return this.readDataStructure == ReadDataStructure.SINGLE_COUNTER || this.readDataStructure == ReadDataStructure.MULTIPLE_COUNTER;
    }

    public SortedMap<Integer, byte[]> getRecords() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Parser not initialized.");
        }
        TreeMap<Integer, byte[]> records = new TreeMap<Integer, byte[]>();
        if (!this.response.isSuccessful()) {
            return records;
        }
        if (this.readDataStructure == ReadDataStructure.SINGLE_RECORD_DATA) {
            records.put(Integer.valueOf(this.recordNumber), this.response.getDataOut());
        } else if (this.readDataStructure == ReadDataStructure.MULTIPLE_RECORD_DATA) {
            byte[] apdu = this.response.getDataOut();
            int apduLen = apdu.length;
            int index = 0;
            while (apduLen > 0) {
                byte recordNb = apdu[index++];
                byte len = apdu[index++];
                records.put(Integer.valueOf(recordNb), Arrays.copyOfRange(apdu, index, index + len));
                index += len;
                apduLen = apduLen - 2 - len;
            }
        } else {
            throw new IllegalStateException("The file is a counter file.");
        }
        return records;
    }

    public SortedMap<Integer, Integer> getCounters() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Parser not initialized.");
        }
        TreeMap<Integer, Integer> counters = new TreeMap<Integer, Integer>();
        if (!this.response.isSuccessful()) {
            return counters;
        }
        if (this.readDataStructure == ReadDataStructure.SINGLE_COUNTER || this.readDataStructure == ReadDataStructure.MULTIPLE_COUNTER) {
            byte[] apdu = this.response.getDataOut();
            int numberOfCounters = apdu.length / 3;
            int index = 0;
            int key = 1;
            for (int i = 0; i < numberOfCounters; ++i) {
                int counterValue = (apdu[index + 0] & 0xFF) * 65536 + (apdu[index + 1] & 0xFF) * 256 + (apdu[index + 2] & 0xFF);
                counters.put(key++, counterValue);
                index += 3;
            }
        } else {
            throw new IllegalStateException("The file is a data file.");
        }
        return counters;
    }

    public String toString() {
        String string;
        block9: {
            block8: {
                if (!this.isInitialized()) break block8;
                switch (this.readDataStructure) {
                    case SINGLE_RECORD_DATA: {
                        SortedMap<Integer, byte[]> recordMap = this.getRecords();
                        string = String.format("Single record data: {RECORD = %d, DATA = %s}", recordMap.firstKey(), ByteArrayUtils.toHex((byte[])((byte[])recordMap.get(recordMap.firstKey()))));
                        break block9;
                    }
                    case MULTIPLE_RECORD_DATA: {
                        SortedMap<Integer, byte[]> recordMap = this.getRecords();
                        StringBuilder sb = new StringBuilder();
                        sb.append("Multiple record data: ");
                        Set<Integer> records = recordMap.keySet();
                        Iterator<Integer> it = records.iterator();
                        while (it.hasNext()) {
                            Integer record = it.next();
                            sb.append(String.format("{RECORD = %d, DATA = %s}", record, ByteArrayUtils.toHex((byte[])((byte[])recordMap.get(record)))));
                            if (!it.hasNext()) continue;
                            sb.append(", ");
                        }
                        string = sb.toString();
                        break block9;
                    }
                    case SINGLE_COUNTER: {
                        SortedMap<Integer, Integer> counterMap = this.getCounters();
                        string = String.format("Single counter: {COUNTER = %d, VALUE = %d}", counterMap.firstKey(), counterMap.get(counterMap.firstKey()));
                        break block9;
                    }
                    case MULTIPLE_COUNTER: {
                        SortedMap<Integer, Integer> counterMap = this.getCounters();
                        StringBuilder sb = new StringBuilder();
                        sb.append("Multiple counter: ");
                        Set<Integer> counters = counterMap.keySet();
                        Iterator<Integer> it = counters.iterator();
                        while (it.hasNext()) {
                            Integer counter = it.next();
                            sb.append(String.format("{COUNTER = %d, VALUE = %d}", counter, counterMap.get(counter)));
                            if (!it.hasNext()) continue;
                            sb.append(", ");
                        }
                        string = sb.toString();
                        break block9;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected data structure");
                    }
                }
            }
            string = "Not initialized.";
        }
        return string;
    }

    static {
        HashMap<Integer, AbstractApduResponseParser.StatusProperties> m = new HashMap<Integer, AbstractApduResponseParser.StatusProperties>(AbstractApduResponseParser.STATUS_TABLE);
        m.put(27009, new AbstractApduResponseParser.StatusProperties(false, "Command forbidden on binary files"));
        m.put(27010, new AbstractApduResponseParser.StatusProperties(false, "Security conditions not fulfilled (PIN code not presented, encryption required)."));
        m.put(27013, new AbstractApduResponseParser.StatusProperties(false, "Access forbidden (Never access mode, stored value log file and a stored value operation was done during the current session)."));
        m.put(27014, new AbstractApduResponseParser.StatusProperties(false, "Command not allowed (no current EF)"));
        m.put(27266, new AbstractApduResponseParser.StatusProperties(false, "File not found"));
        m.put(27267, new AbstractApduResponseParser.StatusProperties(false, "Record not found (record index is 0, or above NumRec"));
        m.put(27392, new AbstractApduResponseParser.StatusProperties(false, "P2 value not supported"));
        m.put(27903, new AbstractApduResponseParser.StatusProperties(false, "Le value incorrect"));
        m.put(36864, new AbstractApduResponseParser.StatusProperties(true, "Successful execution."));
        STATUS_TABLE = m;
    }
}

