/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.command;

import org.eclipse.keyple.command.AbstractApduResponseParser;
import org.eclipse.keyple.command.CommandsTable;
import org.eclipse.keyple.seproxy.message.ApduRequest;

public abstract class AbstractApduCommandBuilder {
    private String name;
    private Class<? extends AbstractApduResponseParser> commandParserClass;
    protected ApduRequest request;

    public AbstractApduCommandBuilder(CommandsTable commandReference, ApduRequest request) {
        this.name = commandReference.getName();
        this.commandParserClass = commandReference.getResponseParserClass();
        this.request = request;
        if (request != null) {
            this.request.setName(commandReference.getName());
        }
    }

    public AbstractApduCommandBuilder(String name, ApduRequest request) {
        this.name = name;
        this.request = request;
        this.commandParserClass = null;
        if (request != null) {
            this.request.setName(name);
        }
    }

    public final void addSubName(String subName) {
        if (subName.length() != 0) {
            this.name = this.name + " - " + subName;
            if (this.request != null) {
                this.request.setName(this.name);
            }
        }
    }

    public final String getName() {
        return this.name;
    }

    public final Class<? extends AbstractApduResponseParser> getApduResponseParserClass() {
        return this.commandParserClass;
    }

    public final ApduRequest getApduRequest() {
        return this.request;
    }
}

