package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * {@code ImmutableResourceSpec} contains immutable implementation classes generated from
 * abstract value types defined as nested inside {@link ResourceSpec}.
 * @see ImmutableResourceSpec.NamedResourceSpec
 * @see ImmutableResourceSpec.DiscreteResourceSpec
 */
@SuppressWarnings({"all"})
final class ImmutableResourceSpec {
  private ImmutableResourceSpec() {}

  /**
   * Immutable implementation of {@link ResourceSpec.NamedResourceSpec}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableResourceSpec.NamedResourceSpec.builder()}.
   */
  static final class NamedResourceSpec
      implements ResourceSpec.NamedResourceSpec {
    private final String kind;
    private final String value;

    private NamedResourceSpec(String kind, String value) {
      this.kind = kind;
      this.value = value;
    }

    /**
     * @return The value of the {@code kind} attribute
     */
    @JsonProperty("Kind")
    @Override
    public String kind() {
      return kind;
    }

    /**
     * @return The value of the {@code value} attribute
     */
    @JsonProperty("Value")
    @Override
    public String value() {
      return value;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link ResourceSpec.NamedResourceSpec#kind() kind} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for kind
     * @return A modified copy or the {@code this} object
     */
    public final ImmutableResourceSpec.NamedResourceSpec withKind(String value) {
      String newValue = Objects.requireNonNull(value, "kind");
      if (this.kind.equals(newValue)) return this;
      return new ImmutableResourceSpec.NamedResourceSpec(newValue, this.value);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link ResourceSpec.NamedResourceSpec#value() value} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for value
     * @return A modified copy or the {@code this} object
     */
    public final ImmutableResourceSpec.NamedResourceSpec withValue(String value) {
      String newValue = Objects.requireNonNull(value, "value");
      if (this.value.equals(newValue)) return this;
      return new ImmutableResourceSpec.NamedResourceSpec(this.kind, newValue);
    }

    /**
     * This instance is equal to all instances of {@code NamedResourceSpec} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(Object another) {
      if (this == another) return true;
      return another instanceof ImmutableResourceSpec.NamedResourceSpec
          && equalsByValue((ImmutableResourceSpec.NamedResourceSpec) another);
    }

    private boolean equalsByValue(ImmutableResourceSpec.NamedResourceSpec another) {
      return kind.equals(another.kind)
          && value.equals(another.value);
    }

    /**
     * Computes a hash code from attributes: {@code kind}, {@code value}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + kind.hashCode();
      h += (h << 5) + value.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code NamedResourceSpec} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "NamedResourceSpec{"
          + "kind=" + kind
          + ", value=" + value
          + "}";
    }

    /**
     * Creates an immutable copy of a {@link ResourceSpec.NamedResourceSpec} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable NamedResourceSpec instance
     */
    public static ImmutableResourceSpec.NamedResourceSpec copyOf(ResourceSpec.NamedResourceSpec instance) {
      if (instance instanceof ImmutableResourceSpec.NamedResourceSpec) {
        return (ImmutableResourceSpec.NamedResourceSpec) instance;
      }
      return ImmutableResourceSpec.NamedResourceSpec.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableResourceSpec.NamedResourceSpec NamedResourceSpec}.
     * <pre>
     * ImmutableResourceSpec.NamedResourceSpec.builder()
     *    .kind(String) // required {@link ResourceSpec.NamedResourceSpec#kind() kind}
     *    .value(String) // required {@link ResourceSpec.NamedResourceSpec#value() value}
     *    .build();
     * </pre>
     * @return A new NamedResourceSpec builder
     */
    public static ImmutableResourceSpec.NamedResourceSpec.Builder builder() {
      return new ImmutableResourceSpec.NamedResourceSpec.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableResourceSpec.NamedResourceSpec NamedResourceSpec}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @JsonTypeName("NamedResourceSpec")
    static final class Builder implements ResourceSpec.NamedResourceSpec.Builder {
      private static final long INIT_BIT_KIND = 0x1L;
      private static final long INIT_BIT_VALUE = 0x2L;
      private long initBits = 0x3L;

      private String kind;
      private String value;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.mandas.docker.client.messages.swarm.ResourceSpec} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(ResourceSpec instance) {
        Objects.requireNonNull(instance, "instance");
        mergeInternal(instance);
        return this;
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.mandas.docker.client.messages.swarm.ResourceSpec.NamedResourceSpec} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(ResourceSpec.NamedResourceSpec instance) {
        Objects.requireNonNull(instance, "instance");
        mergeInternal(instance);
        return this;
      }

      private void mergeInternal(Object object) {
        long bits = 0;
        if (object instanceof ResourceSpec) {
          ResourceSpec instance = (ResourceSpec) object;
          if ((bits & 0x1L) == 0) {
            this.kind(instance.kind());
            bits |= 0x1L;
          }
        }
        if (object instanceof ResourceSpec.NamedResourceSpec) {
          ResourceSpec.NamedResourceSpec instance = (ResourceSpec.NamedResourceSpec) object;
          this.value(instance.value());
          if ((bits & 0x1L) == 0) {
            this.kind(instance.kind());
            bits |= 0x1L;
          }
        }
      }

      /**
       * Initializes the value for the {@link ResourceSpec.NamedResourceSpec#kind() kind} attribute.
       * @param kind The value for kind 
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("Kind")
      public final Builder kind(String kind) {
        this.kind = Objects.requireNonNull(kind, "kind");
        initBits &= ~INIT_BIT_KIND;
        return this;
      }

      /**
       * Initializes the value for the {@link ResourceSpec.NamedResourceSpec#value() value} attribute.
       * @param value The value for value 
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("Value")
      public final Builder value(String value) {
        this.value = Objects.requireNonNull(value, "value");
        initBits &= ~INIT_BIT_VALUE;
        return this;
      }

      /**
       * Builds a new {@link ImmutableResourceSpec.NamedResourceSpec NamedResourceSpec}.
       * @return An immutable instance of NamedResourceSpec
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableResourceSpec.NamedResourceSpec build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableResourceSpec.NamedResourceSpec(kind, value);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_KIND) != 0) attributes.add("kind");
        if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
        return "Cannot build NamedResourceSpec, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link ResourceSpec.DiscreteResourceSpec}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableResourceSpec.DiscreteResourceSpec.builder()}.
   */
  static final class DiscreteResourceSpec
      implements ResourceSpec.DiscreteResourceSpec {
    private final String kind;
    private final int value;

    private DiscreteResourceSpec(String kind, int value) {
      this.kind = kind;
      this.value = value;
    }

    /**
     * @return The value of the {@code kind} attribute
     */
    @JsonProperty("Kind")
    @Override
    public String kind() {
      return kind;
    }

    /**
     * @return The value of the {@code value} attribute
     */
    @JsonProperty("Value")
    @Override
    public int value() {
      return value;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link ResourceSpec.DiscreteResourceSpec#kind() kind} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for kind
     * @return A modified copy or the {@code this} object
     */
    public final ImmutableResourceSpec.DiscreteResourceSpec withKind(String value) {
      String newValue = Objects.requireNonNull(value, "kind");
      if (this.kind.equals(newValue)) return this;
      return new ImmutableResourceSpec.DiscreteResourceSpec(newValue, this.value);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link ResourceSpec.DiscreteResourceSpec#value() value} attribute.
     * A value equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for value
     * @return A modified copy or the {@code this} object
     */
    public final ImmutableResourceSpec.DiscreteResourceSpec withValue(int value) {
      if (this.value == value) return this;
      return new ImmutableResourceSpec.DiscreteResourceSpec(this.kind, value);
    }

    /**
     * This instance is equal to all instances of {@code DiscreteResourceSpec} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(Object another) {
      if (this == another) return true;
      return another instanceof ImmutableResourceSpec.DiscreteResourceSpec
          && equalsByValue((ImmutableResourceSpec.DiscreteResourceSpec) another);
    }

    private boolean equalsByValue(ImmutableResourceSpec.DiscreteResourceSpec another) {
      return kind.equals(another.kind)
          && value == another.value;
    }

    /**
     * Computes a hash code from attributes: {@code kind}, {@code value}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + kind.hashCode();
      h += (h << 5) + value;
      return h;
    }

    /**
     * Prints the immutable value {@code DiscreteResourceSpec} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "DiscreteResourceSpec{"
          + "kind=" + kind
          + ", value=" + value
          + "}";
    }

    /**
     * Creates an immutable copy of a {@link ResourceSpec.DiscreteResourceSpec} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable DiscreteResourceSpec instance
     */
    public static ImmutableResourceSpec.DiscreteResourceSpec copyOf(ResourceSpec.DiscreteResourceSpec instance) {
      if (instance instanceof ImmutableResourceSpec.DiscreteResourceSpec) {
        return (ImmutableResourceSpec.DiscreteResourceSpec) instance;
      }
      return ImmutableResourceSpec.DiscreteResourceSpec.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableResourceSpec.DiscreteResourceSpec DiscreteResourceSpec}.
     * <pre>
     * ImmutableResourceSpec.DiscreteResourceSpec.builder()
     *    .kind(String) // required {@link ResourceSpec.DiscreteResourceSpec#kind() kind}
     *    .value(int) // required {@link ResourceSpec.DiscreteResourceSpec#value() value}
     *    .build();
     * </pre>
     * @return A new DiscreteResourceSpec builder
     */
    public static ImmutableResourceSpec.DiscreteResourceSpec.Builder builder() {
      return new ImmutableResourceSpec.DiscreteResourceSpec.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableResourceSpec.DiscreteResourceSpec DiscreteResourceSpec}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @JsonTypeName("DiscreteResourceSpec")
    static final class Builder implements ResourceSpec.DiscreteResourceSpec.Builder {
      private static final long INIT_BIT_KIND = 0x1L;
      private static final long INIT_BIT_VALUE = 0x2L;
      private long initBits = 0x3L;

      private String kind;
      private int value;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.mandas.docker.client.messages.swarm.ResourceSpec} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(ResourceSpec instance) {
        Objects.requireNonNull(instance, "instance");
        mergeInternal(instance);
        return this;
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.mandas.docker.client.messages.swarm.ResourceSpec.DiscreteResourceSpec} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(ResourceSpec.DiscreteResourceSpec instance) {
        Objects.requireNonNull(instance, "instance");
        mergeInternal(instance);
        return this;
      }

      private void mergeInternal(Object object) {
        long bits = 0;
        if (object instanceof ResourceSpec) {
          ResourceSpec instance = (ResourceSpec) object;
          if ((bits & 0x1L) == 0) {
            this.kind(instance.kind());
            bits |= 0x1L;
          }
        }
        if (object instanceof ResourceSpec.DiscreteResourceSpec) {
          ResourceSpec.DiscreteResourceSpec instance = (ResourceSpec.DiscreteResourceSpec) object;
          this.value(instance.value());
          if ((bits & 0x1L) == 0) {
            this.kind(instance.kind());
            bits |= 0x1L;
          }
        }
      }

      /**
       * Initializes the value for the {@link ResourceSpec.DiscreteResourceSpec#kind() kind} attribute.
       * @param kind The value for kind 
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("Kind")
      public final Builder kind(String kind) {
        this.kind = Objects.requireNonNull(kind, "kind");
        initBits &= ~INIT_BIT_KIND;
        return this;
      }

      /**
       * Initializes the value for the {@link ResourceSpec.DiscreteResourceSpec#value() value} attribute.
       * @param value The value for value 
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("Value")
      public final Builder value(int value) {
        this.value = value;
        initBits &= ~INIT_BIT_VALUE;
        return this;
      }

      /**
       * Builds a new {@link ImmutableResourceSpec.DiscreteResourceSpec DiscreteResourceSpec}.
       * @return An immutable instance of DiscreteResourceSpec
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableResourceSpec.DiscreteResourceSpec build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableResourceSpec.DiscreteResourceSpec(kind, value);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_KIND) != 0) attributes.add("kind");
        if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
        return "Cannot build DiscreteResourceSpec, some of required attributes are not set " + attributes;
      }
    }
  }
}
