/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.views;

import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.IDEPlugin;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.actions.FunctionBrowserAction;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.TapsetLibrary;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.nodedata.ISingleTypedNode;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.tparsers.FunctionParser;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.views.TapsetBrowserView;
import org.eclipse.linuxtools.systemtap.structures.TreeNode;
import org.eclipse.swt.graphics.Image;

public class FunctionBrowserView
extends TapsetBrowserView {
    public static final String ID = "org.eclipse.linuxtools.internal.systemtap.ui.ide.views.FunctionBrowserView";

    public FunctionBrowserView() {
        super(FunctionParser.getInstance());
    }

    @Override
    protected Image getEntryImage(TreeNode treeObj) {
        if (!(treeObj.getData() instanceof ISingleTypedNode)) {
            return IDEPlugin.getImageDescriptor("icons/vars/var_unk.gif").createImage();
        }
        String type = ((ISingleTypedNode)treeObj.getData()).getType();
        if (type == null) {
            return IDEPlugin.getImageDescriptor("icons/vars/var_void.gif").createImage();
        }
        if (type.equals("long")) {
            return IDEPlugin.getImageDescriptor("icons/vars/var_long.gif").createImage();
        }
        if (type.equals("string")) {
            return IDEPlugin.getImageDescriptor("icons/vars/var_str.gif").createImage();
        }
        return IDEPlugin.getImageDescriptor("icons/vars/var_unk.gif").createImage();
    }

    @Override
    protected void displayContents() {
        this.setViewerInput(TapsetLibrary.getFunctions());
        this.setRefreshable(true);
    }

    @Override
    protected void makeActions() {
        this.doubleClickAction = new FunctionBrowserAction(this.getSite().getWorkbenchWindow(), this);
        this.viewer.addDoubleClickListener((IDoubleClickListener)this.doubleClickAction);
        this.registerContextMenu("functionPopup");
    }
}

