/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.emf.runtime.resource;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.mdht.emf.runtime.resource.DOMElementHandler;
import org.eclipse.mdht.emf.runtime.resource.FleXMLResourceSet;
import org.eclipse.mdht.emf.runtime.resource.XSITypeProvider;
import org.w3c.dom.Element;

public class XSITypeHandler
implements DOMElementHandler {
    private final EPackage epackage;

    public XSITypeHandler(EPackage epackage) {
        this.epackage = epackage;
    }

    @Override
    public boolean handleElement(Element element, Element root, XMLHelper helper) {
        EClass eclass;
        XSITypeProvider provider = this.getXSITypeProviderRegistry(helper).getXSITypeProvider(this.epackage);
        EClass eClass = eclass = provider == null ? null : provider.getXSIType(element);
        if (eclass != null) {
            if (helper.getPrefix("http://www.w3.org/2001/XMLSchema-instance") == null) {
                helper.addPrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            }
            EPackage ePackage = eclass.getEPackage();
            String nsURI = ePackage.getNsURI();
            String nsPrefix = helper.getPrefix(nsURI);
            if (helper.getPrefix(nsURI) == null) {
                helper.addPrefix(nsPrefix, nsURI);
                root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + nsPrefix, nsURI);
            }
            element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", String.valueOf(nsPrefix) + ":" + helper.getName((ENamedElement)eclass));
        }
        return false;
    }

    private XSITypeProvider.Registry getXSITypeProviderRegistry(XMLHelper helper) {
        XSITypeProvider.Registry result = null;
        ResourceSet rset = helper.getResource().getResourceSet();
        if (rset instanceof FleXMLResourceSet) {
            result = ((FleXMLResourceSet)rset).getXSITypeProviderRegistry();
        }
        return result != null ? result : XSITypeProvider.Registry.INSTANCE;
    }
}

