/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.term.ui.actions;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.mdht.uml.common.ui.search.IElementFilter;
import org.eclipse.mdht.uml.common.ui.search.ModelSearch;
import org.eclipse.mdht.uml.term.core.profile.BindingKind;
import org.eclipse.mdht.uml.term.core.profile.CodeSystemVersion;
import org.eclipse.mdht.uml.term.core.profile.ValueSetCode;
import org.eclipse.mdht.uml.term.core.profile.ValueSetVersion;
import org.eclipse.mdht.uml.term.core.util.TermProfileUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.ObjectPluginAction;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;

public class ImportTerminologyAction
implements IObjectActionDelegate {
    private static final String[] FILTER_NAMES = new String[]{"PHIN VADS Code Set Archive (*.zip)", "All Files (*.*)"};
    private static final String[] FILTER_EXTS = new String[]{"*.zip", "*.*"};
    private Shell shell;
    Package umlPackage = null;
    Package codeSystemPackage = null;
    ResourceSet resourceSet = null;
    static final int MAXCODES = 400;
    int codeSystemsCreated;
    int valueSetsCreated;
    int valueSetsUpdated;
    int codesCreated;
    int codesUpdated;
    int valueSetsAboveMaxCode;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }

    public void run(IAction action) {
        ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(this.shell);
        ObjectPluginAction opa = (ObjectPluginAction)action;
        final TreeSelection selection = (TreeSelection)opa.getSelection();
        String ActionTitle = "Import Terminology";
        final FileDialog fdlg = new FileDialog(this.shell, 4);
        fdlg.setText("Select Terminology Source File");
        fdlg.setFilterNames(FILTER_NAMES);
        fdlg.setFilterExtensions(FILTER_EXTS);
        IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                IWorkspaceRoot myWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                File f = (File)selection.getFirstElement();
                String umlPath = String.valueOf(myWorkspaceRoot.getLocation().toOSString()) + f.getFullPath().toOSString();
                try {
                    ImportTerminologyAction.this.importTerminlogy(monitor, umlPath, fdlg);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    myWorkspaceRoot.refreshLocal(2, null);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                if (monitor.isCanceled()) {
                    monitor.done();
                    return;
                }
                monitor.done();
            }
        };
        try {
            try {
                if (fdlg.open() != null) {
                    progressDialog.run(false, true, runnableWithProgress);
                    UMLModelMetricsDialog dlg = new UMLModelMetricsDialog(this.shell);
                    dlg.create();
                    dlg.open();
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                MessageDialog.openError((Shell)this.shell, (String)"Import Terminology", (String)("Error Processing Export " + invocationTargetException.getMessage()));
                progressDialog.close();
            }
            catch (InterruptedException interruptedException) {
                MessageDialog.openError((Shell)this.shell, (String)"Import Terminology", (String)("Error Processing Export " + interruptedException.getMessage()));
                progressDialog.close();
            }
        }
        finally {
            progressDialog.close();
        }
    }

    private String popCleanValue(String[] values, int index) {
        String result = "";
        if (index < values.length && values[index] != null) {
            result = values[index].replaceAll("[^!-~]", " ");
        }
        return result;
    }

    public void importTerminlogy(IProgressMonitor monitor, String umlPath, FileDialog fdlg) {
        this.codeSystemsCreated = 0;
        this.valueSetsCreated = 0;
        this.valueSetsUpdated = 0;
        this.codesCreated = 0;
        this.codesUpdated = 0;
        this.valueSetsAboveMaxCode = 0;
        this.resourceSet = new ResourceSetImpl();
        this.resourceSet.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        this.resourceSet.getLoadOptions().put("DEFER_IDREF_RESOLUTION", Boolean.FALSE);
        this.resourceSet.getLoadOptions().put("DEFER_ATTACHMENT", Boolean.FALSE);
        URI umlModelURI = URI.createFileURI((String)umlPath);
        this.umlPackage = (Package)EcoreUtil.getObjectByType((Collection)this.resourceSet.getResource(umlModelURI, true).getContents(), (EClassifier)UMLPackage.Literals.PACKAGE);
        this.codeSystemPackage = null;
        for (Package p : this.umlPackage.getImportedPackages()) {
            if (!p.getName().contains("CodeSystems")) continue;
            this.codeSystemPackage = (Package)EcoreUtil.getObjectByType((Collection)this.resourceSet.getResource(p.eResource().getURI(), true).getContents(), (EClassifier)UMLPackage.Literals.PACKAGE);
            break;
        }
        Profile ctsProfile = TermProfileUtil.getTerminologyProfile((ResourceSet)this.umlPackage.eResource().getResourceSet());
        final Stereotype valueSetVersionStereotype = (Stereotype)ctsProfile.getOwnedType("ValueSetVersion");
        String[] files = fdlg.getFileNames();
        int i = 0;
        int n = files.length;
        while (i < n) {
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(String.valueOf(fdlg.getFilterPath()) + System.getProperty("file.separator") + files[i]);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            java.util.Enumeration<? extends ZipEntry> ze = zipFile.entries();
            int zipFileEntryCount = 0;
            while (ze.hasMoreElements()) {
                ze.nextElement();
                ++zipFileEntryCount;
            }
            monitor.beginTask("MDHT Terminology Import", zipFileEntryCount);
            ze = zipFile.entries();
            while (ze.hasMoreElements()) {
                Enumeration valueSet = null;
                ArrayList<String> valueSetCodes = new ArrayList<String>();
                ZipEntry z = ze.nextElement();
                if (z.getName() != null && !z.getName().endsWith("txt")) continue;
                monitor.subTask("Importing " + z.getName());
                try {
                    String thisLine;
                    BufferedReader br = new BufferedReader(new InputStreamReader(zipFile.getInputStream(z), "UTF-8"));
                    int lineCtr = 0;
                    String[] header = null;
                    while ((thisLine = br.readLine()) != null) {
                        String[] result = thisLine.split("\t");
                        if (lineCtr != 0 || "Value Set Name".equals((header = thisLine.split("\t"))[0])) {
                            if (lineCtr == 1) {
                                final String valueSetID = this.popCleanValue(result, 2);
                                IElementFilter filter = new IElementFilter(){

                                    public boolean accept(Element element) {
                                        return element instanceof Enumeration && element.isStereotypeApplied(valueSetVersionStereotype) && valueSetID.equals(element.getValue(valueSetVersionStereotype, "identifier"));
                                    }
                                };
                                List typeList = ModelSearch.findAllOf((ResourceSet)this.umlPackage.eResource().getResourceSet(), (IElementFilter)filter);
                                if (!typeList.isEmpty()) {
                                    ++this.valueSetsUpdated;
                                    valueSet = (Enumeration)typeList.get(0);
                                    Object[] els = valueSet.getOwnedLiterals().toArray();
                                    int ectr = 0;
                                    while (ectr < els.length) {
                                        EnumerationLiteral ee = (EnumerationLiteral)els[ectr];
                                        ee.destroy();
                                        ++ectr;
                                    }
                                    valueSet.getOwnedLiterals().removeAll((Collection)valueSet.getOwnedLiterals());
                                } else {
                                    valueSet = UMLFactory.eINSTANCE.createEnumeration();
                                    this.umlPackage.getOwnedTypes().add((Object)valueSet);
                                    TermProfileUtil.applyStereotype((Element)valueSet, (String)"ValueSetVersion");
                                    ++this.valueSetsCreated;
                                }
                                ValueSetVersion vsv = (ValueSetVersion)valueSet.getStereotypeApplication(valueSetVersionStereotype);
                                valueSet.setName(this.popCleanValue(result, 0));
                                vsv.setFullName(this.popCleanValue(result, 0));
                                vsv.setIdentifier(valueSetID);
                                vsv.setVersion(this.popCleanValue(result, 3));
                                vsv.setDefinition(this.popCleanValue(result, 4));
                                vsv.setRevisionDate(this.popCleanValue(result, 6));
                                vsv.setBinding(BindingKind.STATIC);
                            }
                            if (lineCtr > 3) {
                                valueSetCodes.add(thisLine);
                            }
                            ++lineCtr;
                            continue;
                        }
                        break;
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (valueSet == null) continue;
                ValueSetVersion valueSetVersion = TermProfileUtil.getValueSetVersion(valueSet);
                if (valueSetCodes.size() > 1) {
                    String[] valuSetCodeResult = ((String)valueSetCodes.get(0)).split("\t");
                    Enumeration codeSystemEnumeration = (Enumeration)this.getCodeSystem(this.umlPackage, valuSetCodeResult);
                    Stereotype codeSystemStereotype = TermProfileUtil.getAppliedStereotype((Element)codeSystemEnumeration, (String)"CodeSystemVersion");
                    CodeSystemVersion codeSystem = (CodeSystemVersion)codeSystemEnumeration.getStereotypeApplication(codeSystemStereotype);
                    valueSetVersion.setCodeSystem(codeSystem);
                }
                if (valueSetCodes.size() <= 400) {
                    for (String line : valueSetCodes) {
                        String[] valuSetCodeResult = line.split("\t");
                        EnumerationLiteral valueSetCode = UMLFactory.eINSTANCE.createEnumerationLiteral();
                        valueSetCode.setName(this.popCleanValue(valuSetCodeResult, 0));
                        valueSet.getOwnedLiterals().add((Object)valueSetCode);
                        Stereotype valueSetStereotype = TermProfileUtil.applyStereotype((Element)valueSetCode, (String)"ValueSetCode");
                        ValueSetCode vcs = (ValueSetCode)valueSetCode.getStereotypeApplication(valueSetStereotype);
                        if (valueSetStereotype == null) continue;
                        vcs.setConceptName(this.popCleanValue(valuSetCodeResult, 2));
                        vcs.setUsageNote(this.popCleanValue(valuSetCodeResult, 5));
                        String id = this.popCleanValue(valuSetCodeResult, 4);
                        if (valueSetVersion == null || valueSetVersion.getCodeSystem() == null || id.equals(valueSetVersion.getCodeSystem().getIdentifier())) continue;
                        Enumeration codeSystemEnumeration = (Enumeration)this.getCodeSystem(this.umlPackage, valuSetCodeResult);
                        Stereotype codeSystemStereotype = TermProfileUtil.getAppliedStereotype((Element)codeSystemEnumeration, (String)"CodeSystemVersion");
                        CodeSystemVersion codeSystem = (CodeSystemVersion)codeSystemEnumeration.getStereotypeApplication(codeSystemStereotype);
                        vcs.setCodeSystem(codeSystem);
                    }
                    monitor.worked(1);
                    continue;
                }
                ++this.valueSetsAboveMaxCode;
            }
            ++i;
        }
        HashMap options = new HashMap();
        try {
            this.umlPackage.eResource().save(options);
            if (this.codeSystemPackage != null) {
                this.codeSystemPackage.eResource().save(options);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Element getCodeSystem(Package umlPackage, String[] valuSetCodeResult) {
        List typeList;
        final String codeSystemID = this.popCleanValue(valuSetCodeResult, 4);
        Profile ctsProfile = TermProfileUtil.getTerminologyProfile((ResourceSet)umlPackage.eResource().getResourceSet());
        Enumeration codeSystemEnumeration = null;
        final Stereotype codeSystemVersionStereotype = (Stereotype)ctsProfile.getOwnedType("CodeSystemVersion");
        IElementFilter filter = new IElementFilter(){

            public boolean accept(Element element) {
                return element instanceof Enumeration && element.isStereotypeApplied(codeSystemVersionStereotype) && codeSystemID.equals(element.getValue(codeSystemVersionStereotype, "identifier"));
            }
        };
        for (Package p : umlPackage.getImportedPackages()) {
            List typeList2 = ModelSearch.findAllOf((ResourceSet)p.eResource().getResourceSet(), (IElementFilter)filter);
            if (typeList2.isEmpty()) continue;
            codeSystemEnumeration = (Enumeration)typeList2.get(0);
            if (this.codeSystemPackage != null) continue;
            this.codeSystemPackage = (Package)EcoreUtil.getObjectByType((Collection)this.resourceSet.getResource(p.eResource().getURI(), true).getContents(), (EClassifier)UMLPackage.Literals.PACKAGE);
        }
        if (codeSystemEnumeration == null && !(typeList = ModelSearch.findAllOf((ResourceSet)umlPackage.eResource().getResourceSet(), (IElementFilter)filter)).isEmpty()) {
            codeSystemEnumeration = (Enumeration)typeList.get(0);
        }
        if (codeSystemEnumeration == null) {
            ++this.codeSystemsCreated;
            codeSystemEnumeration = UMLFactory.eINSTANCE.createEnumeration();
            codeSystemEnumeration.setName(this.popCleanValue(valuSetCodeResult, 5));
            if (this.codeSystemPackage != null) {
                this.codeSystemPackage.getOwnedTypes().add((Object)codeSystemEnumeration);
            } else {
                umlPackage.getOwnedTypes().add((Object)codeSystemEnumeration);
            }
            Stereotype stereotype = TermProfileUtil.applyStereotype((Element)codeSystemEnumeration, (String)"CodeSystemVersion");
            CodeSystemVersion codeSystem = (CodeSystemVersion)codeSystemEnumeration.getStereotypeApplication(stereotype);
            codeSystem.setIdentifier(codeSystemID);
            codeSystem.setVersion(this.popCleanValue(valuSetCodeResult, 7));
            codeSystem.setSource(this.popCleanValue(valuSetCodeResult, 8));
        }
        return codeSystemEnumeration;
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public class TerminologyMetricsDialog
    extends TitleAreaDialog {
        public static final int OPEN = 9999;
        public static final int DELETE = 9998;
        Text textWidget;

        public TerminologyMetricsDialog(Shell shell) {
            super(shell);
        }

        public void create() {
            super.create();
            this.setTitle("Model Driven Health Tools");
            if (ImportTerminologyAction.this.umlPackage != null) {
                this.setMessage("Terminology Import Metrics for " + ImportTerminologyAction.this.umlPackage.getName());
            }
        }

        protected Control createDialogArea(Composite parent) {
            Composite area = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout();
            area.setLayout((Layout)gridLayout);
            this.textWidget = new Text(area, 2816);
            GridData gridData = new GridData();
            gridData.heightHint = 200;
            this.textWidget.setLayoutData((Object)gridData);
            return area;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            Button okButton = this.createButton(parent, 0, "Ok", false);
            okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TerminologyMetricsDialog.this.setReturnCode(0);
                    TerminologyMetricsDialog.this.close();
                }
            });
        }
    }

    public class UMLModelMetricsDialog
    extends TitleAreaDialog {
        public static final int OPEN = 9999;
        public static final int DELETE = 9998;
        Table table;

        public UMLModelMetricsDialog(Shell shell) {
            super(shell);
        }

        public void create() {
            super.create();
            this.setTitle("HL7 DSL to UML");
            if (ImportTerminologyAction.this.umlPackage != null) {
                this.setMessage("UML Model Metrics for " + ImportTerminologyAction.this.umlPackage.getName());
            }
        }

        protected Control createDialogArea(Composite parent) {
            Composite area = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginWidth = 15;
            gridLayout.marginHeight = 10;
            area.setLayout((Layout)gridLayout);
            this.table = new Table(area, 2048);
            GridData gridData = new GridData();
            gridData.widthHint = 500;
            this.table.setLayoutData((Object)gridData);
            this.table.setHeaderVisible(true);
            TableColumn column1 = new TableColumn(this.table, 16384);
            TableColumn column2 = new TableColumn(this.table, 0x1000000);
            column1.setText("Vocabulary Import Metrics");
            column2.setText("Result");
            column1.setWidth(250);
            column2.setWidth(250);
            if (ImportTerminologyAction.this.umlPackage != null) {
                TableItem valueSetsCreatedItem = new TableItem(this.table, 0);
                valueSetsCreatedItem.setText(new String[]{"Value Sets Created", String.valueOf(ImportTerminologyAction.this.valueSetsCreated)});
                TableItem valueSetsUpdatedItem = new TableItem(this.table, 0);
                valueSetsUpdatedItem.setText(new String[]{"Value Sets Updated", String.valueOf(ImportTerminologyAction.this.valueSetsUpdated)});
                TableItem valueSetsAboveMax = new TableItem(this.table, 0);
                valueSetsAboveMax.setText(new String[]{"Value Sets Codes too Large", String.valueOf(ImportTerminologyAction.this.valueSetsAboveMaxCode)});
                TableItem codeSystemsCreatedItem = new TableItem(this.table, 0);
                codeSystemsCreatedItem.setText(new String[]{"New Code Systems Defined", String.valueOf(ImportTerminologyAction.this.codeSystemsCreated)});
            }
            return area;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            Button okButton = this.createButton(parent, 0, "Ok", false);
            okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    UMLModelMetricsDialog.this.setReturnCode(0);
                    UMLModelMetricsDialog.this.close();
                }
            });
        }
    }
}

