/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.validation.internal.properties;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.mdht.uml.cda.core.util.CDAModelUtil;
import org.eclipse.mdht.uml.validation.provider.AbstractMultiConstraint;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;

public class SeverityAndCardinalityConstraint
extends AbstractMultiConstraint {
    private boolean checkSeverityAndCardinality(Property property) {
        return this.checkSeverityAndCardinality(property, CDAModelUtil.getValidationSeverity((Property)property, (String)"PropertyValidation"));
    }

    private boolean checkSeverityAndCardinality(Property property, String severity) {
        if ("ERROR".equals(severity) && property.lowerBound() == 0 && property.upperBound() != 0) {
            return false;
        }
        return !"INFO".equals(severity) && !"WARNING".equals(severity) || property.lowerBound() != 1;
    }

    public IStatus validateSeverityAndCardinalityConstraint(IValidationContext context) {
        Property property;
        IStatus result = null;
        if (context.getTarget() instanceof Association) {
            Association association = (Association)context.getTarget();
            String severity = CDAModelUtil.getValidationSeverity((Element)association, (String)"AssociationValidation");
            for (Property property2 : association.getMemberEnds()) {
                if (!(property2.getOwner() instanceof Class) || this.checkSeverityAndCardinality(property2, severity)) continue;
                result = context.createFailureStatus(new Object[]{property2, property2.getOwner() instanceof NamedElement ? ((NamedElement)property2.getOwner()).getQualifiedName() : property2.getQualifiedName()});
                break;
            }
        } else if (context.getTarget() instanceof Property && !this.checkSeverityAndCardinality(property = (Property)context.getTarget())) {
            result = context.createFailureStatus(new Object[]{property, property.getOwner() instanceof NamedElement ? ((NamedElement)property.getOwner()).getQualifiedName() : property.getQualifiedName()});
        }
        return result == null ? context.createSuccessStatus() : result;
    }
}

