/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.ui.properties;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.mdht.uml.cda.ui.properties.ValidationSection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.uml2.uml.Stereotype;

public class TextValueSection
extends ValidationSection {
    private Text valueText;
    private boolean valueModified = false;
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent event) {
            if (TextValueSection.this.valueText == event.getSource()) {
                TextValueSection.this.valueModified = true;
            }
        }
    };
    private KeyListener keyListener = new KeyListener(){

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            if ('\r' == e.character || '\u1000050' == e.character) {
                TextValueSection.this.modifyFields();
            }
        }
    };
    private FocusListener focusListener = new FocusListener(){

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent event) {
            TextValueSection.this.modifyFields();
        }
    };

    @Override
    protected Stereotype getValidationStereotype() {
        String qname = "CDA::TextValue";
        Stereotype stereotype = this.modelElement.getApplicableStereotype(qname);
        return stereotype;
    }

    @Override
    protected void modifyFields() {
        super.modifyFields();
        if (!this.valueModified) {
            return;
        }
        try {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.modelElement);
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, "temp"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                    Stereotype stereotype = TextValueSection.this.getValidationStereotype();
                    if (stereotype == null) {
                        return Status.CANCEL_STATUS;
                    }
                    if (!TextValueSection.this.modelElement.isStereotypeApplied(stereotype)) {
                        TextValueSection.this.modelElement.applyStereotype(stereotype);
                    }
                    if (TextValueSection.this.valueModified) {
                        TextValueSection.this.valueModified = false;
                        this.setLabel("Set Text Value");
                        if (stereotype != null) {
                            String value = TextValueSection.this.valueText.getText().trim();
                            TextValueSection.this.modelElement.setValue(stereotype, "value", (Object)(value.length() > 0 ? value : null));
                        }
                    } else {
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            };
            this.execute((IUndoableOperation)operation);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Group composite = this.getWidgetFactory().createGroup(parent, "Text Value Validation");
        FormLayout layout = new FormLayout();
        layout.marginWidth = 7;
        layout.marginHeight = 4;
        layout.spacing = 7;
        composite.setLayout((Layout)layout);
        FormData data = null;
        this.valueText = this.getWidgetFactory().createText((Composite)composite, "");
        CLabel valueLabel = this.getWidgetFactory().createCLabel((Composite)composite, "Constraint:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.valueText, 0, 0x1000000);
        valueLabel.setLayoutData((Object)data);
        this.createRestoreDefaultsButton((Composite)composite);
        data = new FormData();
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.valueText, 0, 0x1000000);
        this.restoreDefaultsButton.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)valueLabel, 0);
        data.right = new FormAttachment((Control)this.restoreDefaultsButton, 5);
        data.top = new FormAttachment(0, 2, 4);
        this.valueText.setLayoutData((Object)data);
        this.addValidationControls((Composite)composite, 1, 2);
    }

    @Override
    public void refresh() {
        super.refresh();
        Stereotype stereotype = this.getValidationStereotype();
        this.valueText.removeModifyListener(this.modifyListener);
        this.valueText.removeKeyListener(this.keyListener);
        this.valueText.removeFocusListener(this.focusListener);
        if (stereotype != null && this.modelElement.isStereotypeApplied(stereotype)) {
            String value = (String)this.modelElement.getValue(stereotype, "value");
            this.valueText.setText(value != null ? value : "");
        } else {
            this.valueText.setText("");
        }
        this.valueText.addModifyListener(this.modifyListener);
        this.valueText.addKeyListener(this.keyListener);
        this.valueText.addFocusListener(this.focusListener);
        if (this.isReadOnly()) {
            this.valueText.setEnabled(false);
            this.restoreDefaultsButton.setEnabled(false);
        } else {
            this.valueText.setEnabled(true);
            this.restoreDefaultsButton.setEnabled(stereotype != null && this.modelElement.isStereotypeApplied(stereotype));
        }
    }
}

