/*
 * Decompiled with CFR 0.152.
 */
package traceability.presentation.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.BasicEObjectImpl;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.XViewerStyledTextLabelProvider;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import traceability.DiffCategory;
import traceability.LogEntry;
import traceability.Trace;
import traceability.TraceComment;
import traceability.TraceDiff;
import traceability.presentation.TraceabilityEditor;
import traceability.presentation.TraceabilityEditorPlugin;
import traceability.presentation.table.TableCellDifference;
import traceability.presentation.table.TraceabilitySorter;
import traceability.presentation.table.TraceabilityViewer;
import traceability.presentation.table.TraceabilityViewerContentProvider;
import traceability.presentation.table.images.TraceabilityImageCache;
import traceability.util.TraceabilityUtils;

public class TraceabilityViewerLabelProvider
extends XViewerStyledTextLabelProvider {
    private TraceabilityViewer myXviewer;
    private static Map<List<FontData>, Font> fontCache = new WeakHashMap<List<FontData>, Font>();
    private boolean returned32widthimage;

    public TraceabilityViewerLabelProvider(TraceabilityViewer myXviewer) {
        super((XViewer)myXviewer);
        this.myXviewer = myXviewer;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public Image getColumnImage(Object element, XViewerColumn xCol, int columnIndex) {
        LogEntry error;
        if ("".equals(this.getColumnText(element, xCol, columnIndex))) {
            return null;
        }
        Image result = null;
        String base = "platform:/plugin/" + TraceabilityEditorPlugin.getPlugin().getBundle().getSymbolicName() + "/icons/";
        if (this.myXviewer.traceabilityEditor.isErrorCol(xCol) && (error = this.myXviewer.tracing.getError(element = TraceabilityViewer.getRedirectedElement(element))) != null) {
            if (error.getSeverity() == 0) {
                result = TraceabilityImageCache.getImage(String.valueOf(base) + "severities/LogEntry.png");
            }
            if (error.getSeverity() == 1) {
                result = TraceabilityImageCache.getImage(String.valueOf(base) + "severities/Warning.png");
            }
            if (error.getSeverity() == 2) {
                result = TraceabilityImageCache.getImage(String.valueOf(base) + "severities/Info.png");
            }
        }
        if (result == null) {
            Object data = this.myXviewer.getCellData(xCol, element);
            result = this.myXviewer.traceabilityEditor.getImage(data);
        }
        if (result != null && !this.returned32widthimage && result.getBounds().width < 32) {
            result = TraceabilityImageCache.getImage(String.valueOf(base) + "spacereservation.png");
            this.returned32widthimage = true;
            final Object felement = element;
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TraceabilityViewerLabelProvider.this.myXviewer.update(felement, null);
                }
            });
        }
        return result;
    }

    public String getColumnTextOriginal(Object element, XViewerColumn xCol, int columnIndex) {
        element = TraceabilityViewer.getRedirectedElement(element);
        xCol = this.myXviewer.traceabilityEditor.getRedirectedColumn(element, xCol);
        if (element instanceof String) {
            return columnIndex == 0 ? (String)element : "";
        }
        String result = this.myXviewer.traceabilityEditor.getLabel(element, xCol, columnIndex);
        Object cellData = this.myXviewer.getCellData(xCol, element);
        if (cellData instanceof EObject && ((EObject)cellData).eIsProxy()) {
            result = "<del>" + ((BasicEObjectImpl)cellData).eProxyURI() + "</del>";
        }
        if (result == null) {
            return "?";
        }
        if ("".equals(result)) {
            return "<empty string>";
        }
        return result;
    }

    public String getColumnTextDiffed(Object element, XViewerColumn xCol, int columnIndex) {
        String result = this.getColumnTextOriginal(element, xCol, columnIndex);
        if (result == null || "?".equals(result)) {
            return "?";
        }
        List<TableCellDifference> cellDiffs = this.getTableCellDifferences(element, xCol);
        if (cellDiffs == null || cellDiffs.size() >= 2 && TraceabilityViewerLabelProvider.getValueSet(cellDiffs).size() == 1) {
            return result;
        }
        if (!"".equals(cellDiffs.get(0).getDiffText())) {
            result = "<b>" + cellDiffs.get(0).getDiffText() + "</b> " + result;
        }
        return result;
    }

    public String getColumnText(Object element, XViewerColumn xCol, int columnIndex) {
        Object prevElement;
        String cellText = this.getColumnTextDiffed(element, xCol, columnIndex);
        if (this.myXviewer.getSorter() instanceof TraceabilitySorter) {
            TraceabilitySorter traceabilitySorter = (TraceabilitySorter)this.myXviewer.getSorter();
            if (traceabilitySorter.sorting) {
                return cellText;
            }
        }
        TraceabilityViewerContentProvider content = (TraceabilityViewerContentProvider)this.myXviewer.getContentProvider();
        if (!(this.myXviewer.traceabilityEditor.traceabilityFilters_ALL || cellText == null || "".equals(cellText) || "?".equals(cellText) || content.hasChildren(element) || this.myXviewer.traceabilityEditor.alwaysPrintColumns().contains(xCol) || (prevElement = this.myXviewer.getPreviousElement(element)) == null)) {
            Object cell = this.myXviewer.getCellData(xCol, element);
            Object prevCell = this.myXviewer.getCellData(xCol, prevElement);
            String cellTextAbove = this.getColumnTextDiffed(prevElement, xCol, columnIndex);
            if (cell == prevCell && cellText.equals(cellTextAbove)) {
                return "";
            }
        }
        return cellText;
    }

    public StyledString getStyledText(Object element, XViewerColumn xCol, int column) throws Exception {
        Point found;
        String s = this.getColumnText(element, xCol, column);
        s = this.myXviewer.traceabilityEditor.adjustStyledText(xCol, element, s);
        if (this.myXviewer.isHovered(element, xCol) && this.myXviewer.getCellData(xCol, element) != null) {
            s = String.valueOf(s.substring(0, s.indexOf(s.trim()))) + "<xref>" + s.trim() + "</xref>";
        }
        if ((found = TraceabilityViewer.findText(s, this.myXviewer.searchText, this.myXviewer.searchregex)) != null) {
            s = String.valueOf(s.substring(0, found.x)) + "<s>" + s.substring(found.x, found.y) + "</s>" + s.substring(found.y);
        }
        return TraceabilityViewerLabelProvider.getStyledString(s, true);
    }

    public static StyledString getStyledString(String s, boolean oneLineFormatting) {
        int i2;
        int i;
        int listNesting = 0;
        StyledString ss = new StyledString();
        Font font = null;
        StyledString.Styler current = null;
        boolean underline = false;
        boolean del = false;
        boolean search = false;
        while ((i = s.indexOf("<")) != -1 && (i2 = s.indexOf(">", i)) != -1) {
            String part = s.substring(0, i);
            String tag = s.substring(i, i2 + 1);
            if ("<li>".equals(tag)) {
                part = "\n\u2022 ";
            }
            if ("<lines>".equals(tag)) {
                part = String.valueOf(part) + "\n\n";
            }
            if ("</lines>".equals(tag)) {
                part = String.valueOf(part) + "\n";
            }
            if (oneLineFormatting) {
                part = part.replaceAll("[\\p{Zs}]*[\n\r][\n\r\\p{Zs}]*", " ");
            }
            part = part.replace("\n", "\n" + StringUtils.repeat((String)" ", (int)(listNesting * 3)));
            part = part.replace("&lt;", "<");
            part = part.replace("&gt;", ">");
            ss.append(part, current);
            if ("<li>".equals(tag)) {
                ++listNesting;
            }
            if ("</li>".equals(tag)) {
                --listNesting;
            }
            if (tag.startsWith("<xref")) {
                underline = true;
            }
            if ("</xref>".equals(tag) || underline && tag.endsWith("/>")) {
                underline = false;
            }
            if (tag.startsWith("<del")) {
                del = true;
            }
            if ("</del>".equals(tag) || del && tag.endsWith("/>")) {
                del = false;
            }
            if ("<s>".equals(tag)) {
                search = true;
            }
            if ("</s>".equals(tag)) {
                search = false;
            }
            final boolean funderline = underline;
            final boolean fdel = del;
            final Font ffont = font = TraceabilityViewerLabelProvider.getFont(tag, font);
            final boolean fsearch = search;
            current = new StyledString.Styler(){

                public void applyStyles(TextStyle textStyle) {
                    if (funderline) {
                        textStyle.underline = true;
                        textStyle.underlineStyle = 4;
                    }
                    if (fdel) {
                        textStyle.strikeout = true;
                    }
                    if (fsearch) {
                        textStyle.foreground = TraceabilityEditor.COLOR_SEARCHFOREGROUND;
                        textStyle.background = TraceabilityEditor.COLOR_SEARCHBACKGROUND;
                    }
                    textStyle.font = ffont;
                }
            };
            s = s.substring(i2 + 1);
        }
        if (oneLineFormatting) {
            s = s.replaceAll("[\\p{Zs}]*[\n\r][\n\r\\p{Zs}]*", " ");
        }
        s = s.replace("&lt;", "<");
        s = s.replace("&gt;", ">");
        ss.append(s, current);
        return ss;
    }

    private static Font getFont(String tagName, Font font) {
        FontData[] fontData2;
        if (font == null) {
            font = Display.getCurrent().getSystemFont();
        }
        FontData[] fontDataArray = fontData2 = font.getFontData();
        int n = fontData2.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fontData = fontDataArray[n2];
            if (tagName.equals("<i>")) {
                fontData.setStyle(fontData.getStyle() | 2);
            }
            if (tagName.equals("</i>")) {
                fontData.setStyle(fontData.getStyle() & 0xFFFFFFFD);
            }
            if (tagName.equals("<b>")) {
                fontData.setStyle(fontData.getStyle() | 1);
            }
            if (tagName.equals("</b>")) {
                fontData.setStyle(fontData.getStyle() & 0xFFFFFFFE);
            }
            if (tagName.equals("<tt>")) {
                fontData.setName("Courier");
            }
            if (tagName.equals("</tt>")) {
                fontData.setName(Display.getCurrent().getSystemFont().getFontData()[0].getName());
            }
            ++n2;
        }
        Font result = fontCache.get(Arrays.asList(fontData2));
        if (result == null) {
            result = new Font((Device)Display.getCurrent(), fontData2);
            fontCache.put(Arrays.asList(fontData2), result);
        }
        return result;
    }

    public Color getBackground(Object element, XViewerColumn viewerColumn, int columnIndex) {
        List<TableCellDifference> cellDiffs = this.getTableCellDifferences(element = TraceabilityViewer.getRedirectedElement(element), viewerColumn);
        if (cellDiffs == null || cellDiffs.size() >= 2 && TraceabilityViewerLabelProvider.getValueSet(cellDiffs).size() == 1) {
            return null;
        }
        String diff = cellDiffs.get(0).getDiffText();
        if ("+".equals(diff)) {
            return TraceabilityEditor.COLOR_PLUS;
        }
        if ("-".equals(diff)) {
            return TraceabilityEditor.COLOR_MINUS;
        }
        if (TraceabilityEditor.DIFF_UNEQUAL.equals(diff)) {
            return TraceabilityEditor.COLOR_UNEQUAL;
        }
        return null;
    }

    public Color getForeground(Object element, XViewerColumn viewerColumn, int columnIndex) {
        if (this.myXviewer.isHovered(element, viewerColumn) && this.myXviewer.getCellData(viewerColumn, element) != null) {
            return TraceabilityEditor.COLOR_LINK;
        }
        return null;
    }

    public Font getFont(Object element, XViewerColumn viewerColumn, int columnIndex) throws Exception {
        return null;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public String getToolTipText(Object element) {
        if (this.myXviewer.hoverElement == element) {
            List<LogEntry> errors;
            XViewerColumn xCol = this.myXviewer.hoverCol;
            if (this.myXviewer.traceabilityEditor.isErrorCol(xCol) && (errors = this.myXviewer.tracing.getErrors(element)).size() >= 2) {
                String result = "";
                for (LogEntry error : errors) {
                    result = String.valueOf(result) + (new String[]{"Error", "Warning", "Info"})[error.getSeverity()] + ":\t" + error.getMessage() + "\n";
                    List<TableCellDifference> cellDiffs = this.getTableCellDifferences(error, xCol);
                    if (cellDiffs != null) {
                        result = cellDiffs.size() == 1 ? String.valueOf(result) + "\t(occurs in " + cellDiffs.get(0).getProject() + ")\n" : String.valueOf(result) + "\t(occurs in all)\n";
                    }
                    result = this.addComment(result, (EObject)error, xCol, element);
                }
                return result.trim();
            }
            EObject eObject = this.myXviewer.traceabilityEditor.getColumnSpecificElement(xCol, element);
            List<TableCellDifference> cellDiffs = this.getTableCellDifferences(element, xCol);
            if (cellDiffs != null) {
                String result = "";
                for (TableCellDifference tableCellDifference : cellDiffs) {
                    if ("".equals(tableCellDifference.getCellText())) {
                        result = String.valueOf(result) + "<empty string>";
                    }
                    result = String.valueOf(result) + tableCellDifference.getCellText().trim() + "\n\t(occurs in " + tableCellDifference.getProject() + ")\n";
                }
                result = this.addComment(result, (EObject)this.myXviewer.tracing.getTraceDiff(eObject), xCol, element);
                return result;
            }
            String result = this.getColumnTextOriginal(element, xCol, -1);
            if (!"".equals(result) && !"?".equals(result)) {
                result = this.addComment(result, eObject, xCol, element);
                result = this.addComment(result, (EObject)this.myXviewer.tracing.getTrace(eObject), xCol, element);
                return result;
            }
        }
        return null;
    }

    private String addComment(String result, EObject eObject, XViewerColumn xCol, Object element) {
        EList comments = eObject instanceof Trace ? ((Trace)eObject).getComments() : (eObject instanceof LogEntry ? ((LogEntry)eObject).getComments() : (eObject instanceof TraceDiff ? ((TraceDiff)eObject).getComments() : Collections.emptyList()));
        for (TraceComment comment : comments) {
            if (!xCol.getId().equals(comment.getColumn()) || comment.getNarrowDown() != null && comment.getNarrowDown() != this.myXviewer.traceabilityEditor.getNarrowDown(xCol, element)) continue;
            result = String.valueOf(result) + "\n\tComment: <b>" + comment.getComment() + "</b> from <i>" + comment.getUsername() + "</i> at <i>" + comment.getDate() + "</i>";
        }
        return result;
    }

    List<TableCellDifference> getTableCellDifferences(Object element, XViewerColumn xCol) {
        Object eObject = element instanceof LogEntry ? (LogEntry)element : this.myXviewer.traceabilityEditor.getColumnSpecificElement(xCol, element);
        TraceDiff traceDiff = this.myXviewer.tracing.getTraceDiff((EObject)eObject);
        if (traceDiff != null) {
            LogEntry focusedParticipant = eObject;
            DiffCategory cat = (DiffCategory)traceDiff.eContainer();
            int sourceIndex = -1;
            int targetIndex = -1;
            for (EObject participant : traceDiff.getParticipants()) {
                if (!(participant instanceof Trace)) continue;
                Trace trace = (Trace)participant;
                sourceIndex = trace.getSource().indexOf(element);
                targetIndex = trace.getTarget().indexOf(element);
                if (sourceIndex != -1 || targetIndex != -1) {
                    focusedParticipant = participant;
                    break;
                }
                sourceIndex = trace.getSource().indexOf(eObject);
                targetIndex = trace.getTarget().indexOf(eObject);
                if (sourceIndex == -1 && targetIndex == -1) continue;
                focusedParticipant = participant;
                break;
            }
            if (sourceIndex != -1 || targetIndex != -1 || focusedParticipant instanceof LogEntry) {
                ArrayList<TableCellDifference> result = new ArrayList<TableCellDifference>();
                boolean hasOneMissing = false;
                int participantIndex = 0;
                int modelIndex = -1;
                for (EObject participant : traceDiff.getParticipants()) {
                    String projectName = TraceabilityUtils.getProjectName((EObject)participant);
                    if (projectName != null) {
                        String text = null;
                        LogEntry eo = null;
                        if (participant instanceof Trace) {
                            Trace trace = (Trace)participant;
                            if (sourceIndex != -1 && trace.getSource().size() > sourceIndex) {
                                eo = (EObject)trace.getSource().get(sourceIndex);
                            }
                            if (targetIndex != -1 && trace.getTarget().size() > 0) {
                                eo = (EObject)trace.getTarget().get(Math.min(targetIndex, trace.getTarget().size() - 1));
                            }
                            if (eo != null) {
                                text = this.getColumnTextOriginal(eo, xCol, -1);
                            }
                        }
                        if (participant instanceof LogEntry) {
                            LogEntry logEntry;
                            eo = logEntry = (LogEntry)participant;
                            text = logEntry.getMessage();
                        }
                        if (eo != null) {
                            hasOneMissing |= "?".equals(text);
                            if (!"?".equals(text)) {
                                modelIndex = participantIndex;
                            }
                            TableCellDifference d = new TableCellDifference(text, projectName, "");
                            if (focusedParticipant == participant) {
                                result.add(0, d);
                            } else {
                                result.add(d);
                            }
                        }
                    }
                    ++participantIndex;
                }
                for (TableCellDifference d : result) {
                    d.setDiffText(!hasOneMissing && cat.isUnequal() ? TraceabilityEditor.DIFF_UNEQUAL : ((hasOneMissing ? modelIndex : cat.getModelIndex()) == 0 ? "+" : "-"));
                }
                if (result.size() >= 0) {
                    return result;
                }
            }
        }
        return null;
    }

    public static Set<Object> getValueSet(List<TableCellDifference> diffs) {
        HashSet<Object> result = new HashSet<Object>();
        for (TableCellDifference diff : diffs) {
            result.add(diff.getCellText());
        }
        return result;
    }

    public Image getToolTipImage(Object element) {
        if (this.myXviewer.hoverElement == element) {
            XViewerColumn xCol = this.myXviewer.hoverCol;
            String txt = this.getToolTipText(element);
            if (txt != null && txt.contains("\n")) {
                return null;
            }
            return this.getColumnImage(element, xCol, -1);
        }
        return null;
    }

    public int getToolTipDisplayDelayTime(Object object) {
        return 500;
    }
}

