/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.cda.xml.ui.handlers;

import com.google.common.base.Stopwatch;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mdht.cda.xml.ui.handlers.CDAValueUtil;
import org.eclipse.mdht.uml.cda.CDAFactory;
import org.eclipse.mdht.uml.cda.ClinicalDocument;
import org.eclipse.mdht.uml.cda.Section;
import org.eclipse.mdht.uml.cda.StrucDocText;
import org.eclipse.mdht.uml.cda.util.CDAUtil;
import org.eclipse.mdht.uml.hl7.datatypes.DatatypesPackage;
import org.eclipse.mdht.uml.hl7.datatypes.ED;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class StripCDANarrativeHandler
extends AbstractHandler {
    protected String folderPrefix = "NarrativeRemoved";
    public static final SimpleDateFormat DATE_FORMAT3 = new SimpleDateFormat("yyyyMMdd");
    ArrayList<IFile> documents = new ArrayList();
    protected static DecimalFormat format2Places = new DecimalFormat(".##");

    public String getFolderPrefix() {
        return this.folderPrefix;
    }

    public void setFolderPrefix(String folderPrefix) {
        this.folderPrefix = folderPrefix;
    }

    public void stripNarratives(IFile file) throws Exception {
        URI cdaURI = URI.createFileURI((String)file.getLocation().toOSString());
        ClinicalDocument clinicalDocument = null;
        CDAUtil.Filter<ED> iiFilter = new CDAUtil.Filter<ED>(){

            public boolean accept(ED ed) {
                String result;
                Section section;
                if (ed.getReference() != null && !StringUtils.isEmpty((String)ed.getReference().getValue()) && (section = CDAUtil.getSection((EObject)ed)) != null && !StringUtils.isEmpty((String)(result = CDAValueUtil.getValue(section, ed)))) {
                    EcoreUtil.delete((EObject)ed.getReference());
                    ed.eUnset(DatatypesPackage.eINSTANCE.eClass().getEStructuralFeature(DatatypesPackage.eINSTANCE.getED_Reference().getFeatureID()));
                }
                return true;
            }
        };
        try {
            Throwable throwable = null;
            Iterator iterator = null;
            try (InputStream is = Files.newInputStream(Paths.get(cdaURI.toFileString(), new String[0]), new OpenOption[0]);){
                clinicalDocument = CDAUtil.load((InputStream)is, null);
                CDAUtil.Query query = new CDAUtil.Query(clinicalDocument);
                query.getEObjects(ED.class, (CDAUtil.Filter)iiFilter);
                is.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Resource.IOWrappedException iowe) {
            System.out.println("error processing " + cdaURI.toFileString());
            return;
        }
        for (Section section : clinicalDocument.getSections()) {
            StrucDocText sdc = CDAFactory.eINSTANCE.createStrucDocText();
            sdc.addText("NARRATIVE REMOVED");
            section.setText(sdc);
        }
        if (file.getParent() != null) {
            IPath p = file.getParent().getProjectRelativePath();
            p = p.append(this.folderPrefix);
            IFolder f = file.getProject().getFolder(p);
            if (!f.exists()) {
                f.create(true, true, null);
            }
            int i = file.getName().lastIndexOf(file.getFileExtension());
            IFile df = f.getFile(String.valueOf(file.getName().substring(0, i - 1)) + "_NoNarrative.xml");
            Throwable throwable = null;
            Object var10_15 = null;
            try (OutputStream fileOut = Files.newOutputStream(Paths.get(df.getLocation().toOSString(), new String[0]), new OpenOption[0]);){
                CDAUtil.save((ClinicalDocument)clinicalDocument, (OutputStream)fileOut);
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        clinicalDocument.eResource().unload();
    }

    protected void processFolder(IFolder folder, IProgressMonitor monitor) throws CoreException {
        IFileStore fs1;
        int filectr = 1;
        long currentProcessingTime = 1L;
        long totalBytes = 0L;
        long totalBytes2 = 0L;
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        this.documents.clear();
        IResource[] iResourceArray = folder.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (monitor.isCanceled()) {
                monitor.done();
                break;
            }
            if (resource instanceof IFolder && !resource.getName().equals("NarrativeRemoved")) {
                this.processFolder((IFolder)resource, monitor);
            }
            if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                EFS.getStore((java.net.URI)file.getLocationURI());
                if ("XML".equalsIgnoreCase(file.getFileExtension())) {
                    this.documents.add(file);
                    fs1 = EFS.getStore((java.net.URI)file.getLocationURI());
                    totalBytes += fs1.fetchInfo().getLength();
                }
            }
            ++n2;
        }
        totalBytes2 = totalBytes;
        monitor.setTaskName("Strip Narratives Folder (" + format2Places.format((double)totalBytes2 / 1000000.0) + " MB) ");
        Comparator<IFile> c = new Comparator<IFile>(){

            @Override
            public int compare(IFile file1, IFile file2) {
                try {
                    IFileStore fs1 = EFS.getStore((java.net.URI)file1.getLocationURI());
                    IFileStore fs2 = EFS.getStore((java.net.URI)file2.getLocationURI());
                    if (fs1.fetchInfo().getLength() < fs2.fetchInfo().getLength()) {
                        return 1;
                    }
                    return -1;
                }
                catch (CoreException coreException) {
                    return 0;
                }
            }
        };
        Collections.sort(this.documents, c);
        currentProcessingTime = 0L;
        long estimatedTimeLeft = 0L;
        for (IFile document : this.documents) {
            monitor.worked(1);
            if (estimatedTimeLeft != 0L) {
                if (estimatedTimeLeft > 60L) {
                    monitor.setTaskName("Strip Narratives Folder (" + format2Places.format((double)totalBytes2 / 1000000.0) + " MB), Estimated Time to finish : " + (int)estimatedTimeLeft / 60 + " Minutes ");
                } else {
                    monitor.setTaskName("Strip Narratives Folder (" + format2Places.format((double)totalBytes2 / 1000000.0) + " MB), Estimated Time to finish : " + (int)estimatedTimeLeft + " Seconds ");
                }
            }
            fs1 = EFS.getStore((java.net.URI)document.getLocationURI());
            long fileSize = fs1.fetchInfo().getLength();
            monitor.subTask("Processing " + StringUtils.center((String)StringUtils.abbreviate((String)document.getName(), (int)16), (int)16) + "(" + format2Places.format((double)fs1.fetchInfo().getLength() / 1000000.0) + " MB)" + " File # " + StringUtils.center((String)String.valueOf(filectr++), (int)10) + " LAST " + StringUtils.center((String)String.valueOf((double)currentProcessingTime / 1000.0), (int)6) + " Seconds");
            try {
                stopwatch.reset();
                stopwatch.start();
                this.stripNarratives(document);
                stopwatch.stop();
                currentProcessingTime = stopwatch.elapsed(TimeUnit.MILLISECONDS);
                long ratePerSecond = fileSize / stopwatch.elapsed(TimeUnit.MILLISECONDS);
                totalBytes -= fileSize;
                if (ratePerSecond != 0L) {
                    estimatedTimeLeft = totalBytes / ratePerSecond / 1000L;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (monitor.isCanceled()) break;
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        block7: {
            try {
                ProgressMonitorDialog pd = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
                if (!(selection instanceof IStructuredSelection)) break block7;
                final IStructuredSelection iss = (IStructuredSelection)selection;
                try {
                    pd.run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                Iterator iter = iss.iterator();
                                while (iter.hasNext() && !monitor.isCanceled()) {
                                    Object o = iter.next();
                                    if (o instanceof IFolder) {
                                        IFolder folder = (IFolder)o;
                                        monitor.beginTask("DeIdentify CDA Documents", folder.members().length);
                                        StripCDANarrativeHandler.this.processFolder(folder, monitor);
                                    }
                                    if (!(o instanceof IFile)) continue;
                                    StripCDANarrativeHandler.this.stripNarratives((IFile)o);
                                }
                            }
                            catch (PartInitException partInitException) {
                            }
                            catch (CoreException coreException) {
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                int n = iProjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project = iProjectArray[n2];
                    project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                    ++n2;
                }
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                Clipboard cb = new Clipboard(Display.getDefault());
                StringBuilder sb = new StringBuilder();
                for (IFile document : this.documents) {
                    sb.append(document.getName());
                }
                TextTransfer textTransfer = TextTransfer.getInstance();
                cb.setContents(new Object[]{sb.toString()}, new Transfer[]{textTransfer});
                StripCDANarrativeDialog dlg = new StripCDANarrativeDialog(window.getShell());
                dlg.create();
                dlg.open();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public class StripCDANarrativeDialog
    extends TitleAreaDialog {
        Table table;

        public StripCDANarrativeDialog(Shell shell) {
            super(shell);
        }

        public void create() {
            super.create();
            this.setTitle("DeIdentification Results");
        }

        protected Control createDialogArea(Composite parent) {
            ScrolledComposite composite = new ScrolledComposite(parent, 512);
            composite.setLayout((Layout)new GridLayout());
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            this.table = new Table((Composite)composite, 2050);
            this.table.setHeaderVisible(true);
            this.table.setSize(100, 100);
            composite.setContent((Control)this.table);
            composite.setExpandHorizontal(true);
            composite.setExpandVertical(true);
            composite.setAlwaysShowScrollBars(true);
            composite.setMinSize(this.table.computeSize(-1, -1));
            this.table.setLinesVisible(true);
            GridData gridData = new GridData();
            gridData.widthHint = 500;
            this.table.setLayoutData((Object)gridData);
            this.table.setHeaderVisible(true);
            TableColumn column1 = new TableColumn(this.table, 16384);
            TableColumn column2 = new TableColumn(this.table, 16384);
            column1.setText("File Name");
            column2.setText("Size (MB)");
            column1.setWidth(250);
            column2.setWidth(250);
            for (IFile file : StripCDANarrativeHandler.this.documents) {
                try {
                    IFileStore fs1 = EFS.getStore((java.net.URI)file.getLocationURI());
                    TableItem valueSetsUpdatedItem = new TableItem(this.table, 0);
                    valueSetsUpdatedItem.setText(new String[]{fs1.fetchInfo().getName(), String.valueOf(fs1.fetchInfo().getLength() / 1000000L)});
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            return composite;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            Button okButton = this.createButton(parent, 0, "Ok", false);
            okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    StripCDANarrativeDialog.this.setReturnCode(0);
                    StripCDANarrativeDialog.this.close();
                }
            });
        }
    }
}

