/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.cda.xml.ui.views;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mdht.cda.xml.ui.editors.CDAAnalyzer;
import org.eclipse.mdht.uml.cda.Section;
import org.eclipse.mdht.uml.cda.util.CDAUtil;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.part.ViewPart;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;

public class RawView
extends ViewPart {
    Browser browser;
    StringComparator stringComparator = new StringComparator();

    private String formatTagsAndAttributes(String xml, Set<String> tags, Set<String> attributes, Set<String> contents) {
        String newXML = xml;
        ArrayList<String> orderedTags = new ArrayList<String>();
        ArrayList<String> orderedAttributes = new ArrayList<String>();
        ArrayList<String> orderedContents = new ArrayList<String>();
        orderedTags.addAll(tags);
        orderedAttributes.addAll(attributes);
        orderedContents.addAll(contents);
        Collections.sort(orderedTags, this.stringComparator);
        Collections.sort(orderedAttributes, this.stringComparator);
        Collections.sort(orderedContents, this.stringComparator);
        newXML = newXML.replace("=&quot;", "=<span style=\"color:DodgerBlue\">&quot;").replace("&quot;/&gt;", "&quot;</span>/&gt;").replace("&quot;&gt;", "&quot;</span>&gt;").replace("&quot; ", "&quot;</span> ");
        for (String tag : orderedTags) {
            newXML = newXML.replace("&lt;" + tag, "<span style=\"color:green\">&lt;" + tag + "</span>").replace("&lt;/" + tag + "&gt;", "<span style=\"color:green\">&lt;/" + tag + "&gt;</span>");
        }
        for (String attribute : orderedAttributes) {
            newXML = newXML.replace(String.valueOf(attribute) + "=", "<span style=\"color:IndianRed\">" + attribute + "=</span>");
        }
        return newXML;
    }

    private void populate(Node node, Set<String> nodes, Set<String> attributes, Set<String> contents) {
        NodeList nl = node.getChildNodes();
        NamedNodeMap nodeMap = node.getAttributes();
        if (nodeMap != null) {
            int numAttrs = nodeMap.getLength();
            int i = 0;
            while (i < numAttrs) {
                Attr attr = (Attr)nodeMap.item(i);
                String attrName = attr.getNodeName();
                attributes.add(attrName);
                ++i;
            }
        }
        int i = 0;
        while (i < nl.getLength()) {
            if ("#text".equals(nl.item(i).getNodeName())) {
                contents.add(nl.item(i).getTextContent().trim());
            }
            nodes.add(nl.item(i).getNodeName());
            this.populate(nl.item(i), nodes, attributes, contents);
            ++i;
        }
    }

    private String formatSection(String sectionxml, Set<String> nodes, Set<String> attributes, Set<String> contents) {
        try {
            InputSource inputSource = new InputSource(new StringReader(sectionxml));
            Element document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputSource).getDocumentElement();
            Boolean keepDeclaration = sectionxml.startsWith("<?xml");
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            LSSerializer writer = impl.createLSSerializer();
            writer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
            writer.getDomConfig().setParameter("xml-declaration", keepDeclaration);
            this.populate(document, nodes, attributes, contents);
            return writer.writeToString(document);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void addTableListener(Table table) {
        table.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
            }
        });
        table.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.item.getData() instanceof Section) {
                    Section section = (Section)event.item.getData();
                    ByteArrayOutputStream fa = new ByteArrayOutputStream();
                    try {
                        TableItem ti;
                        CDAUtil.saveSnippet((EObject)EcoreUtil.copy((EObject)section), (OutputStream)fa);
                        HashSet nodes = new HashSet();
                        HashSet attributes = new HashSet();
                        HashSet contents = new HashSet();
                        String sectionContent = StringEscapeUtils.escapeHtml((String)RawView.this.formatSection(fa.toString(), nodes, attributes, contents));
                        sectionContent = RawView.this.formatTagsAndAttributes(sectionContent, nodes, attributes, contents);
                        String filename = "";
                        if (event.item instanceof TableItem && !StringUtils.isEmpty((String)(ti = (TableItem)event.item).getParent().getToolTipText())) {
                            filename = ti.getParent().getToolTipText();
                        }
                        String sectionTitle = "";
                        if (section.getTitle() != null && section.getTitle().getText() != null) {
                            sectionTitle = section.getTitle().getText().toUpperCase();
                        }
                        sectionContent = String.format("<html><head><style>p { text-align: center; color: red;} </style></head><body>%s SECTION CONTENT (%s)<br/><span style=\"color:green\"><pre>%s</pre></span></body></html>", sectionTitle, filename, sectionContent);
                        RawView.this.browser.setText(sectionContent);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public void clearView() {
        this.browser.setText("");
    }

    public void createPartControl(Composite parent) {
        this.browser = new Browser(parent, 2048);
        Menu menu = new Menu((Control)this.browser);
        MenuItem printMenuItem = new MenuItem(menu, 64);
        printMenuItem.setText("Print");
        printMenuItem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                RawView.this.browser.execute("window.print();");
            }
        });
        this.browser.setMenu(menu);
        if (this.getSite().getPage().getPerspective() != null) {
            IEditorReference[] iEditorReferenceArray = this.getSite().getPage().getEditorReferences();
            int n = iEditorReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                CDAAnalyzer analyzer;
                IEditorReference editorReference = iEditorReferenceArray[n2];
                if ("org.eclipse.mdht.cda.xml.ui.editors.CDAAnalyzer".equals(editorReference.getId()) && (analyzer = (CDAAnalyzer)editorReference.getEditor(false)) != null) {
                    this.addTableListener(analyzer.getTable());
                }
                ++n2;
            }
        }
    }

    public void setFocus() {
    }

    public static class StringComparator
    implements Comparator<String> {
        @Override
        public int compare(String o1, String o2) {
            if (o1.length() > o2.length()) {
                return -1;
            }
            if (o2.length() > o1.length()) {
                return 1;
            }
            return 0;
        }
    }
}

