/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.dita;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.mdht.uml.cda.core.util.CDACommonUtils;
import org.eclipse.mdht.uml.cda.core.util.CDAModelUtil;
import org.eclipse.mdht.uml.cda.dita.DitaTransformerOptions;
import org.eclipse.mdht.uml.cda.dita.TransformAbstract;
import org.eclipse.mdht.uml.cda.dita.internal.Logger;
import org.eclipse.mdht.uml.common.util.UMLUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;

public class TransformClass
extends TransformAbstract {
    private Set<Class> alreadyHandled = new HashSet<Class>();
    private Set<Class> alreadyHandledForPrintTerminologyConstraintAsList = new HashSet<Class>();

    public TransformClass(DitaTransformerOptions options) {
        super(options);
    }

    private void appendBody(PrintWriter writer, Class umlClass) {
        String normalizedClassName = TransformClass.normalizeCodeName(umlClass.getName());
        writer.println("<body>");
        writer.println("<section conref=\"generated/_" + normalizedClassName + ".dita#classId/knownSubclasses\">");
        writer.println("</section>");
        writer.println("<!-- TODO: insert non-model class description markup here -->");
        writer.println("<section conref=\"generated/_" + normalizedClassName + ".dita#classId/description\">");
        writer.println("</section>");
        writer.println("<section audience=\"contextTable\" conref=\"generated/_" + normalizedClassName + ".dita#classId/contextTable\">");
        writer.println("</section>");
        writer.println("<!-- TODO: insert UML class diagram here -->");
        writer.println();
        writer.println("<ol audience=\"standards\" conref=\"generated/_" + normalizedClassName + ".dita#classId/conformance\">");
        writer.println("<li></li>");
        writer.println("</ol>");
        writer.println("<ol audience=\"developer\" conref=\"generated/_" + normalizedClassName + ".dita#classId/aggregate\">");
        writer.println("<li></li>");
        writer.println("</ol>");
        Class cdaClass = CDAModelUtil.getCDAClass((Classifier)umlClass);
        if (cdaClass != null) {
            writer.println("<section audience=\"tableconformance\"  conref=\"generated/_" + normalizedClassName + ".dita#classId/tableconformance\">");
            writer.println("</section>");
            writer.println("<p> </p>");
            writer.println("<p><b>" + TransformAbstract.getPublicationName((NamedElement)umlClass) + " example</b></p>");
            writer.println("<!-- TODO: insert custom instance example here -->");
            writer.println("<!-- generated instance example follows -->");
            writer.println("<codeblock conref=\"generated/_" + normalizedClassName + ".dita#classId/example\">");
            writer.println("</codeblock>");
        }
        writer.println("</body>");
        writer.println("</topic>");
    }

    private void appendHeader(PrintWriter writer, Class umlClass) {
        String normalizedClassName = TransformClass.normalizeCodeName(umlClass.getName());
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.println("<!DOCTYPE topic PUBLIC \"-//OASIS//DTD DITA Topic//EN\" \"topic.dtd\">");
        writer.println("<topic id=\"classId\" xml:lang=\"en-us\">");
        writer.print("<title>");
        writer.print(TransformAbstract.getPublicationName((NamedElement)umlClass));
        writer.println("</title>");
        writer.println("<shortdesc conref=\"generated/_" + normalizedClassName + ".dita#classId/shortdesc\"></shortdesc>");
        writer.println("<prolog conref=\"generated/_" + normalizedClassName + ".dita#classId/prolog\"></prolog>");
    }

    private void addReference(Class source, NamedElement target) {
        if (!UMLUtil.isSameProject((Element)source, (Element)target) && !CDAModelUtil.isCDAModel((Element)target)) {
            Path projectPath;
            IFolder referenceDitaFolder;
            IProject sourceProject = CDAModelUtil.getElementModelProject((Element)source);
            sourceProject = CDAModelUtil.getModelDocProject((IProject)sourceProject);
            IProject targetProject = CDAModelUtil.getElementModelProject((Element)target);
            if ((targetProject = CDAModelUtil.getModelDocProject((IProject)targetProject)) != null && (referenceDitaFolder = sourceProject.getFolder((IPath)(projectPath = new Path("/dita/classes/" + targetProject.getName())))).exists()) {
                this.transformerOptions.addReference(target.getQualifiedName(), String.valueOf(targetProject.getName()) + "/classes/" + TransformClass.normalizeCodeName(target.getName()) + ".dita");
            }
        }
    }

    public Object caseClass(Class umlClass) {
        Class cdaClass;
        String fileName;
        block22: {
            String normalizedClassName = TransformClass.normalizeCodeName(umlClass.getName());
            String pathFolder = "classes";
            fileName = String.valueOf(normalizedClassName) + ".dita";
            IPath filePath = this.transformerOptions.getOutputPath().append(pathFolder).addTrailingSeparator().append(normalizedClassName).addFileExtension("dita");
            File file = filePath.toFile();
            PrintWriter writer = null;
            if (this.transformerOptions.isReset() && file.exists()) {
                file.delete();
            }
            if (!file.exists()) {
                try {
                    file.createNewFile();
                    writer = new PrintWriter(file);
                    this.appendHeader(writer, umlClass);
                    this.appendBody(writer, umlClass);
                }
                catch (FileNotFoundException e) {
                    Logger.logException(e);
                    if (writer != null) {
                        writer.close();
                    }
                    break block22;
                }
                catch (IOException e1) {
                    try {
                        Logger.logException(e1);
                        break block22;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                }
                if (writer == null) break block22;
                writer.close();
            }
        }
        List<String> packageContent = this.transformerOptions.getPackageContentList(umlClass.getNearestPackage());
        packageContent.add(fileName);
        this.checkClassReferences(umlClass, umlClass);
        if (this.transformerOptions.isPrintTerminologyConstraintAsList()) {
            CDACommonUtils.printTerminologyConstraintAsList((Class)umlClass, this.alreadyHandledForPrintTerminologyConstraintAsList);
        }
        if ((cdaClass = CDAModelUtil.getCDAClass((Classifier)umlClass)) != null) {
            if (CDAModelUtil.isClinicalDocument((Type)cdaClass)) {
                this.transformerOptions.getDocumentList().add(fileName);
            } else if (CDAModelUtil.isSection((Type)cdaClass)) {
                this.transformerOptions.getSectionList().add(fileName);
            } else if (CDAModelUtil.isClinicalStatement((Type)cdaClass)) {
                this.transformerOptions.getClinicalStatementList().add(fileName);
            } else {
                this.transformerOptions.getClassList().add(fileName);
            }
        } else {
            List parentNames = UMLUtil.getAllParentNames((Classifier)umlClass);
            parentNames.remove(0);
            if (parentNames.contains("QDM Element")) {
                this.transformerOptions.getSectionList().add(fileName);
            } else {
                this.transformerOptions.getClassList().add(fileName);
            }
        }
        return umlClass;
    }

    private boolean checkClassReferences(Class source, Class umlClass) {
        if (!this.alreadyHandled.add(umlClass)) {
            return false;
        }
        if (CDAModelUtil.isCDAModel((Element)umlClass) || CDAModelUtil.isDatatypeModel((Element)umlClass)) {
            return false;
        }
        for (Property property : umlClass.getOwnedAttributes()) {
            if (!(property.getType() instanceof Class) || !this.checkClassReferences(source, (Class)property.getType()) || CDAModelUtil.isDisplayInline((Property)property)) continue;
            this.addReference(source, (NamedElement)property.getType());
        }
        for (Generalization generalization : umlClass.getGeneralizations()) {
            if (!(generalization.getGeneral() instanceof Class) || !this.checkClassReferences(source, (Class)generalization.getGeneral())) continue;
            this.addReference(source, (NamedElement)generalization.getGeneral());
        }
        return true;
    }
}

