/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.ui.actions;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mdht.uml.ui.actions.UML2AbstractAction;
import org.eclipse.mdht.uml.ui.internal.Logger;
import org.eclipse.mdht.uml.ui.internal.l10n.UML2UIMessages;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;

public class AddUMLAttributeAction
extends UML2AbstractAction {
    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        if (this.isReadOnly()) {
            action.setEnabled(false);
        }
    }

    protected void postProcess(Property newProperty) {
    }

    public void run(IAction action) {
        try {
            final Element element = this.getSelectedElement();
            if (element instanceof Classifier) {
                AbstractEMFOperation operation = new AbstractEMFOperation(this.editingDomain, UML2UIMessages.AddUMLAttribute_operation_title){

                    protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                        Property newProperty = null;
                        if (element instanceof Class) {
                            String name = AddUMLAttributeAction.this.getUniqueMemberName((Classifier)((Class)element), UML2UIMessages.AddUMLAttribute_default_name);
                            newProperty = ((Class)element).createOwnedAttribute(name, null);
                        } else if (element instanceof DataType) {
                            String name = AddUMLAttributeAction.this.getUniqueMemberName((Classifier)((DataType)element), UML2UIMessages.AddUMLAttribute_default_name);
                            newProperty = ((DataType)element).createOwnedAttribute(name, null);
                        }
                        newProperty.setLower(0);
                        newProperty.setUpper(1);
                        AddUMLAttributeAction.this.postProcess(newProperty);
                        if (newProperty != null && AddUMLAttributeAction.this.activePart instanceof ISetSelectionTarget) {
                            ((ISetSelectionTarget)AddUMLAttributeAction.this.activePart).selectReveal((ISelection)new StructuredSelection((Object)newProperty));
                        }
                        return Status.OK_STATUS;
                    }
                };
                try {
                    IWorkspaceCommandStack commandStack = (IWorkspaceCommandStack)this.editingDomain.getCommandStack();
                    operation.addContext(commandStack.getDefaultUndoContext());
                    commandStack.getOperationHistory().execute((IUndoableOperation)operation, (IProgressMonitor)new NullProgressMonitor(), (IAdaptable)this.activePart);
                }
                catch (ExecutionException ee) {
                    Logger.logException(ee);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }
}

