/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.operations;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.xmi.util.XMLProcessor;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.mdht.uml.cda.CDAFactory;
import org.eclipse.mdht.uml.cda.ClinicalDocument;
import org.eclipse.mdht.uml.cda.ClinicalStatement;
import org.eclipse.mdht.uml.cda.Entry;
import org.eclipse.mdht.uml.cda.Section;
import org.eclipse.mdht.uml.cda.StrucDocText;
import org.eclipse.mdht.uml.cda.util.CDAUtil;
import org.eclipse.mdht.uml.hl7.datatypes.CD;
import org.eclipse.mdht.uml.hl7.datatypes.CE;
import org.eclipse.mdht.uml.hl7.datatypes.CS;
import org.eclipse.mdht.uml.hl7.datatypes.DatatypesFactory;
import org.eclipse.mdht.uml.hl7.datatypes.ED;
import org.eclipse.mdht.uml.hl7.datatypes.II;
import org.eclipse.mdht.uml.hl7.rim.InfrastructureRoot;
import org.eclipse.mdht.uml.hl7.vocab.NullFlavor;
import org.junit.Assert;
import org.xml.sax.InputSource;

public abstract class CDAValidationTest {
    protected static final String BAD_TEMPLATE_ID = "1.2.3.4";
    protected static final II THE_BAD_II = DatatypesFactory.eINSTANCE.createII();
    protected static final String BAD_CODESYSTEM_ID = "6.66.666.6.666666.6.666";
    protected static final String BAD_CODE_VALUE = "NOTACODE";
    protected static final String SNOMEDCT_ID = "2.16.840.1.113883.6.96";
    protected static final String LOINC_ID = "2.16.840.1.113883.6.1";
    protected static final String PRECISE_TO_DAY = "20091212";
    protected static final String PRECISE_TO_MINUTE = "200912121721";
    protected static final String PRECISE_TO_SECOND = "20091212172151";
    protected static final String PRECISE_TO_HOUR_WITH_TIMEZONE = "2012091619-0400";
    protected static final String PRECISE_TO_MINUTE_WITH_TIMEZONE = "201209161918-0400";
    protected static final String PRECISE_TO_SECOND_WITH_TIMEZONE = "20050329171504+0500";
    protected static final String PRECISE_TO_MS_WITH_TIMEZONE = "20091212172151.035-0500";
    protected static Map<Object, Object> map;

    static {
        THE_BAD_II.setRoot(BAD_TEMPLATE_ID);
        map = new HashMap<Object, Object>();
    }

    protected abstract EObject getObjectToTest();

    protected EObject getObjectInitToTest() {
        return null;
    }

    protected List<CDATestCase> getTestCases() {
        return new ArrayList<CDATestCase>();
    }

    protected static String createUnsupportedOperationFailureMessage(String testTargetDescription, UnsupportedOperationException uoe) {
        return "The test \"" + testTargetDescription + "\" failed because of \"" + uoe.getMessage() + "\".  This is likely due to errors in the OCL.";
    }

    protected static String createAssertionFailureMessage(BasicDiagnostic diagnostician) {
        return CDAValidationTest.createAssertionFailureMessage(diagnostician, "");
    }

    protected static String createAssertionFailureMessage(BasicDiagnostic diagnostician, String source) {
        StringBuilder sb = new StringBuilder(source);
        sb.append(": ");
        for (Diagnostic diagnostic : diagnostician.getChildren()) {
            sb.append(" ");
            sb.append(diagnostic.getMessage());
        }
        return sb.toString();
    }

    private static void saveTestSnippet(EObject snippet, OutputStream out) throws Exception {
        ClinicalDocument containerDocument = CDAUtil.getClinicalDocument((EObject)snippet);
        if (containerDocument != null) {
            CDAUtil.save((ClinicalDocument)((ClinicalDocument)EcoreUtil.copy((EObject)containerDocument)), (OutputStream)out);
        } else {
            CDAUtil.saveSnippet((EObject)EcoreUtil.copy((EObject)snippet), (OutputStream)out);
        }
    }

    protected static abstract class CDAAddTestCase
    extends CDAOperationsTestCase {
        protected CDAAddTestCase(String testTargetDescription) {
            super(testTargetDescription);
        }

        @Override
        protected void doTest(EObject objectToTest, BasicDiagnostic diagnostician, Map<Object, Object> map) {
            EObject eObjectToAdd = this.getEObjectToAdd();
            this.doAdd(objectToTest, eObjectToAdd);
            boolean isFound = this.isFound(objectToTest, eObjectToAdd, this.getFeature());
            Assert.assertTrue((String)("Add \"" + this.getTestTargetDescription() + "\" failed for \"" + objectToTest.eClass().getName() + "\""), (boolean)isFound);
        }

        protected abstract EStructuralFeature getFeature();

        protected boolean isFound(EObject objectToTest, EObject eObjectToFind, EStructuralFeature feature) {
            return eObjectToFind.eContainingFeature().equals(feature) && eObjectToFind.eContainer().eContainer().equals(objectToTest);
        }
    }

    protected static abstract class CDAGetTestCase
    extends CDAOperationsTestCase {
        protected CDAGetTestCase(String testTargetDescription) {
            super(testTargetDescription);
        }

        @Override
        protected void doTest(EObject objectToTest, BasicDiagnostic diagnostician, Map<Object, Object> map) {
            EObject eObjectToAdd = this.getEObjectToAdd();
            this.doAdd(objectToTest, eObjectToAdd);
            Object value = this.doGet(objectToTest);
            boolean getIsGood = this.isGetGood(eObjectToAdd, value);
            Assert.assertTrue((String)("Get \"" + this.getTestTargetDescription() + "\" failed for \"" + objectToTest.eClass().getName() + "\""), (boolean)getIsGood);
        }

        protected boolean isGetGood(EObject eObjectToAdd, Object value) {
            EList list = (EList)value;
            return list.size() == 1 && list.get(0).equals(eObjectToAdd);
        }

        protected abstract Object doGet(EObject var1);
    }

    protected static abstract class CDAHasTestCase
    extends CDAOperationsTestCase {
        protected static final String TEMPLATE_ID = "1.2.3.4";
        protected static final II THE_II = DatatypesFactory.eINSTANCE.createII();
        protected static final String CODE = "code";
        protected static final String CODE_SYSTEM = "codeSystem";
        protected static final String CODE_SYSTEM_NAME = "codeSystemName";
        protected static final String CODE_DISPLAY_NAME = "codeDisplayName";
        protected static final CD THE_CODE = DatatypesFactory.eINSTANCE.createCD("code", "codeSystem", "codeSystemName", "codeDisplayName");
        protected static final CE THE_CE_CODE = DatatypesFactory.eINSTANCE.createCE("code", "codeSystem", "codeSystemName", "codeDisplayName");
        protected static final CS THE_CS_CODE = DatatypesFactory.eINSTANCE.createCS("code");

        protected CDAHasTestCase(String testTargetDescription) {
            super(testTargetDescription);
            THE_II.setRoot("1.2.3.4");
        }

        @Override
        protected void doTest(EObject objectToTest, BasicDiagnostic diagnostician, Map<Object, Object> map) {
            EObject eObjectToAdd = this.getEObjectToAdd();
            this.doAddTemplateId(eObjectToAdd, THE_II);
            this.doAdd(objectToTest, eObjectToAdd);
            boolean hasIsGood = this.doHas(objectToTest, "1.2.3.4");
            Assert.assertTrue((String)("Has \"" + this.getTestTargetDescription() + "\" failed for \"" + objectToTest.eClass().getName() + "\""), (boolean)hasIsGood);
        }

        protected abstract void doAddTemplateId(EObject var1, II var2);

        protected abstract boolean doHas(EObject var1, String var2);
    }

    protected static abstract class CDAMutualExclusionValidationTestCase
    extends MutualExclusionValidationTestCase {
        private static final Set<String> MUTUALLY_EXCLUSIVE_EREFERENCE_NAMES = new HashSet<String>(Arrays.asList("encounter", "observation", "observationMedia", "organizer", "procedure", "regionOfInterest", "substanceAdministration", "supply"));

        protected CDAMutualExclusionValidationTestCase(String validationTargetDescription) {
            super(validationTargetDescription, MUTUALLY_EXCLUSIVE_EREFERENCE_NAMES);
        }
    }

    protected static abstract class CDAOperationsTestCase
    extends CDATestCase {
        protected CDAOperationsTestCase(String testTargetDescription) {
            super(testTargetDescription);
        }

        protected abstract void doAdd(EObject var1, EObject var2);

        protected abstract EObject getEObjectToAdd();
    }

    protected static abstract class CDATestCase {
        private final String testTargetDescription;

        protected CDATestCase(String testTargetDescription) {
            this.testTargetDescription = testTargetDescription;
        }

        protected abstract void doTest(EObject var1, BasicDiagnostic var2, Map<Object, Object> var3);

        protected String getTestTargetDescription() {
            return this.testTargetDescription;
        }

        public String toString() {
            return this.getTestTargetDescription();
        }
    }

    protected static abstract class CDAValidationTestCase
    extends CDATestCase {
        public CDAValidationTestCase(String testTargetDescription) {
            super(testTargetDescription);
        }

        protected abstract boolean validate(EObject var1, BasicDiagnostic var2, Map<Object, Object> var3);

        protected void validateExpectSkip(EObject objectToTest, BasicDiagnostic diagnostician, Map<Object, Object> map) {
            boolean isValid = this.validate(objectToTest, diagnostician, map);
            Assert.assertTrue((String)("ERROR EXPECT IGNORE " + CDAValidationTest.createAssertionFailureMessage(diagnostician, this.getTestTargetDescription())), (boolean)isValid);
        }

        protected void validateExpectPass(EObject objectToTest, BasicDiagnostic diagnostician, Map<Object, Object> map) {
            boolean isValid = this.validate(objectToTest, diagnostician, map);
            Assert.assertTrue((String)("ERROR EXPECT PASS " + CDAValidationTest.createAssertionFailureMessage(diagnostician, this.getTestTargetDescription())), (boolean)isValid);
        }

        protected void validateExpectFail(EObject objectToTest, BasicDiagnostic diagnostician, Map<Object, Object> map) {
            boolean isValid = this.validate(objectToTest, diagnostician, map);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            String xml = "";
            try {
                CDAValidationTest.saveTestSnippet(objectToTest, out);
                xml = out.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Assert.assertTrue((String)("ERROR EXPECT FAIL " + this.getTestTargetDescription() + "\" passed when it was expected to fail." + xml), (!isValid ? 1 : 0) != 0);
        }
    }

    protected static abstract class MutualExclusionValidationTestCase
    extends UndefinedValidationTestCase {
        public MutualExclusionValidationTestCase(String validationTargetDescription, Set<String> eReferenceNames) {
            super(validationTargetDescription, eReferenceNames);
        }

        @Override
        protected void doTest(EObject objectToTest, BasicDiagnostic diagnostician, Map<Object, Object> map) {
            this.validateExpectFail(objectToTest, diagnostician, map);
            this.initializeobjectToTest(objectToTest);
            this.validateExpectPass(objectToTest, diagnostician, map);
            for (String eReferenceName : this.getEReferenceNames()) {
                EReference eReference = (EReference)objectToTest.eClass().getEStructuralFeature(eReferenceName);
                Assert.assertNotNull((String)this.createEReferenceNotFoundMessage(objectToTest, eReferenceName), (Object)eReference);
                objectToTest.eSet((EStructuralFeature)eReference, (Object)CDAFactory.eINSTANCE.create((EClass)eReference.getEType()));
                this.validateExpectFail(objectToTest, diagnostician, map);
                objectToTest.eUnset((EStructuralFeature)eReference);
            }
        }

        protected abstract void initializeobjectToTest(EObject var1);
    }

    protected static abstract class NarrativeReferenceTestCase<T>
    extends OperationsTestCase<T> {
        Section sectionToSerialize = null;

        @Override
        protected EObject getObjectToSerialze() {
            return this.sectionToSerialize;
        }

        public NarrativeReferenceTestCase(String testTargetDescription, String ocl, TestObjectFactory<?> testObjectFactory) {
            super(testTargetDescription, ocl, testObjectFactory);
        }

        protected static EClass getEClass(EPackage epackage, Class<?> instanceClass) {
            EClass result = null;
            for (EClassifier next : epackage.getEClassifiers()) {
                if (next.getInstanceClass() != instanceClass) continue;
                result = (EClass)next;
                break;
            }
            Assert.assertNotNull((String)String.format("Instance class not found in package %s for %s.", epackage.getName(), instanceClass.getName()), (Object)result);
            return result;
        }

        protected static void addContainedElement(EObject container, EObject contained) {
            EReference best = null;
            for (EReference next : container.eClass().getEAllContainments()) {
                if (!next.getEReferenceType().isInstance((Object)contained)) continue;
                if (best == null) {
                    best = next;
                    continue;
                }
                if (best.isMany() && !next.isMany()) {
                    best = next;
                    continue;
                }
                if (!best.getEReferenceType().isSuperTypeOf(next.getEReferenceType())) continue;
                best = next;
            }
            Assert.assertNotNull((String)String.format("Could not find containment reference for %s in %s.", contained.eClass().getName(), container.eClass().getName()), (Object)best);
            if (FeatureMapUtil.isMany((EObject)container, (EStructuralFeature)best)) {
                Collection list = (Collection)best.eGet((EStructuralFeature)best);
                list.add(contained);
            } else {
                container.eSet((EStructuralFeature)best, (Object)contained);
            }
        }

        protected <S extends Section> S createSectionForClinicalStatement(ClinicalStatement statement, EPackage epackage, Class<? extends S> sectionType) {
            Section result = (Section)epackage.getEFactoryInstance().create(NarrativeReferenceTestCase.getEClass(epackage, sectionType));
            try {
                Method initMethod = result.getClass().getDeclaredMethod("init", new Class[0]);
                if (initMethod != null) {
                    initMethod.invoke((Object)result, new Object[0]);
                }
            }
            catch (Exception initMethod) {
                // empty catch block
            }
            Entry entry = CDAFactory.eINSTANCE.createEntry();
            NarrativeReferenceTestCase.addContainedElement((EObject)entry, (EObject)statement);
            result.getEntries().add((Object)entry);
            return (S)result;
        }

        protected CD createCDWithOriginalTextReference(String text, String reference) {
            CD result = DatatypesFactory.eINSTANCE.createCD();
            result.setOriginalText(this.createEDWithReference(text, reference));
            return result;
        }

        protected CE createCEWithOriginalTextReference(String text, String reference) {
            CE result = DatatypesFactory.eINSTANCE.createCE();
            result.setOriginalText(this.createEDWithReference(text, reference));
            return result;
        }

        protected ED createEDWithReference(String text, String reference) {
            ED result = DatatypesFactory.eINSTANCE.createED(text);
            if (!reference.startsWith("#")) {
                reference = "#" + reference;
            }
            result.setReference(DatatypesFactory.eINSTANCE.createTEL(reference));
            return result;
        }

        protected StrucDocText createStrucDocText(String id, String text) {
            StrucDocText result = CDAFactory.eINSTANCE.createStrucDocText();
            try {
                HashMap<String, Boolean> loadOptions = new HashMap<String, Boolean>();
                loadOptions.put("RECORD_UNKNOWN_FEATURE", true);
                loadOptions.put("SUPPRESS_DOCUMENT_ROOT", true);
                Resource xml = new XMLProcessor().load(new InputSource(new StringReader(String.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<blurb xmlns=\"urn:hl7-org:v3\" ID=\"%s\">\n    %s\n</blurb>\n", id, text))), loadOptions);
                AnyType stuff = (AnyType)xml.getContents().get(0);
                result.getMixed().add(ExtendedMetaData.INSTANCE.demandFeature("urn:hl7-org:v3", "content", true), (Object)stuff);
            }
            catch (Exception e) {
                Assert.fail((String)("Failed to set up structured document text: " + e.getLocalizedMessage()));
            }
            return result;
        }

        protected void addText(Section section, String id, String text) {
            section.setText(this.createStrucDocText(id, text));
            this.sectionToSerialize = section;
        }
    }

    protected static abstract class OperationsTestCase<ValidationTarget>
    extends CDAValidationTestCase {
        private boolean skipFailsTest = false;
        private boolean skipPassTest = false;
        private boolean skipNullFlavorTest = true;
        private boolean checkDependency = false;
        ArrayList<PassTest> passTests = new ArrayList();
        ArrayList<FailTest> failTests = new ArrayList();
        private static final String[] ENDTAGS = new String[]{"<failsnippet>", "</failsnippet>", "<passsnippet>", "</passsnippet>"};
        private static final int FAILSNIPPET = 0;
        private static final int PASSSNIPPET = 2;
        protected TestObjectFactory<?> testObjectFactory;
        String testLogDir = null;
        String ocl = null;

        public void skipFailsTest() {
            this.skipFailsTest = true;
        }

        public void skipNullTest() {
            this.skipNullFlavorTest = true;
        }

        public void skipPassTest() {
            this.skipPassTest = true;
        }

        public void runDependencyTest() {
            this.checkDependency = true;
        }

        public void addPassTest(PassTest passTest) {
            this.passTests.add(passTest);
        }

        public void addFailTests() {
        }

        public void addPassTests() {
        }

        public void addFailTest(FailTest failTest) {
            this.failTests.add(failTest);
        }

        private static String escapeXML(int snippetType, EObject objectToTest) {
            String xml = "";
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                CDAValidationTest.saveTestSnippet(objectToTest, out);
                xml = StringEscapeUtils.escapeHtml((String)out.toString());
                xml = xml.replace(System.getProperty("line.separator"), "<br/>");
            }
            catch (Exception exception) {
                // empty catch block
            }
            xml = String.valueOf(ENDTAGS[snippetType]) + "<br/>" + xml + "<br/>" + ENDTAGS[snippetType + 1];
            return xml;
        }

        private static String generateSkipMessage(int snippetType, String message) {
            return String.valueOf(ENDTAGS[snippetType]) + "<br/>" + message + "<br/>" + ENDTAGS[snippetType + 1];
        }

        public OperationsTestCase(String testTargetDescription, String ocl, TestObjectFactory<?> testObjectFactory) {
            super(testTargetDescription);
            this.ocl = ocl;
            this.testObjectFactory = testObjectFactory;
            this.testLogDir = System.getProperty("testlogdir");
            if (this.testLogDir == null) {
                System.out.println();
                System.out.println("Running " + this.getTestTargetDescription());
                System.out.println();
            }
        }

        private void runFails(StringBuffer xmlSnippetsBuffer) {
            boolean gotDiagnostic = false;
            for (FailTest failTest : this.failTests) {
                Object target = this.testObjectFactory.create();
                BasicDiagnostic diagnostician = Diagnostician.INSTANCE.createDefaultDiagnostic((EObject)target);
                failTest.updateToFail(target);
                if (this.testLogDir != null) {
                    xmlSnippetsBuffer.append(OperationsTestCase.escapeXML(0, (EObject)((InfrastructureRoot)target)));
                } else {
                    try {
                        System.out.println();
                        System.out.println("Fail Snippet");
                        CDAValidationTest.saveTestSnippet((EObject)target, System.out);
                        System.out.println();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.validateExpectFail((EObject)target, diagnostician, map);
                if (gotDiagnostic) continue;
                gotDiagnostic = true;
                for (Diagnostic d : diagnostician.getChildren()) {
                    String message = d.getMessage();
                    xmlSnippetsBuffer.append("<diagnostic>");
                    message = StringEscapeUtils.escapeHtml((String)message);
                    message = message.replace(System.getProperty("line.separator"), "<br/>");
                    xmlSnippetsBuffer.append(message);
                    xmlSnippetsBuffer.append("</diagnostic>");
                }
            }
        }

        private void runDependencies(StringBuffer xmlSnippetsBuffer) {
            boolean gotDiagnostic = false;
            for (FailTest failTest : this.failTests) {
                Object target = this.testObjectFactory.create();
                BasicDiagnostic diagnostician = Diagnostician.INSTANCE.createDefaultDiagnostic((EObject)target);
                failTest.updateToFail(target);
                this.setDependency(target);
                if (this.testLogDir != null) {
                    xmlSnippetsBuffer.append(OperationsTestCase.escapeXML(0, (EObject)((InfrastructureRoot)target)));
                } else {
                    try {
                        System.out.println();
                        System.out.println("Dependency Snippet");
                        CDAValidationTest.saveTestSnippet((EObject)target, System.out);
                        System.out.println();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.validateExpectPass((EObject)target, diagnostician, map);
                if (gotDiagnostic) continue;
                gotDiagnostic = true;
                for (Diagnostic d : diagnostician.getChildren()) {
                    String message = d.getMessage();
                    xmlSnippetsBuffer.append("<diagnostic>");
                    message = StringEscapeUtils.escapeHtml((String)message);
                    message = message.replace(System.getProperty("line.separator"), "<br/>");
                    xmlSnippetsBuffer.append(message);
                    xmlSnippetsBuffer.append("</diagnostic>");
                }
            }
        }

        private void runPasses(StringBuffer xmlSnippetsBuffer) {
            for (PassTest passTest : this.passTests) {
                Object target = this.testObjectFactory.create();
                BasicDiagnostic diagnostician = Diagnostician.INSTANCE.createDefaultDiagnostic((EObject)target);
                passTest.updateToPass(target);
                if (this.testLogDir != null) {
                    xmlSnippetsBuffer.append(OperationsTestCase.escapeXML(2, (EObject)((InfrastructureRoot)target)));
                } else {
                    try {
                        System.out.println();
                        System.out.println("Pass Snippet");
                        CDAValidationTest.saveTestSnippet((EObject)target, System.out);
                        System.out.println();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.validateExpectPass((EObject)target, diagnostician, map);
            }
        }

        private void appendToBuffer(StringBuffer xmlSnippetsBuffer, String startTag, String contents, String endTag) {
            if (this.testLogDir != null) {
                xmlSnippetsBuffer.append(startTag);
                contents = StringEscapeUtils.escapeHtml((String)contents);
                contents = contents.replace(System.getProperty("line.separator"), "<br/>");
                xmlSnippetsBuffer.append(contents);
                xmlSnippetsBuffer.append(endTag);
            } else {
                System.out.println();
                System.out.println(startTag);
                System.out.println(contents);
                System.out.println(endTag);
                System.out.println();
            }
        }

        protected EObject getObjectToSerialze() {
            return null;
        }

        @Override
        public void doTest(EObject objectToTest, BasicDiagnostic diagnostician, Map<Object, Object> map) {
            StringBuffer xmlSnippetsBuffer;
            block43: {
                xmlSnippetsBuffer = new StringBuffer();
                try {
                    EObject objectToSerialize;
                    EObject objectToSerialize2;
                    this.appendToBuffer(xmlSnippetsBuffer, "<ocl>", this.ocl, "</ocl>");
                    if (!this.skipFailsTest) {
                        if (!this.failTests.isEmpty()) {
                            this.runFails(xmlSnippetsBuffer);
                        } else {
                            this.updateToFail(objectToTest);
                            EObject eObject = objectToSerialize2 = this.getObjectToSerialze() != null ? this.getObjectToSerialze() : objectToTest;
                            if (this.testLogDir != null) {
                                xmlSnippetsBuffer.append(OperationsTestCase.escapeXML(0, objectToSerialize2));
                            } else {
                                try {
                                    System.out.println();
                                    System.out.println("Fail Snippet");
                                    CDAValidationTest.saveTestSnippet(objectToSerialize2, System.out);
                                    System.out.println();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            this.validateExpectFail(objectToTest, diagnostician, map);
                            for (Diagnostic d : diagnostician.getChildren()) {
                                String message = d.getMessage();
                                this.appendToBuffer(xmlSnippetsBuffer, "<diagnostic>", message, "</diagnostic>");
                            }
                        }
                    } else if (this.testLogDir != null) {
                        xmlSnippetsBuffer.append(OperationsTestCase.generateSkipMessage(0, "Skip Fail Test"));
                    } else {
                        System.out.println();
                        System.out.println("Skipped Fail Test");
                        System.out.println();
                    }
                    if (!this.skipPassTest) {
                        if (!this.passTests.isEmpty()) {
                            this.runPasses(xmlSnippetsBuffer);
                        } else {
                            this.updateToPass(objectToTest);
                            EObject eObject = objectToSerialize2 = this.getObjectToSerialze() != null ? this.getObjectToSerialze() : objectToTest;
                            if (this.testLogDir != null) {
                                xmlSnippetsBuffer.append(OperationsTestCase.escapeXML(2, objectToSerialize2));
                            } else {
                                try {
                                    System.out.println();
                                    System.out.println("Pass Snippet");
                                    CDAValidationTest.saveTestSnippet(objectToSerialize2, System.out);
                                    System.out.println();
                                }
                                catch (Exception d) {
                                    // empty catch block
                                }
                            }
                            this.validateExpectPass(objectToTest, diagnostician, map);
                        }
                    } else if (this.testLogDir != null) {
                        xmlSnippetsBuffer.append(OperationsTestCase.generateSkipMessage(0, "Skip Pass Test"));
                    } else {
                        System.out.println();
                        System.out.println("Skipped Pass Test");
                        System.out.println();
                    }
                    if (!this.skipNullFlavorTest) {
                        EObject nullFlavorTest = (EObject)this.testObjectFactory.create();
                        this.updateToFail(nullFlavorTest);
                        this.updateNullFlavor(nullFlavorTest);
                        EObject eObject = objectToSerialize = this.getObjectToSerialze() != null ? this.getObjectToSerialze() : nullFlavorTest;
                        if (this.testLogDir != null) {
                            xmlSnippetsBuffer.append(OperationsTestCase.escapeXML(2, objectToSerialize));
                        } else {
                            try {
                                System.out.println();
                                System.out.println("Null Flavor Snippet");
                                CDAValidationTest.saveTestSnippet(objectToSerialize, System.out);
                                System.out.println();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        this.validateExpectPass(nullFlavorTest, diagnostician, map);
                    } else if (this.testLogDir != null) {
                        xmlSnippetsBuffer.append(OperationsTestCase.generateSkipMessage(0, "Skip Pass Test"));
                    } else {
                        System.out.println();
                        System.out.println("Skipped Null Flavor Test");
                        System.out.println();
                    }
                    if (!this.checkDependency || this.skipFailsTest) break block43;
                    if (!this.failTests.isEmpty()) {
                        this.runDependencies(xmlSnippetsBuffer);
                        break block43;
                    }
                    EObject dependencyTest = (EObject)this.testObjectFactory.create();
                    this.updateToFail(dependencyTest);
                    this.setDependency(dependencyTest);
                    EObject eObject = objectToSerialize = this.getObjectToSerialze() != null ? this.getObjectToSerialze() : dependencyTest;
                    if (this.testLogDir != null) {
                        xmlSnippetsBuffer.append(OperationsTestCase.escapeXML(0, objectToSerialize));
                    } else {
                        try {
                            System.out.println();
                            System.out.println("Dependency Snippet");
                            CDAValidationTest.saveTestSnippet(objectToSerialize, System.out);
                            System.out.println();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.validateExpectPass(dependencyTest, diagnostician, map);
                    for (Diagnostic d : diagnostician.getChildren()) {
                        String message = d.getMessage();
                        this.appendToBuffer(xmlSnippetsBuffer, "<diagnostic>", message, "</diagnostic>");
                    }
                }
                catch (Throwable throwable) {
                    try {
                        String testName = String.format("%stest%s", String.valueOf(StringUtils.split((String)this.getClass().getName(), (String)"$")[0]) + ".", String.valueOf(this.getTestTargetDescription().substring(0, 1).toUpperCase()) + this.getTestTargetDescription().substring(1));
                        if (this.testLogDir != null) {
                            String logFileName = String.format("%s/test%s", this.testLogDir, String.valueOf(this.getTestTargetDescription().substring(0, 1).toUpperCase()) + this.getTestTargetDescription().substring(1) + ".xml");
                            FileWriter fstream = new FileWriter(logFileName);
                            BufferedWriter out = new BufferedWriter(fstream);
                            out.flush();
                            out.write("<testresult name=\"" + testName + "\">" + xmlSnippetsBuffer.toString() + "</testresult>");
                            out.close();
                        }
                    }
                    catch (Exception e) {
                        System.err.println("Error: " + e.getMessage());
                    }
                    throw throwable;
                }
            }
            try {
                String testName = String.format("%stest%s", String.valueOf(StringUtils.split((String)this.getClass().getName(), (String)"$")[0]) + ".", String.valueOf(this.getTestTargetDescription().substring(0, 1).toUpperCase()) + this.getTestTargetDescription().substring(1));
                if (this.testLogDir != null) {
                    String logFileName = String.format("%s/test%s", this.testLogDir, String.valueOf(this.getTestTargetDescription().substring(0, 1).toUpperCase()) + this.getTestTargetDescription().substring(1) + ".xml");
                    FileWriter fstream = new FileWriter(logFileName);
                    BufferedWriter out = new BufferedWriter(fstream);
                    out.flush();
                    out.write("<testresult name=\"" + testName + "\">" + xmlSnippetsBuffer.toString() + "</testresult>");
                    out.close();
                }
            }
            catch (Exception e) {
                System.err.println("Error: " + e.getMessage());
            }
        }

        public void doValidationTest() {
            this.addFailTests();
            this.addPassTests();
            EObject objectToTest = (EObject)this.testObjectFactory.create();
            BasicDiagnostic diagnostician = Diagnostician.INSTANCE.createDefaultDiagnostic(objectToTest);
            this.doTest(objectToTest, diagnostician, map);
        }

        protected void updateToFail(ValidationTarget target) {
        }

        protected void updateToPass(ValidationTarget target) {
        }

        protected void setDependency(ValidationTarget target) {
        }

        private void setNullFlavor(Object target) {
            Class[] nullFlavorArgument = new Class[]{NullFlavor.class};
            try {
                Method initMethod = target.getClass().getMethod("setNullFlavor", nullFlavorArgument);
                if (initMethod != null) {
                    initMethod.invoke(target, NullFlavor.NA);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void setNullFlavors(EObject target, int level) {
            EClass eClass = target.eClass();
            for (EStructuralFeature cdaFeature : eClass.getEAllStructuralFeatures()) {
                if (!(cdaFeature instanceof EReference)) continue;
                EReference cdaReference = (EReference)cdaFeature;
                if (cdaReference.isMany()) {
                    EList eList = (EList)target.eGet((EStructuralFeature)cdaReference);
                    if (eList.isEmpty()) continue;
                    for (EObject eo : eList) {
                        this.setNullFlavor(eo);
                        this.setNullFlavors(eo, level++);
                    }
                    continue;
                }
                EObject eObject = (EObject)target.eGet((EStructuralFeature)cdaReference);
                if (eObject == null) continue;
                this.setNullFlavor(eObject);
                this.setNullFlavors(eObject, level++);
            }
        }

        protected void updateNullFlavor(ValidationTarget target) {
            this.setNullFlavor(target);
            this.setNullFlavors((EObject)target, 1);
        }

        public abstract class FailTest {
            public abstract void updateToFail(ValidationTarget var1);
        }

        public abstract class PassTest {
            public abstract void updateToPass(ValidationTarget var1);
        }
    }

    protected static abstract class TemplateIDValidationTest
    extends CDAValidationTestCase {
        private static final String TEMPLATE_ID_FEATURE_NAME = "templateId";
        private final String templateID;

        public TemplateIDValidationTest(String templateID) {
            super(TEMPLATE_ID_FEATURE_NAME);
            this.templateID = templateID;
        }

        @Override
        public void doTest(EObject objectToTest, BasicDiagnostic diagnostician, Map<Object, Object> map) {
            try {
                this.validateExpectFail(objectToTest, diagnostician, map);
                this.getTemplateIds(objectToTest).add((Object)THE_BAD_II);
                this.validateExpectFail(objectToTest, diagnostician, map);
                this.getTemplateIds(objectToTest).add((Object)this.createTheValidII());
                this.validateExpectPass(objectToTest, diagnostician, map);
            }
            catch (UnsupportedOperationException uoe) {
                Assert.fail((String)CDAValidationTest.createUnsupportedOperationFailureMessage(TEMPLATE_ID_FEATURE_NAME, uoe));
            }
        }

        private EList<II> getTemplateIds(EObject objectToTest) {
            return (EList)objectToTest.eGet(objectToTest.eClass().getEStructuralFeature(TEMPLATE_ID_FEATURE_NAME));
        }

        private II createTheValidII() {
            II retValue = DatatypesFactory.eINSTANCE.createII();
            retValue.setRoot(this.templateID);
            return retValue;
        }
    }

    public static interface TestObjectFactory<TestObject> {
        public TestObject create();
    }

    protected static abstract class UndefinedORValidationTestCase
    extends UndefinedValidationTestCase {
        public UndefinedORValidationTestCase(String validationTargetDescription, Set<String> eReferenceNames) {
            super(validationTargetDescription, eReferenceNames);
        }

        @Override
        protected void doTest(EObject objectToTest, BasicDiagnostic diagnostician, Map<Object, Object> map) {
            EReference eReference;
            this.validateExpectPass(objectToTest, diagnostician, map);
            for (String eReferenceName : this.getEReferenceNames()) {
                eReference = (EReference)objectToTest.eClass().getEStructuralFeature(eReferenceName);
                Assert.assertNotNull((String)this.createEReferenceNotFoundMessage(objectToTest, eReferenceName), (Object)eReference);
                objectToTest.eSet((EStructuralFeature)eReference, (Object)CDAFactory.eINSTANCE.create((EClass)eReference.getEType()));
            }
            this.validateExpectFail(objectToTest, diagnostician, map);
            for (String eReferenceName : this.getEReferenceNames()) {
                eReference = (EReference)objectToTest.eClass().getEStructuralFeature(eReferenceName);
                EObject temp = (EObject)objectToTest.eGet((EStructuralFeature)eReference);
                objectToTest.eUnset((EStructuralFeature)eReference);
                this.validateExpectPass(objectToTest, diagnostician, map);
                objectToTest.eSet((EStructuralFeature)eReference, (Object)temp);
            }
        }
    }

    protected static abstract class UndefinedValidationTestCase
    extends CDAValidationTestCase {
        private final Set<String> eReferenceNames;

        protected UndefinedValidationTestCase(String testTargetDescription, Set<String> eReferenceNames) {
            super(testTargetDescription);
            this.eReferenceNames = eReferenceNames;
        }

        protected Set<String> getEReferenceNames() {
            return this.eReferenceNames;
        }

        protected String createEReferenceNotFoundMessage(EObject objectToTest, String eReferenceName) {
            return "EReference \"" + eReferenceName + "\" not found in \"" + objectToTest.eClass().getName() + "\"";
        }
    }

    protected static abstract class UndefinedXORValidationTestCase
    extends UndefinedValidationTestCase {
        public UndefinedXORValidationTestCase(String validationTargetDescription, Set<String> eReferenceNames) {
            super(validationTargetDescription, eReferenceNames);
        }

        @Override
        protected void doTest(EObject objectToTest, BasicDiagnostic diagnostician, Map<Object, Object> map) {
            EReference eReference;
            this.validateExpectFail(objectToTest, diagnostician, map);
            for (String eReferenceName : this.getEReferenceNames()) {
                eReference = (EReference)objectToTest.eClass().getEStructuralFeature(eReferenceName);
                Assert.assertNotNull((String)this.createEReferenceNotFoundMessage(objectToTest, eReferenceName), (Object)eReference);
                objectToTest.eSet((EStructuralFeature)eReference, (Object)CDAFactory.eINSTANCE.create((EClass)eReference.getEType()));
            }
            this.validateExpectFail(objectToTest, diagnostician, map);
            for (String eReferenceName : this.getEReferenceNames()) {
                eReference = (EReference)objectToTest.eClass().getEStructuralFeature(eReferenceName);
                EObject temp = (EObject)objectToTest.eGet((EStructuralFeature)eReference);
                objectToTest.eUnset((EStructuralFeature)eReference);
                this.validateExpectPass(objectToTest, diagnostician, map);
                objectToTest.eSet((EStructuralFeature)eReference, (Object)temp);
            }
        }
    }
}

