/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.tests;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mdht.uml.cda.AssignedAuthor;
import org.eclipse.mdht.uml.cda.Author;
import org.eclipse.mdht.uml.cda.CDAFactory;
import org.eclipse.mdht.uml.cda.ClinicalDocument;
import org.eclipse.mdht.uml.cda.InfrastructureRootTypeId;
import org.eclipse.mdht.uml.cda.Organization;
import org.eclipse.mdht.uml.cda.Patient;
import org.eclipse.mdht.uml.cda.PatientRole;
import org.eclipse.mdht.uml.cda.Person;
import org.eclipse.mdht.uml.cda.RecordTarget;
import org.eclipse.mdht.uml.cda.util.CDAUtil;
import org.eclipse.mdht.uml.hl7.datatypes.CE;
import org.eclipse.mdht.uml.hl7.datatypes.DatatypesFactory;
import org.eclipse.mdht.uml.hl7.datatypes.II;
import org.eclipse.mdht.uml.hl7.datatypes.PN;
import org.eclipse.mdht.uml.hl7.datatypes.ST;
import org.eclipse.mdht.uml.hl7.datatypes.TS;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CDASerializationTest {
    private static final String TEMP_CDA_FILE_PREFIX = "CDADoc";
    private static final String TEMP_CDA_FILE_SUFFIX = "xml";
    ClinicalDocument doc = null;

    @Before
    public void createCDADocument() {
        this.doc = CDAFactory.eINSTANCE.createClinicalDocument();
        InfrastructureRootTypeId typeId = CDAFactory.eINSTANCE.createInfrastructureRootTypeId();
        typeId.setExtension("POCD_HD000040");
        this.doc.setTypeId(typeId);
        II id = DatatypesFactory.eINSTANCE.createII("2.16.840.1.113883.19.4", "c266");
        this.doc.setId(id);
        II templateId = DatatypesFactory.eINSTANCE.createII("2.16.840.1.113883.3.27.1776");
        this.doc.getTemplateIds().add((Object)templateId);
        CE code = DatatypesFactory.eINSTANCE.createCE("11488-4", "2.16.840.1.113883.6.1", "LOINC", "Consultation note");
        this.doc.setCode(code);
        ST title = DatatypesFactory.eINSTANCE.createST("Good Health Clinic Consultation Note");
        this.doc.setTitle(title);
        TS effectiveTime = DatatypesFactory.eINSTANCE.createTS("20000407");
        this.doc.setEffectiveTime(effectiveTime);
        CE confidentialityCode = DatatypesFactory.eINSTANCE.createCE("N", "2.16.840.1.113883.5.25");
        this.doc.setConfidentialityCode(confidentialityCode);
        RecordTarget recordTarget = CDAFactory.eINSTANCE.createRecordTarget();
        this.doc.getRecordTargets().add((Object)recordTarget);
        PatientRole patientRole = CDAFactory.eINSTANCE.createPatientRole();
        recordTarget.setPatientRole(patientRole);
        Patient patient = CDAFactory.eINSTANCE.createPatient();
        patientRole.setPatient(patient);
        PN name = DatatypesFactory.eINSTANCE.createPN();
        name.addGiven("Henry").addFamily("Levin").addSuffix("the 7th");
        patient.getNames().add((Object)name);
        CE administrativeGenderCode = DatatypesFactory.eINSTANCE.createCE("M", "2.16.840.1.113883.5.1");
        patient.setAdministrativeGenderCode(administrativeGenderCode);
        TS birthTime = DatatypesFactory.eINSTANCE.createTS("19320924");
        patient.setBirthTime(birthTime);
        Organization providerOrganization = CDAFactory.eINSTANCE.createOrganization();
        providerOrganization.getIds().add((Object)DatatypesFactory.eINSTANCE.createII("2.16.840.1.113883.19.5"));
        patientRole.setProviderOrganization(providerOrganization);
        Author author = CDAFactory.eINSTANCE.createAuthor();
        author.setTime(DatatypesFactory.eINSTANCE.createTS("2000040714"));
        this.doc.getAuthors().add((Object)author);
        AssignedAuthor assignedAuthor = CDAFactory.eINSTANCE.createAssignedAuthor();
        assignedAuthor.getIds().add((Object)DatatypesFactory.eINSTANCE.createII("2.16.840.1.113883.19.5", "KP00017"));
        author.setAssignedAuthor(assignedAuthor);
        Person assignedPerson = CDAFactory.eINSTANCE.createPerson();
        assignedAuthor.setAssignedPerson(assignedPerson);
        name = DatatypesFactory.eINSTANCE.createPN();
        name.addGiven("Bob").addFamily("Dolin").addSuffix("MD");
        assignedPerson.getNames().add((Object)name);
    }

    @Test
    public void serializeCDADocument() {
        try {
            File tempFile = File.createTempFile(TEMP_CDA_FILE_PREFIX, TEMP_CDA_FILE_SUFFIX);
            tempFile.deleteOnExit();
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tempFile));
            CDAUtil.save((ClinicalDocument)this.doc, (OutputStream)out);
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(tempFile));
            ClinicalDocument clinicalDocument = CDAUtil.load((InputStream)in);
            Assert.assertNotNull((Object)clinicalDocument);
            Assert.assertTrue((String)"The CDA that was serialized doesn't equal the CDA that was deserialized", (boolean)EcoreUtil.equals((EObject)this.doc, (EObject)clinicalDocument));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

