/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.common.ui.dialogs;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.mdht.uml.common.ui.dialogs.DialogLaunchUtil;
import org.eclipse.mdht.uml.common.ui.dialogs.SubclassEditorTreeViewer;
import org.eclipse.mdht.uml.common.ui.dialogs.SubclassEditorViewContentProvider;
import org.eclipse.mdht.uml.common.ui.dialogs.SubclassEditorViewLabelProvider;
import org.eclipse.mdht.uml.common.ui.dialogs.ViewerPane;
import org.eclipse.mdht.uml.common.ui.internal.Activator;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;

public class SubclassEditorDialog
extends SelectionStatusDialog {
    private Label messageLabel;
    private CheckboxTreeViewer fViewer;
    private SubclassEditorViewLabelProvider fLabelProvider;
    private SubclassEditorViewContentProvider fContentProvider;
    private ISelectionStatusValidator fValidator = null;
    private ViewerComparator fComparator;
    private IStatus fCurrStatus = new Status(0, "org.eclipse.ui", 0, "", null);
    private List fFilters;
    private Class subclass;
    private boolean fIsEmpty;
    private int fWidth = 60;
    private int fHeight = 18;
    private boolean fContainerMode;
    private boolean fModifyMode = false;
    private Object[] fExpandedElements;
    private static final String ICONS_PATH = "/icons/full";

    public SubclassEditorDialog(Shell parent, SubclassEditorViewLabelProvider labelProvider, SubclassEditorViewContentProvider contentProvider, Class input) {
        super(parent);
        this.fLabelProvider = labelProvider;
        this.fContentProvider = contentProvider;
        this.setResult(new ArrayList(0));
        this.setStatusLineAboveButtons(true);
        this.fContainerMode = true;
        this.fExpandedElements = null;
        int shellStyle = this.getShellStyle();
        this.setShellStyle(shellStyle | 0x400 | 0x10);
        this.setTitle("Subclass Editor");
        this.setMessage(null);
        this.setContainerMode(true);
        this.setSize(60, 18);
        this.setInput(input);
    }

    public void setContainerMode(boolean containerMode) {
        this.fContainerMode = containerMode;
    }

    public boolean isModifyMode() {
        return this.fModifyMode;
    }

    public void setModifyMode(boolean modifyMode) {
        this.fModifyMode = modifyMode;
    }

    public void setInitialSelection(Object selection) {
        this.setInitialSelections(new Object[]{selection});
    }

    public void setComparator(ViewerComparator comparator) {
        this.fComparator = comparator;
    }

    public void addFilter(ViewerFilter filter) {
        if (this.fFilters == null) {
            this.fFilters = new ArrayList(4);
        }
        this.fFilters.add(filter);
    }

    public void setValidator(ISelectionStatusValidator validator) {
        this.fValidator = validator;
    }

    public void setInput(Class input) {
        this.subclass = input;
        ArrayList structuralProperties = new ArrayList();
        this.setInitialElementSelections(structuralProperties);
    }

    public void setExpandedElements(Object[] elements) {
        this.fExpandedElements = elements;
    }

    public void setSize(int width, int height) {
        this.fWidth = width;
        this.fHeight = height;
    }

    protected void updateOKStatus() {
        if (!this.fIsEmpty) {
            if (this.fValidator != null) {
                this.fCurrStatus = this.fValidator.validate(this.fViewer.getCheckedElements());
                this.updateStatus(this.fCurrStatus);
            } else if (!this.fCurrStatus.isOK()) {
                this.fCurrStatus = new Status(0, "org.eclipse.ui", 0, "", null);
            }
        }
        this.updateStatus(this.fCurrStatus);
    }

    public int open() {
        this.fIsEmpty = this.evaluateIfTreeEmpty(this.subclass);
        super.open();
        return this.getReturnCode();
    }

    private void access$superCreate() {
        super.create();
    }

    protected void cancelPressed() {
        this.setResult(null);
        super.cancelPressed();
    }

    protected void computeResult() {
        this.setResult(Arrays.asList(this.fViewer.getCheckedElements()));
    }

    public void create() {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                SubclassEditorDialog.this.access$superCreate();
                SubclassEditorDialog.this.fViewer.setCheckedElements(SubclassEditorDialog.this.getInitialElementSelections().toArray());
                if (SubclassEditorDialog.this.fViewer instanceof SubclassEditorTreeViewer) {
                    ((SubclassEditorTreeViewer)SubclassEditorDialog.this.fViewer).setDoneInitialSelections(true);
                }
                if (SubclassEditorDialog.this.fExpandedElements != null) {
                    SubclassEditorDialog.this.fViewer.setExpandedElements(SubclassEditorDialog.this.fExpandedElements);
                }
                SubclassEditorDialog.this.updateOKStatus();
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.messageLabel = this.createMessageArea(composite);
        CheckboxTreeViewer treeViewer = this.createTreeViewer(composite);
        Composite buttonComposite = this.createSelectionButtons(composite);
        GridData data = new GridData(1808);
        data.widthHint = this.convertWidthInCharsToPixels(this.fWidth);
        data.heightHint = this.convertHeightInCharsToPixels(this.fHeight);
        Tree treeWidget = treeViewer.getTree();
        treeWidget.setLayoutData((Object)data);
        treeWidget.setFont(parent.getFont());
        if (this.fIsEmpty) {
            this.messageLabel.setEnabled(false);
            treeWidget.setEnabled(false);
            buttonComposite.setEnabled(false);
        }
        return composite;
    }

    public void setMessage(String text) {
        super.setMessage(text);
        if (this.messageLabel != null) {
            this.messageLabel.setText(text);
            this.messageLabel.pack(true);
        }
    }

    protected void updateMessage() {
        StringBuffer message = new StringBuffer();
        message.append(this.subclass.getQualifiedName());
        boolean first = true;
        if (!this.subclass.getGenerals().isEmpty()) {
            message.append("\n   extends ");
            for (Classifier general : this.subclass.getGenerals()) {
                if (!first) {
                    message.append(", ");
                    first = false;
                }
                message.append(general.getQualifiedName());
            }
        }
        this.setMessage(message.toString());
    }

    protected CheckboxTreeViewer createTreeViewer(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        ViewerPane pane = new ViewerPane(parent, 0x800800);
        this.updateMessage();
        if (this.fContainerMode) {
            this.fViewer = new SubclassEditorTreeViewer((Composite)pane, 2048);
            if (this.isModifyMode()) {
                ((SubclassEditorTreeViewer)this.fViewer).setModifyMode(true);
            }
        } else {
            this.fViewer = new CheckboxTreeViewer(parent, 2048);
        }
        this.fViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        this.fViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                SubclassEditorDialog.this.updateOKStatus();
            }
        });
        this.fViewer.setComparator(this.fComparator);
        if (this.fFilters != null) {
            int i = 0;
            while (i != this.fFilters.size()) {
                this.fViewer.addFilter((ViewerFilter)this.fFilters.get(i));
                ++i;
            }
        }
        this.fViewer.setInput((Object)this.subclass);
        pane.setContent(this.fViewer.getControl());
        GridLayout paneLayout = new GridLayout();
        paneLayout.marginHeight = 0;
        paneLayout.marginWidth = 0;
        paneLayout.numColumns = 1;
        pane.setLayout((Layout)paneLayout);
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(55);
        gd.heightHint = this.convertHeightInCharsToPixels(15);
        pane.setLayoutData(gd);
        ToolBarManager manager = pane.getToolBarManager();
        manager.add((IAction)new SelectBaseTypeAction());
        manager.update(true);
        this.fViewer.getTree().setFocus();
        return this.fViewer;
    }

    protected CheckboxTreeViewer getTreeViewer() {
        return this.fViewer;
    }

    protected Composite createSelectionButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 131072);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setFont(composite.getFont());
        GridData data = new GridData(640);
        data.grabExcessHorizontalSpace = true;
        composite.setData((Object)data);
        return buttonComposite;
    }

    private boolean evaluateIfTreeEmpty(Object input) {
        Object[] elements = this.fContentProvider.getElements(input);
        if (elements.length > 0 && this.fFilters != null) {
            int i = 0;
            while (i < this.fFilters.size()) {
                ViewerFilter curr = (ViewerFilter)this.fFilters.get(i);
                elements = curr.filter((Viewer)this.fViewer, input, elements);
                ++i;
            }
        }
        return elements.length == 0;
    }

    protected Control createLinkControl(Composite composite) {
        Link link = new Link(composite, 64);
        link.setText("Link control message");
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        link.setToolTipText("Tool tip");
        GridData gridData = new GridData(4, 1, true, false);
        gridData.widthHint = this.convertWidthInCharsToPixels(40);
        link.setLayoutData((Object)gridData);
        return link;
    }

    public Class getSelectedClass() {
        return this.fContentProvider.getViewer().getSelectedClass();
    }

    private class OverrideFlatTreeAction
    extends Action {
        private boolean fToggle;

        public OverrideFlatTreeAction() {
            this.setToolTipText("Show superclass hierarchy");
            URL disableURL = Activator.getDefault().getBundle().getEntry("/icons/full/dlcl16/impl_co.gif");
            ImageDescriptor disableImage = ImageDescriptor.createFromURL((URL)disableURL);
            this.setDisabledImageDescriptor(disableImage);
            URL enableURL = Activator.getDefault().getBundle().getEntry("/icons/full/elcl16/impl_co.gif");
            ImageDescriptor enableImage = ImageDescriptor.createFromURL((URL)enableURL);
            this.setHoverImageDescriptor(enableImage);
            this.setImageDescriptor(enableImage);
            this.fToggle = this.getSubclassEditorContentProvider().isShowTypes();
            this.setChecked(this.fToggle);
        }

        private SubclassEditorViewContentProvider getSubclassEditorContentProvider() {
            return SubclassEditorDialog.this.fContentProvider;
        }

        public void run() {
            this.fToggle = !this.fToggle;
            this.setChecked(this.fToggle);
            this.getSubclassEditorContentProvider().setShowTypes(this.fToggle);
        }
    }

    private class SelectBaseTypeAction
    extends Action {
        public SelectBaseTypeAction() {
            super("Select Type...", 1);
            this.setToolTipText("Select base type");
            URL enableURL = Activator.getDefault().getBundle().getEntry("/icons/full/elcl16/Class.gif");
            ImageDescriptor enableImage = ImageDescriptor.createFromURL((URL)enableURL);
            this.setHoverImageDescriptor(enableImage);
            this.setImageDescriptor(enableImage);
        }

        public void run() {
            Class baseClass;
            if (SubclassEditorDialog.this.subclass instanceof Class && (baseClass = (Class)DialogLaunchUtil.chooseElement(new java.lang.Class[]{Class.class}, SubclassEditorDialog.this.subclass.eResource().getResourceSet(), SubclassEditorDialog.this.getShell())) != null) {
                SubclassEditorDialog.this.subclass.getGenerals().clear();
                SubclassEditorDialog.this.subclass.createGeneralization((Classifier)baseClass);
                SubclassEditorDialog.this.fViewer.refresh();
                SubclassEditorDialog.this.updateMessage();
            }
        }
    }
}

