/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.common.ui.dialogs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mdht.uml.common.ui.dialogs.SubclassEditorDialog;
import org.eclipse.mdht.uml.common.ui.dialogs.SubclassEditorViewContentProvider;
import org.eclipse.mdht.uml.common.ui.dialogs.SubclassEditorViewLabelProvider;
import org.eclipse.mdht.uml.common.util.UMLUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;

public class SubclassHandler {
    protected Shell shell;
    private Class subclass;
    protected SubclassEditorViewContentProvider contentProvider;
    protected SubclassEditorViewLabelProvider labelProvider;
    protected SubclassEditorDialog subclassDialog;

    public SubclassHandler(Shell shell, Class subclass, SubclassEditorViewContentProvider contentProvider, SubclassEditorViewLabelProvider labelProvider) {
        this.shell = shell;
        this.subclass = subclass;
        this.contentProvider = contentProvider;
        this.labelProvider = labelProvider;
    }

    public SubclassHandler(Shell shell, Class subclass) {
        this(shell, subclass, new SubclassEditorViewContentProvider(), new SubclassEditorViewLabelProvider());
    }

    public Class getSubclass() {
        return this.subclass;
    }

    public int openSubclassDialog() {
        this.subclassDialog = this.createSubclassDialog();
        int resultStatus = this.subclassDialog.open();
        if (this.subclassDialog.getReturnCode() == 0) {
            Object[] selectionArray = this.subclassDialog.getResult();
            this.populateSubclassWithSelection(selectionArray, this.getSubclass());
        }
        return resultStatus;
    }

    protected SubclassEditorDialog createSubclassDialog() {
        SubclassEditorDialog subclassDialog = new SubclassEditorDialog(this.shell, this.labelProvider, this.contentProvider, this.getSubclass());
        EList subclassAttributes = this.getSubclass().getOwnedAttributes();
        if (subclassAttributes != null && !subclassAttributes.isEmpty()) {
            subclassDialog.setInitialElementSelections((List)subclassAttributes);
            subclassDialog.setModifyMode(true);
        }
        return subclassDialog;
    }

    private void populateSubclassWithSelection(Object[] selectionArray, Class selectedClass) {
        if (selectionArray != null) {
            ArrayList<Property> selectedAttributes = new ArrayList<Property>();
            int i = 0;
            while (i < selectionArray.length) {
                if (selectionArray[i] instanceof Property) {
                    selectedAttributes.add((Property)selectionArray[i]);
                }
                ++i;
            }
            List<Property> cleanList = this.cleanUpSelection(selectedAttributes);
            for (Property property : cleanList) {
                Property clonedProperty = (Property)EcoreUtil.copy((EObject)property);
                clonedProperty.getOwnedComments().clear();
                selectedClass.getOwnedAttributes().add((Object)clonedProperty);
                UMLUtil.cloneStereotypes((Element)property, (Element)clonedProperty);
                clonedProperty.getRedefinedProperties().clear();
                clonedProperty.getSubsettedProperties().clear();
                if (property.getUpper() == 1) {
                    clonedProperty.getRedefinedProperties().add((Object)property);
                } else {
                    clonedProperty.getSubsettedProperties().add((Object)property);
                    clonedProperty.setName(this.getUniquePropertyName(selectedClass, property.getName()));
                }
                if (property.getAssociation() == null) continue;
                Association association = (Association)selectedClass.getNearestPackage().createOwnedType(null, UMLPackage.Literals.ASSOCIATION);
                association.getMemberEnds().add((Object)clonedProperty);
                Property ownedEnd = UMLFactory.eINSTANCE.createProperty();
                ownedEnd.setType((Type)selectedClass);
                association.getOwnedEnds().add((Object)ownedEnd);
                UMLUtil.cloneStereotypes((Element)property.getAssociation(), (Element)association);
            }
        }
    }

    private String getUniquePropertyName(Class owner, String name) {
        int seqNo = 1;
        String uniqueName = name;
        while (owner.getAttribute(uniqueName, null) != null) {
            uniqueName = String.valueOf(name) + String.valueOf(seqNo++);
        }
        while (owner.getInheritedMember(uniqueName) != null) {
            uniqueName = String.valueOf(name) + String.valueOf(seqNo++);
        }
        return uniqueName;
    }

    private List<Property> cleanUpSelection(List<Property> newSelectionList) {
        ArrayList<Property> newAttrList = new ArrayList<Property>(newSelectionList);
        ArrayList existingAttrList = new ArrayList(this.getSubclass().getOwnedAttributes());
        HashMap<String, Property> selectedAttrMap = new HashMap<String, Property>();
        for (Property newProp : newSelectionList) {
            selectedAttrMap.put(newProp.getName(), newProp);
        }
        for (Property existingProp : existingAttrList) {
            if (!selectedAttrMap.containsKey(existingProp.getName())) {
                if (existingProp.getAssociation() != null) {
                    existingProp.getAssociation().destroy();
                }
                this.getSubclass().getOwnedAttributes().remove((Object)existingProp);
                continue;
            }
            newAttrList.remove(selectedAttrMap.get(existingProp.getName()));
        }
        return newAttrList;
    }
}

