/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.common.ui.util;

import java.util.LinkedList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.TypedListener;

public class TreeCursor
extends Canvas {
    Tree tree;
    TreeItem row = null;
    TreeColumn column = null;
    TreeListener treeListener;
    Listener tableListener;
    Listener resizeListener;
    Listener disposeItemListener;
    Listener disposeColumnListener;
    Listener canvasListener;
    private boolean ignoreMouseDown = false;
    static final int BACKGROUND = 27;
    static final int FOREGROUND = 26;

    public TreeCursor(Tree parent, int style) {
        super((Composite)parent, style);
        ScrollBar vBar;
        this.tree = parent;
        this.setBackground(null);
        this.setForeground(null);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        TreeCursor.this.dispose(event);
                        break;
                    }
                    case 15: 
                    case 16: {
                        TreeCursor.this.redraw();
                        break;
                    }
                    case 1: {
                        TreeCursor.this.keyDown(event);
                        break;
                    }
                    case 9: {
                        TreeCursor.this.paint(event);
                        break;
                    }
                    case 31: {
                        TreeCursor.this.traverse(event);
                    }
                }
            }
        };
        int[] events = new int[]{12, 15, 16, 1, 9, 31};
        int i = 0;
        while (i < events.length) {
            this.addListener(events[i], listener);
            ++i;
        }
        this.treeListener = new TreeListener(){

            public void treeCollapsed(TreeEvent event) {
                if (event.item instanceof TreeItem) {
                    TreeCursor.this.ignoreMouseDown = true;
                    TreeCursor.this.setSelection((TreeItem)event.item, 0);
                    TreeCursor.this.tree.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            TreeCursor.this._resize();
                        }
                    });
                }
            }

            public void treeExpanded(TreeEvent event) {
                if (event.item instanceof TreeItem) {
                    TreeCursor.this.ignoreMouseDown = true;
                    TreeCursor.this.setSelection((TreeItem)event.item, 0);
                    TreeCursor.this.tree.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            TreeCursor.this._resize();
                        }
                    });
                }
            }
        };
        this.tree.addTreeListener(this.treeListener);
        this.tableListener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 3: {
                        if (TreeCursor.this.ignoreMouseDown) {
                            TreeCursor.this.ignoreMouseDown = false;
                            break;
                        }
                        TreeCursor.this.tableMouseDown(event);
                        break;
                    }
                    case 15: {
                        TreeCursor.this.tableFocusIn(event);
                    }
                }
            }
        };
        this.tree.addListener(15, this.tableListener);
        this.tree.addListener(3, this.tableListener);
        this.canvasListener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 8: {
                        TreeCursor.this.handleDoubleClick(event);
                    }
                }
            }
        };
        this.addListener(8, this.canvasListener);
        this.disposeItemListener = new Listener(){

            public void handleEvent(Event event) {
                TreeCursor.this.row = null;
                TreeCursor.this.column = null;
                TreeCursor.this._resize();
            }
        };
        this.disposeColumnListener = new Listener(){

            public void handleEvent(Event event) {
                TreeCursor.this.row = null;
                TreeCursor.this.column = null;
                TreeCursor.this._resize();
            }
        };
        this.resizeListener = new Listener(){

            public void handleEvent(Event event) {
                TreeCursor.this._resize();
            }
        };
        ScrollBar hBar = this.tree.getHorizontalBar();
        if (hBar != null) {
            hBar.addListener(13, this.resizeListener);
        }
        if ((vBar = this.tree.getVerticalBar()) != null) {
            vBar.addListener(13, this.resizeListener);
        }
    }

    void _resize() {
        if (this.row == null) {
            this.setBounds(-200, -200, 0, 0);
        } else {
            int columnIndex = this.column == null ? 0 : this.tree.indexOf(this.column);
            this.setBounds(this.row.getBounds(columnIndex));
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    void dispose(Event event) {
        ScrollBar vBar;
        ScrollBar hBar;
        this.tree.removeListener(15, this.tableListener);
        this.tree.removeListener(3, this.tableListener);
        if (this.column != null) {
            this.column.removeListener(12, this.disposeColumnListener);
            this.column.removeListener(10, this.resizeListener);
            this.column.removeListener(11, this.resizeListener);
            this.column = null;
        }
        if (this.row != null) {
            this.row.removeListener(12, this.disposeItemListener);
            this.row = null;
        }
        if ((hBar = this.tree.getHorizontalBar()) != null) {
            hBar.removeListener(13, this.resizeListener);
        }
        if ((vBar = this.tree.getVerticalBar()) != null) {
            vBar.removeListener(13, this.resizeListener);
        }
    }

    public int getColumn() {
        this.checkWidget();
        return this.column == null ? 0 : this.tree.indexOf(this.column);
    }

    private TreeItem getNextSibling(TreeItem item) {
        TreeItem sibling = null;
        Tree parent = item.getParentItem() == null ? this.tree : item.getParentItem();
        int rowIndex = this.getRowIndex(item);
        if (rowIndex < this.getParentItemCount(item) - 1) {
            sibling = parent instanceof Tree ? parent.getItem(++rowIndex) : ((TreeItem)parent).getItem(++rowIndex);
        }
        return sibling;
    }

    private int getParentItemCount(TreeItem item) {
        int count = 0;
        if (item != null) {
            count = item.getParentItem() == null ? this.tree.getItemCount() : item.getParentItem().getItemCount();
        }
        return count;
    }

    private TreeItem getPreviousSibling(TreeItem item) {
        TreeItem sibling = null;
        Tree parent = item.getParentItem() == null ? this.tree : item.getParentItem();
        int rowIndex = this.getRowIndex(item);
        if (rowIndex > 0) {
            sibling = parent instanceof Tree ? parent.getItem(--rowIndex) : ((TreeItem)parent).getItem(--rowIndex);
        }
        return sibling;
    }

    public TreeItem getRow() {
        this.checkWidget();
        return this.row;
    }

    private int getRowIndex(TreeItem item) {
        int index = -1;
        if (item != null) {
            index = item.getParentItem() == null ? this.tree.indexOf(item) : item.getParentItem().indexOf(item);
        }
        return index;
    }

    public TreePath getTreePath(TreeItem item) {
        LinkedList<Object> segments = new LinkedList<Object>();
        while (item != null) {
            Object segment = item.getData();
            Assert.isNotNull((Object)segment);
            segments.addFirst(segment);
            item = item.getParentItem();
        }
        return new TreePath(segments.toArray());
    }

    public void handleDoubleClick(Event event) {
    }

    void keyDown(Event event) {
        if (this.row == null) {
            return;
        }
        switch (event.character) {
            case '\r': {
                this.notifyListeners(14, new Event());
                return;
            }
        }
        int rowIndex = this.getRowIndex(this.row);
        int columnIndex = this.column == null ? 0 : this.tree.indexOf(this.column);
        switch (event.keyCode) {
            case 0x1000001: {
                TreeItem previousRow = this.getPreviousSibling(this.row);
                if (previousRow == null && this.row.getParentItem() != null) {
                    previousRow = this.row.getParentItem();
                } else if (previousRow != null && previousRow.getExpanded() && previousRow.getItemCount() > 0) {
                    previousRow = previousRow.getItem(previousRow.getItemCount() - 1);
                }
                if (previousRow == null) break;
                this.setRowColumn(previousRow, this.column, true);
                break;
            }
            case 0x1000002: {
                TreeItem nextRow = this.getNextSibling(this.row);
                if (this.row.getExpanded() && this.row.getItemCount() > 0) {
                    this.setRowColumn(this.row.getItem(0), this.column, true);
                    break;
                }
                if (nextRow != null) {
                    this.setRowColumn(nextRow, this.column, true);
                    break;
                }
                if (this.row.getParentItem() == null) break;
                TreeItem parentItem = this.row.getParentItem();
                TreeItem nextParent = null;
                while (parentItem != null && nextParent == null) {
                    nextParent = this.getNextSibling(parentItem);
                    parentItem = parentItem.getParentItem();
                }
                if (nextParent == null) break;
                this.setRowColumn(nextParent, this.column, true);
                break;
            }
            case 0x1000003: 
            case 0x1000004: {
                int columnCount = this.tree.getColumnCount();
                if (columnCount == 0) break;
                int[] order = this.tree.getColumnOrder();
                int index = 0;
                while (index < order.length) {
                    if (order[index] == columnIndex) break;
                    ++index;
                }
                if (index == order.length) {
                    index = 0;
                }
                int leadKey = (this.getStyle() & 0x4000000) != 0 ? 0x1000004 : 0x1000003;
                int newColumnIndex = columnIndex;
                newColumnIndex = event.keyCode == leadKey ? order[Math.max(0, index - 1)] : order[Math.min(columnCount - 1, index + 1)];
                TreeColumn col = newColumnIndex == -1 || this.tree.getColumnCount() == 0 ? null : this.tree.getColumn(newColumnIndex);
                this.setRowColumn(this.row, col, true);
                break;
            }
            case 0x1000007: {
                this.setRowColumn(this.tree.getItem(0), this.tree.getColumn(0), true);
                break;
            }
            case 0x1000008: {
                break;
            }
            case 0x1000005: {
                int index = this.tree.indexOf(this.tree.getTopItem());
                if (index != rowIndex) break;
                Rectangle rect = this.tree.getClientArea();
                TreeItem item = this.tree.getItem(index);
                Rectangle itemRect = item.getBounds(0);
                rect.height -= itemRect.y;
                int height = this.tree.getItemHeight();
                int page = Math.max(1, rect.height / height);
                index = Math.max(0, index - page + 1);
                break;
            }
            case 0x1000006: {
                int index = this.tree.indexOf(this.tree.getTopItem());
                Rectangle rect = this.tree.getClientArea();
                TreeItem item = this.tree.getItem(index);
                Rectangle itemRect = item.getBounds(0);
                rect.height -= itemRect.y;
                int height = this.tree.getItemHeight();
                int page = Math.max(1, rect.height / height);
                int end = this.tree.getItemCount() - 1;
                index = Math.min(end, index + page - 1);
                if (index != rowIndex) break;
                index = Math.min(end, index + page - 1);
            }
        }
    }

    void paint(Event event) {
        String text;
        if (this.row == null) {
            return;
        }
        int columnIndex = this.column == null ? 0 : this.tree.indexOf(this.column);
        GC gc = event.gc;
        Display display = this.getDisplay();
        gc.setBackground(this.getBackground());
        gc.setForeground(this.getForeground());
        gc.fillRectangle(event.x, event.y, event.width, event.height);
        int x = 0;
        Point size = this.getSize();
        Image image = this.row.getImage(columnIndex);
        if (image != null) {
            Rectangle imageSize = image.getBounds();
            int imageY = (size.y - imageSize.height) / 2;
            gc.drawImage(image, x, imageY);
            x += imageSize.width;
        }
        if ((text = this.row.getText(columnIndex)) != "") {
            int alignmnent;
            Rectangle bounds = this.row.getBounds(columnIndex);
            Point extent = gc.stringExtent(text);
            String platform = SWT.getPlatform();
            if ("win32".equals(platform)) {
                if (this.tree.getColumnCount() == 0 || columnIndex == 0) {
                    x += 2;
                } else {
                    alignmnent = this.column.getAlignment();
                    switch (alignmnent) {
                        case 16384: {
                            x += 6;
                            break;
                        }
                        case 131072: {
                            x = bounds.width - extent.x - 6;
                            break;
                        }
                        case 0x1000000: {
                            x += (bounds.width - x - extent.x) / 2;
                        }
                    }
                }
            } else if (this.tree.getColumnCount() == 0) {
                x += 5;
            } else {
                alignmnent = this.column.getAlignment();
                switch (alignmnent) {
                    case 16384: {
                        x += 5;
                        break;
                    }
                    case 131072: {
                        x = bounds.width - extent.x - 2;
                        break;
                    }
                    case 0x1000000: {
                        x += (bounds.width - x - extent.x) / 2 + 2;
                    }
                }
            }
            int textY = (size.y - extent.y) / 2;
            gc.drawString(text, x, textY);
        }
        if (this.isFocusControl()) {
            gc.setBackground(display.getSystemColor(2));
            gc.setForeground(display.getSystemColor(1));
            gc.drawFocus(0, 0, size.x, size.y);
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.removeListener(13, (SWTEventListener)listener);
        this.removeListener(14, (SWTEventListener)listener);
    }

    public void setBackground(Color color) {
        if (color == null) {
            color = this.getDisplay().getSystemColor(27);
        }
        super.setBackground(color);
        this.redraw();
    }

    public void setForeground(Color color) {
        if (color == null) {
            color = this.getDisplay().getSystemColor(26);
        }
        super.setForeground(color);
        this.redraw();
    }

    void setRowColumn(TreeItem row, TreeColumn column, boolean notify) {
        if (this.row == row && this.column == column) {
            return;
        }
        if (this.row != null && this.row != row) {
            this.row.removeListener(12, this.disposeItemListener);
            this.row = null;
        }
        if (this.column != null && this.column != column) {
            this.column.removeListener(12, this.disposeColumnListener);
            this.column.removeListener(10, this.resizeListener);
            this.column.removeListener(11, this.resizeListener);
            this.column = null;
        }
        if (row != null) {
            if (this.row != row) {
                this.row = row;
                row.addListener(12, this.disposeItemListener);
                this.tree.showItem(row);
            }
            if (this.column != column && column != null) {
                this.column = column;
                column.addListener(12, this.disposeColumnListener);
                column.addListener(10, this.resizeListener);
                column.addListener(11, this.resizeListener);
                this.tree.showColumn(column);
            }
            int columnIndex = column == null ? 0 : this.tree.indexOf(column);
            this.setBounds(row.getBounds(columnIndex));
            this.redraw();
            if (notify) {
                Event event = new Event();
                event.item = row;
                this.notifyListeners(13, event);
            }
        }
    }

    public void setSelection(TreeItem row, int column) {
        int maxColumnIndex;
        this.checkWidget();
        int columnCount = this.tree.getColumnCount();
        int n = maxColumnIndex = columnCount == 0 ? 0 : columnCount - 1;
        if (row == null || row.isDisposed() || column < 0 || column > maxColumnIndex) {
            SWT.error((int)5);
        }
        TreeColumn col = column == -1 || this.tree.getColumnCount() == 0 ? null : this.tree.getColumn(column);
        this.setRowColumn(row, col, true);
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if (visible) {
            this._resize();
        }
        super.setVisible(visible);
    }

    void tableFocusIn(Event event) {
        if (this.isDisposed()) {
            return;
        }
        if (this.isVisible()) {
            this.setFocus();
        }
    }

    void tableMouseDown(Event event) {
        if (this.isDisposed() || !this.isVisible()) {
            return;
        }
        Point pt = new Point(event.x, event.y);
        int lineWidth = this.tree.getLinesVisible() ? this.tree.getGridLineWidth() : 0;
        TreeItem item = this.tree.getItem(pt);
        if ((this.tree.getStyle() & 0x10000) != 0) {
            if (item == null) {
                return;
            }
        } else {
            int start = item != null ? this.tree.indexOf(item) : this.tree.indexOf(this.tree.getTopItem());
            int end = this.tree.getItemCount();
            Rectangle clientRect = this.tree.getClientArea();
            int i = start;
            while (i < end) {
                TreeItem nextItem = this.tree.getItem(i);
                Rectangle rect = nextItem.getBounds(0);
                if (pt.y >= rect.y && pt.y < rect.y + rect.height + lineWidth) {
                    item = nextItem;
                    break;
                }
                if (rect.y > clientRect.y + clientRect.height) {
                    return;
                }
                ++i;
            }
            if (item == null) {
                return;
            }
        }
        TreeColumn newColumn = null;
        int columnCount = this.tree.getColumnCount();
        if (columnCount > 0) {
            int i = 0;
            while (i < columnCount) {
                Rectangle rect = item.getBounds(i);
                rect.width += lineWidth;
                rect.height += lineWidth;
                if (rect.contains(pt)) {
                    newColumn = this.tree.getColumn(i);
                    break;
                }
                ++i;
            }
            if (newColumn == null) {
                newColumn = this.tree.getColumn(0);
            }
        }
        this.setRowColumn(item, newColumn, true);
    }

    void traverse(Event event) {
        switch (event.detail) {
            case 4: 
            case 32: 
            case 64: {
                event.doit = false;
                return;
            }
        }
        event.doit = true;
    }
}

