/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.common.modelfilter;

import org.eclipse.mdht.uml.common.modelfilter.IModelFilterProvider;
import org.eclipse.mdht.uml.common.modelfilter.ModelFilterRegistry;
import org.eclipse.mdht.uml.common.util.NamedElementUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;

public class ModelFilterUtil {
    protected static final String FILTER_HIDE = "hide";
    protected static final String FILTER_SHOW = "show";
    protected static final String FILTER_COLLAPSE = "collapse";

    public static boolean isHidden(NamedElement namedElement) {
        if (ModelFilterUtil.isHiddenByUser(namedElement)) {
            return true;
        }
        if (ModelFilterUtil.isShownByUser(namedElement)) {
            return false;
        }
        if (ModelFilterUtil.isCollapsedByUser(namedElement)) {
            return false;
        }
        return false;
    }

    protected static boolean isHiddenByUser(NamedElement namedElement) {
        String value = NamedElementUtil.getPropertyValue(namedElement, "filter");
        return FILTER_HIDE.equals(value);
    }

    protected static boolean isHiddenByFilterProvider(NamedElement namedElement) {
        IModelFilterProvider provider = ModelFilterRegistry.INSTANCE.getModelFilterProvider((Element)namedElement);
        if (provider != null) {
            return provider.isHidden(namedElement);
        }
        return false;
    }

    public static boolean isShown(NamedElement namedElement) {
        return ModelFilterUtil.isShownByUser(namedElement);
    }

    protected static boolean isShownByUser(NamedElement namedElement) {
        String value = NamedElementUtil.getPropertyValue(namedElement, "filter");
        return FILTER_SHOW.equals(value);
    }

    public static boolean isCollapsed(NamedElement namedElement) {
        return ModelFilterUtil.isCollapsedByUser(namedElement) ? true : ModelFilterUtil.isCollapsedByFilterProvider(namedElement);
    }

    protected static boolean isCollapsedByUser(NamedElement namedElement) {
        String value = NamedElementUtil.getPropertyValue(namedElement, "filter");
        return FILTER_COLLAPSE.equals(value);
    }

    protected static boolean isCollapsedByFilterProvider(NamedElement namedElement) {
        IModelFilterProvider provider = ModelFilterRegistry.INSTANCE.getModelFilterProvider((Element)namedElement);
        if (provider != null) {
            return provider.isCollapsed(namedElement);
        }
        return false;
    }

    public static boolean hasFilterState(NamedElement namedElement) {
        String value = NamedElementUtil.getPropertyValue(namedElement, "filter");
        return value != null;
    }

    public static String removeFilterState(NamedElement namedElement) {
        return NamedElementUtil.removePropertyValue(namedElement, "filter");
    }

    public static void setAsHidden(NamedElement namedElement) {
        ModelFilterUtil.setFilterProperty(namedElement, FILTER_HIDE);
    }

    public static void setAsShown(NamedElement namedElement) {
        ModelFilterUtil.setFilterProperty(namedElement, FILTER_SHOW);
    }

    public static void setAsCollapsed(NamedElement namedElement) {
        ModelFilterUtil.setFilterProperty(namedElement, FILTER_COLLAPSE);
    }

    public static void setTypeReplacement(NamedElement namedElement, String qualifiedName) {
        ModelFilterUtil.setTypeProperty(namedElement, qualifiedName);
    }

    public static String getTypeReplacement(NamedElement namedElement) {
        return NamedElementUtil.getPropertyValue(namedElement, "type");
    }

    protected static void setFilterProperty(NamedElement namedElement, String filterState) {
        NamedElementUtil.setPropertyValue(namedElement, "filter", filterState);
    }

    protected static void setTypeProperty(NamedElement namedElement, String typeQName) {
        NamedElementUtil.setPropertyValue(namedElement, "type", typeQName);
    }
}

