/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.common.notation;

import org.eclipse.mdht.uml.common.util.NamedElementUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.NamedElement;

public class ClassNotationUtil {
    public static String getLabel(Class clazz) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(" ");
        buffer.append(clazz.getName());
        String modifiers = ClassNotationUtil.getModifiersAsString(clazz, false);
        if (!modifiers.equals("")) {
            buffer.append(" {");
            buffer.append(modifiers);
            buffer.append("}");
        }
        return buffer.toString();
    }

    public static String getCustomLabel(Class clazz, int style) {
        boolean multiLine;
        String modifiers;
        boolean showBrackets;
        StringBuffer buffer = new StringBuffer();
        if ((style & 2) != 0) {
            buffer.append(NamedElementUtil.getVisibilityAsSign((NamedElement)clazz));
        }
        if ((style & 8) != 0) {
            buffer.append(" ");
            buffer.append(clazz.getName());
        }
        boolean bl = showBrackets = buffer.length() > 0;
        if ((style & 0x80) != 0 && !(modifiers = ClassNotationUtil.getModifiersAsString(clazz, multiLine = (style & 0x100000) != 0)).equals("")) {
            if (multiLine) {
                buffer.append("\n");
            }
            buffer.append(showBrackets ? " {" : "");
            buffer.append(modifiers);
            buffer.append(showBrackets ? "}" : "");
        }
        return buffer.toString();
    }

    protected static String getModifiersAsString(Class clazz, boolean multiLine) {
        StringBuffer buffer = new StringBuffer();
        boolean needsComma = false;
        if (clazz.isAbstract()) {
            buffer.append("abstract");
            needsComma = true;
        }
        if (clazz.isLeaf()) {
            if (needsComma) {
                buffer.append(",");
            }
            buffer.append("leaf");
            needsComma = true;
        }
        if (clazz.isActive()) {
            if (needsComma) {
                buffer.append(",");
            }
            buffer.append("active");
            needsComma = true;
        }
        return buffer.toString();
    }
}

