/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.common.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mdht.uml.common.search.IElementFilter;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ModelSearch {
    private ModelSearch() {
    }

    private static boolean implementsInterface(Object object, java.lang.Class<?> anInterface) {
        java.lang.Class<?>[] interfaces = object.getClass().getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            if (interfaces[i] == anInterface) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static List<EObject> findStereotypeApplications(ResourceSet resourceSet, Stereotype stereotype) {
        ArrayList<EObject> elementList = new ArrayList<EObject>();
        for (Resource resource : resourceSet.getResources()) {
            String uri = resource.getURI().toString();
            if (uri.equals("pathmap://UML_METAMODELS/UML.metamodel.uml") || uri.equals("pathmap://UML_METAMODELS/Ecore.metamodel.uml")) continue;
            elementList.addAll(ModelSearch.findStereotypeApplications(resource, stereotype));
        }
        return elementList;
    }

    public static List<EObject> findStereotypeApplications(Resource resource, Stereotype stereotype) {
        ArrayList<EObject> elementList = new ArrayList<EObject>();
        for (EObject eObject : resource.getContents()) {
            if (!stereotype.equals(UMLUtil.getStereotype((EObject)eObject))) continue;
            elementList.add(eObject);
        }
        return elementList;
    }

    public static List<Element> findAllOf(ResourceSet resourceSet, IElementFilter filter) {
        ArrayList<Element> elementList = new ArrayList<Element>();
        TreeIterator iterator = EcoreUtil.getAllProperContents((Collection)resourceSet.getResources(), (boolean)true);
        while (iterator != null && iterator.hasNext()) {
            Object element = iterator.next();
            if (Resource.class.isInstance(element)) continue;
            if (ProfileApplication.class.isInstance(element)) {
                iterator.prune();
                continue;
            }
            if (Profile.class.isInstance(element)) {
                iterator.prune();
                continue;
            }
            if (EAnnotation.class.isInstance(element)) {
                iterator.prune();
                continue;
            }
            if (Package.class.isInstance(element)) {
                if ("pathmap://UML_METAMODELS/UML.metamodel.uml".equals(((Package)element).eResource().getURI().toString())) {
                    iterator.prune();
                    continue;
                }
                if (!"pathmap://UML_METAMODELS/Ecore.metamodel.uml".equals(((Package)element).eResource().getURI().toString())) continue;
                iterator.prune();
                continue;
            }
            if (element instanceof Element && filter.accept((Element)element)) {
                elementList.add((Element)element);
                continue;
            }
            if (Package.class.isInstance(element)) continue;
            iterator.prune();
        }
        return elementList;
    }

    public static List<Element> findAllOf(Package umlPackage, IElementFilter filter) {
        ArrayList<Element> elementList = new ArrayList<Element>();
        TreeIterator iterator = umlPackage.eAllContents();
        while (iterator != null && iterator.hasNext()) {
            EObject element = (EObject)iterator.next();
            if (element instanceof ElementImport) {
                if ("pathmap://UML_METAMODELS/UML.metamodel.uml".equals((element = ((ElementImport)element).getImportedElement()).eResource().getURI().toString())) {
                    continue;
                }
            } else if (element instanceof PackageImport) {
                Package importedPackage = ((PackageImport)element).getImportedPackage();
                if (importedPackage == null || importedPackage.eIsProxy() || "pathmap://UML_METAMODELS/UML.metamodel.uml".equals(importedPackage.eResource().getURI().toString())) continue;
                element = importedPackage;
                elementList.addAll(ModelSearch.findAllOf(importedPackage, filter));
            }
            if (element instanceof Element && filter.accept((Element)element)) {
                elementList.add((Element)element);
                continue;
            }
            if (Package.class.isInstance(element)) continue;
            iterator.prune();
        }
        return elementList;
    }

    public static List<Element> findAllOf(Package umlPackage, java.lang.Class<?> type) {
        ArrayList<Element> elementList = new ArrayList<Element>();
        TreeIterator iterator = umlPackage.eAllContents();
        while (iterator != null && iterator.hasNext()) {
            EObject element = (EObject)iterator.next();
            if (element instanceof ElementImport) {
                if (!"pathmap://UML_METAMODELS/UML.metamodel.uml".equals((element = ((ElementImport)element).getImportedElement()).eResource().getURI().toString())) {
                    elementList.add((Element)element);
                }
            } else if (element instanceof PackageImport) {
                Package importedPackage = ((PackageImport)element).getImportedPackage();
                if ("pathmap://UML_METAMODELS/UML.metamodel.uml".equals(importedPackage.eResource().getURI().toString())) continue;
                elementList.addAll(ModelSearch.findAllOf(importedPackage, type));
                continue;
            }
            if (element instanceof Element && ModelSearch.implementsInterface(element, type)) {
                elementList.add((Element)element);
                continue;
            }
            if (Package.class.isInstance(element)) continue;
            iterator.prune();
        }
        return elementList;
    }

    public static List<Element> findAllOf(Resource resource, java.lang.Class<?> type) {
        ArrayList<Element> elementList = new ArrayList<Element>();
        TreeIterator iterator = EcoreUtil.getAllContents((Resource)resource, (boolean)true);
        while (iterator != null && iterator.hasNext()) {
            EObject element = (EObject)iterator.next();
            if (type.isInstance(element) && element instanceof Element) {
                elementList.add((Element)element);
                continue;
            }
            if (Package.class.isInstance(element)) continue;
            iterator.prune();
        }
        return elementList;
    }

    public static List<Class> findUMLMetaclasses(ResourceSet resourceSet) {
        ArrayList<Class> classList = new ArrayList<Class>();
        Resource umlMetamodel = resourceSet.getResource(URI.createURI((String)"pathmap://UML_METAMODELS/UML.metamodel.uml"), true);
        if (umlMetamodel != null) {
            TreeIterator iterator = EcoreUtil.getAllProperContents((Resource)umlMetamodel, (boolean)true);
            while (iterator != null && iterator.hasNext()) {
                Object element = iterator.next();
                if (!(element instanceof Class)) continue;
                classList.add((Class)element);
            }
        }
        return classList;
    }

    public static List<Element> findAllOf(ResourceSet resourceSet, java.lang.Class<?> type) {
        ArrayList<Element> elementList = new ArrayList<Element>();
        TreeIterator iterator = EcoreUtil.getAllProperContents((Collection)resourceSet.getResources(), (boolean)true);
        while (iterator != null && iterator.hasNext()) {
            Object element = iterator.next();
            if (Resource.class.isInstance(element)) continue;
            if (ProfileApplication.class.isInstance(element)) {
                iterator.prune();
                continue;
            }
            if (Profile.class.isInstance(element) && Stereotype.class != type) {
                iterator.prune();
                continue;
            }
            if (EAnnotation.class.isInstance(element)) {
                iterator.prune();
                continue;
            }
            if (Package.class.isInstance(element)) {
                if ("pathmap://UML_METAMODELS/UML.metamodel.uml".equals(((Package)element).eResource().getURI().toString())) {
                    iterator.prune();
                    continue;
                }
                if ("pathmap://UML_METAMODELS/Ecore.metamodel.uml".equals(((Package)element).eResource().getURI().toString())) {
                    iterator.prune();
                    continue;
                }
            }
            if (type.isInstance(element) && element instanceof Element) {
                elementList.add((Element)element);
                continue;
            }
            if (Package.class.isInstance(element)) continue;
            iterator.prune();
        }
        return elementList;
    }
}

