/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.core.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.BasicEObjectImpl;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.GenericXMLResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLHelperImpl;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.ecore.xml.type.XMLTypeDocumentRoot;
import org.eclipse.mdht.uml.cda.CDAFactory;
import org.eclipse.mdht.uml.cda.core.profile.TextValue;
import org.eclipse.mdht.uml.cda.core.util.CDACommonUtils;
import org.eclipse.mdht.uml.cda.core.util.CDAModelUtil;
import org.eclipse.mdht.uml.cda.core.util.CDASampler;
import org.eclipse.mdht.uml.cda.core.util.ModelStatus;
import org.eclipse.mdht.uml.term.core.profile.CodeSystemConstraint;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;

public class ClinicalDocumentCreator {
    private static final String PLUGIN = "org.openhealthtools.mdht.uml.cda.core";
    private EPackage cda_ecore;
    private Map<Object, Property> initialized = new HashMap<Object, Property>();
    private EObject aClinicalDocument;
    private EClass ecoreClinicalDocument;
    private Class umlClinicalDocument;
    private String lastXML;
    private File lastFile;
    private Map<Classifier, Collection<Classifier>> specificsOf = new HashMap<Classifier, Collection<Classifier>>();
    private List<ModelStatus> statuses;
    private Collection<File> createdFiles = new HashSet<File>();
    private CDASampler sampler = new CDASampler();
    private boolean enableSampleData = false;
    private boolean enableSampleDataExpansion;

    public ClinicalDocumentCreator(Class umlClinicalDocument, ResourceSet resourceSet, List<ModelStatus> statuses) {
        this.umlClinicalDocument = umlClinicalDocument;
        this.statuses = statuses;
        this.cda_ecore = (EPackage)resourceSet.getEObject(URI.createURI((String)"pathmap://CDA_MODEL/cda.uml/../cda.ecore#/"), true);
        this.ecoreClinicalDocument = (EClass)this.cda_ecore.getEClassifier("ClinicalDocument");
        for (EClass es : this.ecoreClinicalDocument.getESuperTypes()) {
            if (!es.eIsProxy()) continue;
            this.ecoreClinicalDocument = null;
            this.cda_ecore = null;
            CDACommonUtils.addStatus(statuses, 1, PLUGIN, 1, "Pathmap to CDA .ecore files not resolved: " + ((BasicEObjectImpl)es).eProxyURI() + ". Will not use any CDA extension!", new EObject[0]);
            break;
        }
    }

    private void createClinicalDocument() {
        this.initialized.clear();
        this.aClinicalDocument = this.ecoreClinicalDocument != null ? EcoreUtil.create((EClass)this.ecoreClinicalDocument) : CDAFactory.eINSTANCE.createClinicalDocument();
    }

    protected void discardClinicalDocument() {
        this.aClinicalDocument = null;
    }

    public void flushClinicalDocument(File file) throws Exception {
        try {
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put("EXTENDED_META_DATA", ExtendedMetaData.INSTANCE);
            options.put("ENCODING", "UTF-8");
            String xml = XMLHelperImpl.saveString(options, Arrays.asList(this.aClinicalDocument), null, null);
            xml = xml.replace("\"datatypes:", "\"");
            xml = xml.replace("<cda:", "<");
            xml = xml.replace("</cda:", "</");
            xml = xml.replace("Extensions_3.0", "ext");
            int index = xml.indexOf("<ClinicalDocument");
            xml = String.valueOf(xml.substring(0, index)) + "<ClinicalDocument xmlns:ext=\"http://ns.electronichealth.net.au/Ci/Cda/Extensions/3.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"urn:hl7-org:v3\">" + xml.substring(xml.indexOf(">", index) + 1);
            xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + xml;
            file.getParentFile().mkdirs();
            this.writeFile(xml, file);
        }
        catch (Exception e) {
            CDACommonUtils.addStatus(this.statuses, 4, PLUGIN, 2, "Cannot serialize file " + file.getName(), e, new EObject[0]);
        }
        this.discardClinicalDocument();
    }

    public void writeFile(String xml, File file) throws IOException {
        CDACommonUtils.stringToFileIfGenerated(xml, file);
        if (!this.createdFiles.add(file)) {
            CDACommonUtils.addStatus(this.statuses, 4, PLUGIN, 11, "File name clash: this file is written more than once: " + file, new EObject[0]);
        }
        if (xml.equals(this.lastXML)) {
            System.err.println("Equal files:");
            System.err.println(this.lastFile);
            System.err.println(file);
        }
        this.lastFile = file;
        this.lastXML = xml;
    }

    public Object initializePath(Class clazz, Property mandatoryProperty, Property prohibitedProperty, Property diversifyProperty) {
        int count = this.statuses.size();
        this.createClinicalDocument();
        List<Property> propertyPath = CDACommonUtils.getPropertyPath(clazz);
        if (mandatoryProperty != null) {
            propertyPath.add(mandatoryProperty);
        }
        Object result = this.initialize(this.umlClinicalDocument, this.aClinicalDocument, propertyPath, new HashSet<Property>(Arrays.asList(prohibitedProperty)), Arrays.asList(diversifyProperty), null, null);
        if (mandatoryProperty != null) {
            if (this.getInitializedByProperty(result) == mandatoryProperty) {
                return result;
            }
        } else {
            if (this.getInitializedByClass(result) == clazz) {
                return result;
            }
            if (result == null && clazz == this.umlClinicalDocument) {
                return this.aClinicalDocument;
            }
        }
        if (count == this.statuses.size() && mandatoryProperty != null) {
            CDACommonUtils.addStatus(this.statuses, 2, PLUGIN, 6, String.valueOf(CDACommonUtils.getUmlContextDoubled(mandatoryProperty)) + " could not be initialized", new EObject[]{mandatoryProperty});
        }
        this.discardClinicalDocument();
        return null;
    }

    public EObject initializeSnippet(Class clazz, Collection<Property> mandatoryProperty) {
        this.createClinicalDocument();
        Classifier cdaChildClass = CDACommonUtils.getCDAType((Classifier)clazz);
        if (cdaChildClass == null) {
            CDACommonUtils.addStatus(this.statuses, 4, PLUGIN, 9, "Found no CDA base class for " + CDACommonUtils.getUmlContext(clazz), new EObject[]{clazz});
            return null;
        }
        EClass eClass = null;
        for (EPackage ePackage : CDACommonUtils.getAllContents(this.aClinicalDocument.eClass().eResource(), EPackage.class)) {
            if ("cda".equals(ePackage.getName()) != "cda".equals(cdaChildClass.getNearestPackage().getName())) continue;
            eClass = (EClass)ePackage.getEClassifier(cdaChildClass.getName());
        }
        if (eClass == null) {
            CDACommonUtils.addStatus(this.statuses, 4, PLUGIN, 9, "Found no Runtime class for " + CDACommonUtils.getUmlContext(clazz), new EObject[]{clazz});
            return null;
        }
        EObject eObject = EcoreUtil.create(eClass);
        this.initialize(clazz, eObject, mandatoryProperty, new HashSet<Property>(), new HashSet<Property>(), null, null);
        return eObject;
    }

    public EObject initializeSnippet(Class clazz) {
        return this.initializeSnippet(clazz, Collections.emptyList());
    }

    public void initialize(Collection<Property> mandatoryProperty) {
        this.createClinicalDocument();
        this.initialize(this.umlClinicalDocument, this.aClinicalDocument, mandatoryProperty, new HashSet<Property>(), Collections.emptyList(), null, null);
    }

    protected Object initialize(Class parentClass, EObject parent, Collection<Property> mandatoryProperty, Set<Property> prohibitedProperty, Collection<Property> diversifyProperty, Property parentProperty, Object result) {
        Property oldProperty;
        if (this.enableSampleData) {
            this.sampler.mergeSampleXML(parentClass, parent);
        }
        if ((oldProperty = this.initialized.put(parent, parentProperty)) != null) {
            CDACommonUtils.addStatus(this.statuses, 2, PLUGIN, 5, "Double-initialization by " + CDACommonUtils.getUmlContext(parentProperty) + " and " + CDACommonUtils.getUmlContext(oldProperty), new EObject[]{parentProperty, oldProperty});
        }
        String templateId = CDACommonUtils.getTemplateId(parentClass);
        Property templateIdProperty = this.getTemplateIdProperty(parentClass);
        if (templateId != null && templateIdProperty != null && !prohibitedProperty.contains(templateIdProperty)) {
            EStructuralFeature templateIdFeatureFeature = parent.eClass().getEStructuralFeature("templateId");
            EObject templateIdInstance = EcoreUtil.create((EClass)((EClass)templateIdFeatureFeature.getEType()));
            templateIdInstance = this.setOrAdd(parent, templateIdFeatureFeature, templateIdInstance);
            this.setOrAdd(templateIdInstance, "root", String.valueOf(templateId) + (diversifyProperty.contains(templateIdProperty) ? "TYPO" : ""));
            String extension = CDAModelUtil.getTemplateVersion(parentClass);
            if (extension != null) {
                this.setOrAdd(templateIdInstance, "extension", extension);
            }
            this.initialized.put(templateIdInstance, templateIdProperty);
            if (mandatoryProperty.contains(templateIdProperty) && (parentProperty == null || mandatoryProperty.contains(parentProperty))) {
                result = templateIdInstance;
            }
        }
        for (Property property : CDACommonUtils.allAttributes(parentClass)) {
            if (property == templateIdProperty && templateId != null) continue;
            result = this.initializeProperty(property, parent, mandatoryProperty, prohibitedProperty, diversifyProperty, parentClass, result);
        }
        return result;
    }

    public Object repopulateProperty(Property property, EObject propertyInstance) {
        this.initialized.remove(propertyInstance);
        EObject parent = propertyInstance.eContainer();
        Class parentClass = (Class)this.getInitializedByClass(parent);
        return this.initializeProperty(property, parent, Arrays.asList(property), new HashSet<Property>(), Collections.emptyList(), parentClass, null);
    }

    /*
     * WARNING - void declaration
     */
    protected Object initializeProperty(Property property, EObject parent, Collection<Property> mandatoryProperty, Set<Property> prohibitedProperty, Collection<Property> diversifyProperty, Class parentClass, Object result) {
        EStructuralFeature feature = this.getStructuralFeature(parent, property);
        if (feature == null || prohibitedProperty.contains(property)) {
            return result;
        }
        boolean structuralRequired = property.getLower() > 0 || CDACommonUtils.getPropertyForTypeCheck(parentClass) == property || CDACommonUtils.getPropertyForCodeOrClasscodeCheck(parentClass) == property || diversifyProperty.contains(property) || mandatoryProperty.contains(property);
        this.sampler.descentProperty(property);
        while (this.sampler.hasData() && (this.enableSampleDataExpansion || feature.getEType() instanceof EDataType) || structuralRequired) {
            block50: {
                try {
                    EStructuralFeature mixedFeature;
                    Object mixed;
                    CodeSystemConstraint codeSystemConstraint;
                    if (feature.getEType() instanceof EDataType) {
                        EDataType eDataType = (EDataType)feature.getEType();
                        Object def = null;
                        String dv = this.sampler.getSample();
                        if (dv == null) {
                            dv = CDACommonUtils.getDefault(property);
                        }
                        try {
                            if (parent.eGet(feature) instanceof FeatureMap) {
                                def = this.getValueForFeaturemap(feature, dv);
                            } else if (dv != null) {
                                def = EcoreUtil.createFromString((EDataType)eDataType, (String)dv);
                            }
                        }
                        catch (Exception exception) {
                            CDACommonUtils.addStatus(this.statuses, 4, PLUGIN, 7, "Cannot parse default value \"" + dv + "\" for property " + CDACommonUtils.getUmlContextDoubled(property) + " as " + (eDataType.getName() != null ? eDataType.getName() : eDataType), exception, new EObject[]{property});
                        }
                        Object var13_16 = null;
                        if (!diversifyProperty.contains(property) && def != null) {
                            try {
                                feature.setUnsettable(true);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            Object object = this.setOrAdd(parent, feature, def);
                        } else if (eDataType instanceof EEnum) {
                            EEnum eEnum = (EEnum)eDataType;
                            EEnumLiteral literal = eEnum.getEEnumLiteral(eEnum.getELiterals().size() - 1);
                            if (def != null && literal == def) {
                                literal = eEnum.getEEnumLiteral(eEnum.getELiterals().size() - 2);
                            }
                            if (literal != null) {
                                Enumerator enumerator = this.setOrAdd(parent, feature, literal.getInstance());
                            }
                        } else if (eDataType.getInstanceClass() != null && eDataType.getInstanceClass().isAssignableFrom(String.class)) {
                            String string = this.setOrAdd(parent, feature, def instanceof String ? String.valueOf((String)def) + "TYPO" : "testString");
                        } else if (eDataType.getInstanceClass() != null && eDataType.getInstanceClass().isAssignableFrom(Boolean.class)) {
                            Boolean bl = this.setOrAdd(parent, feature, Boolean.valueOf(def instanceof Boolean ? !((Boolean)def).booleanValue() : true));
                        } else if (eDataType.getInstanceClass() != null && eDataType.getInstanceClass().isAssignableFrom(BigInteger.class)) {
                            BigInteger bigInteger = this.setOrAdd(parent, feature, def instanceof BigInteger ? ((BigInteger)def).add(BigInteger.valueOf(1L)) : BigInteger.valueOf(999L));
                        } else {
                            CDACommonUtils.addStatus(this.statuses, 4, PLUGIN, 8, "Cannot initialize value for property " + CDACommonUtils.getUmlContextDoubled(property) + " for datatype " + (eDataType.getName() != null ? eDataType.getName() : eDataType), new EObject[]{property});
                        }
                        if (mandatoryProperty.contains(property)) {
                            void var13_22;
                            this.initialized.put(var13_22, property);
                            result = var13_22;
                        }
                        break block50;
                    }
                    if (!(property.getType() instanceof Class)) {
                        Object object = result;
                        return object;
                    }
                    Class childClass = (Class)property.getType();
                    EObject child = null;
                    Object oldValue = parent.eGet(feature);
                    for (Object e : oldValue instanceof List ? (List<Object>)oldValue : Arrays.asList(oldValue)) {
                        if (this.getInitializedByClass(e) != childClass || property.getUpper() != 1) continue;
                        child = (EObject)e;
                    }
                    if (child == null) {
                        void var13_29;
                        void var13_27;
                        EClassifier eClass1;
                        EClass eClass = (EClass)feature.getEType();
                        Classifier cdaChildClass = CDACommonUtils.getCDAType((Classifier)childClass);
                        if (cdaChildClass == null) {
                            CDACommonUtils.addStatus(this.statuses, 4, PLUGIN, 9, "Found no CDA base class for " + CDACommonUtils.getUmlContext(childClass), new EObject[]{childClass});
                            Object object = result;
                            return object;
                        }
                        if (!cdaChildClass.getName().equals(eClass.getName()) && (eClass1 = eClass.getEPackage().getEClassifier(cdaChildClass.getName())) != null) {
                            EClass eClass2 = (EClass)eClass1;
                        }
                        if (diversifyProperty.contains(property) || var13_27.isAbstract()) {
                            EClassifier otherClass = null;
                            for (Classifier classifier : this.getSpecific(childClass)) {
                                if (!classifier.isAbstract() && (classifier.getName() == null || !classifier.getName().equals(childClass.getName())) && (otherClass = var13_27.getEPackage().getEClassifier(classifier.getName())) != null) break;
                            }
                            if (otherClass != null) {
                                EClass eClass3 = (EClass)otherClass;
                            } else {
                                CDACommonUtils.addStatus(this.statuses, 4, PLUGIN, 10, "Cannot find a different class other than " + var13_27.getName(), new EObject[]{property});
                                Object object = result;
                                return object;
                            }
                        }
                        if (property.getLower() == 0) {
                            int level = 0;
                            EObject aParent = parent;
                            while (aParent != null) {
                                if (aParent.eClass() == var13_29 || level >= 10) {
                                    Object object = result;
                                    return object;
                                }
                                aParent = aParent.eContainer();
                                ++level;
                            }
                        }
                        child = EcoreUtil.create((EClass)var13_29);
                        child = this.setOrAdd(parent, feature, child);
                    }
                    if ((codeSystemConstraint = CDACommonUtils.getCodeSystemConstraint(property)) != null && codeSystemConstraint.getCode() != null) {
                        this.setOrAdd(child, "code", String.valueOf(codeSystemConstraint.getCode()) + (diversifyProperty.contains(property) ? "TYPO" : ""));
                    }
                    if (codeSystemConstraint != null && CDACommonUtils.getCodeSystem(codeSystemConstraint) != null) {
                        this.setOrAdd(child, "codeSystem", CDACommonUtils.getCodeSystem(codeSystemConstraint));
                    }
                    if (codeSystemConstraint != null && codeSystemConstraint.getDisplayName() != null) {
                        this.setOrAdd(child, "displayName", codeSystemConstraint.getDisplayName());
                    }
                    Object object = mixed = (mixedFeature = child.eClass().getEStructuralFeature("mixed")) != null ? child.eGet(mixedFeature) : null;
                    if (mixed instanceof FeatureMap) {
                        String text = this.sampler.getSample();
                        if (text == null) {
                            TextValue textValue = CDACommonUtils.getTextValue(property);
                            String string = text = textValue != null ? textValue.getValue() : null;
                        }
                        if (text != null) {
                            text = String.valueOf(text.trim()) + (diversifyProperty.contains(property) ? "TYPO" : "");
                            FeatureMapUtil.addText((FeatureMap)((FeatureMap)mixed), (String)text);
                        }
                    }
                    if (mandatoryProperty.contains(property)) {
                        result = child;
                    }
                    result = this.initialize(childClass, child, mandatoryProperty, prohibitedProperty, diversifyProperty, property, result);
                }
                finally {
                    this.sampler.ascentProperty();
                }
            }
            structuralRequired = false;
            this.sampler.descentProperty(property);
        }
        this.sampler.ascentProperty();
        return result;
    }

    private Object getValueForFeaturemap(EStructuralFeature feature, String string) throws IOException {
        if ("any".equals(feature.getName())) {
            GenericXMLResourceFactoryImpl factory = new GenericXMLResourceFactoryImpl();
            XMLResource resource = (XMLResource)factory.createResource(null);
            resource.load((InputStream)new URIConverter.ReadableInputStream("<text>" + string + "</text>"), null);
            XMLTypeDocumentRoot root = (XMLTypeDocumentRoot)resource.getContents().get(0);
            AnyType value = (AnyType)root.getMixed().getValue(0);
            return value.getMixed();
        }
        return string;
    }

    public Type getInitializedByClass(Object object) {
        if (object == this.aClinicalDocument) {
            return this.umlClinicalDocument;
        }
        Property parentProperty = this.initialized.get(object);
        if (parentProperty != null && object != null) {
            return parentProperty.getType();
        }
        return null;
    }

    public Property getInitializedByProperty(Object object) {
        return this.initialized.get(object);
    }

    private Collection<Classifier> getSpecific(Class clazz) {
        if (this.specificsOf.isEmpty()) {
            TreeIterator it = EcoreUtil.getAllContents((ResourceSet)clazz.eResource().getResourceSet(), (boolean)false);
            while (it.hasNext()) {
                Object eObject = it.next();
                if (!(eObject instanceof Classifier)) continue;
                Classifier specific = (Classifier)eObject;
                for (Generalization generalization : specific.getGeneralizations()) {
                    Classifier general = generalization.getGeneral();
                    Collection<Classifier> specifics = this.specificsOf.get(general);
                    if (specifics == null) {
                        specifics = new ArrayList<Classifier>();
                        this.specificsOf.put(general, specifics);
                    }
                    if (specifics.contains(specific)) continue;
                    specifics.add(specific);
                }
            }
        }
        if (this.specificsOf.get(clazz) != null) {
            return this.specificsOf.get(clazz);
        }
        return Collections.emptyList();
    }

    private EStructuralFeature getStructuralFeature(EObject parent, Property property) {
        Property cdaProperty = CDACommonUtils.getCDAProperty(property);
        if (cdaProperty != null && parent != null) {
            EStructuralFeature feature = parent.eClass().getEStructuralFeature(cdaProperty.getName());
            if (feature == null) {
                CDACommonUtils.addStatus(this.statuses, 2, PLUGIN, 4, "No Java/Ecore mapping for property " + CDACommonUtils.getUmlContextDoubled(property) + ")", new EObject[]{property});
            }
            return feature;
        }
        return null;
    }

    private <T> T setOrAdd(EObject eObject, EStructuralFeature feature, T value) {
        try {
            if (eObject.eGet(feature) instanceof FeatureMap && value instanceof String) {
                FeatureMap featureMap = (FeatureMap)eObject.eGet(feature);
                FeatureMapUtil.addText((FeatureMap)featureMap, (String)((String)value));
            } else if (feature.isMany()) {
                List list = (List)eObject.eGet(feature);
                if (value instanceof List) {
                    list.addAll((List)value);
                } else {
                    list.add(value);
                }
            } else {
                eObject.eSet(feature, value);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return value;
    }

    private <T> T setOrAdd(EObject eObject, String featureName, T value) {
        return this.setOrAdd(eObject, eObject.eClass().getEStructuralFeature(featureName), value);
    }

    public void forgetLastFileContent() {
        this.lastXML = null;
    }

    public Property getTemplateIdProperty(Class clazz) {
        Property result = CDACommonUtils.findAttribute(clazz, "templateId");
        if (result != null) {
            result = CDACommonUtils.getCDAProperty(result);
        }
        return result;
    }

    public EPackage getCdaEcore() {
        return this.cda_ecore;
    }

    public static String withoutDigits(String name) {
        while (!"".equals(name) && Character.isDigit(name.charAt(name.length() - 1))) {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }

    public String toXMLString(EObject eObject, Class clazz) {
        return this.toXMLString(eObject, clazz, new HashMap<String, Object>());
    }

    public String toXMLString(EObject eObject, Class clazz, Map<String, Object> options) {
        String xml;
        options.put("EXTENDED_META_DATA", ExtendedMetaData.INSTANCE);
        options.put("ENCODING", "UTF-8");
        try {
            xml = XMLHelperImpl.saveString(options, Arrays.asList(eObject), null, null);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return null;
        }
        xml = xml.replace("\"datatypes:", "\"");
        xml = xml.replace("<cda:", "<");
        xml = xml.replace("</cda:", "</");
        xml = xml.replace("Extensions_3.0", "ext");
        xml = xml.replace("xmlns:cda=\"urn:hl7-org:v3\"", "xmlns=\"urn:hl7-org:v3\"");
        String eName = eObject.eClass().getName();
        if (!"ClinicalDocument".equals(eName)) {
            Property cdaProperty;
            String rootTag = ClinicalDocumentCreator.withoutDigits(String.valueOf(eName.substring(0, 1).toLowerCase()) + eName.substring(1));
            if (eObject.eContainmentFeature() != null) {
                rootTag = eObject.eContainingFeature().getName();
            } else if (clazz != null && CDACommonUtils.getOverallPropertyReference(clazz) != null && (cdaProperty = CDACommonUtils.getCDAProperty(CDACommonUtils.getOverallPropertyReference(clazz))) != null) {
                rootTag = cdaProperty.getName();
            }
            xml = xml.replace("<" + eName, "<" + rootTag);
            xml = xml.replace("</" + eName, "</" + rootTag);
            xml = xml.replace(" xmlns=\"urn:hl7-org:v3\"", "");
            xml = xml.replace(" xmi:version=\"2.0\"", "");
            xml = xml.replace(" xmlns:xmi=\"http://www.omg.org/XMI\"", "");
            xml = xml.replace(" xmlns:datatypes=\"http://www.openhealthtools.org/mdht/uml/hl7/datatypes\"", "");
            xml = xml.replace(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"", "");
        } else {
            xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + xml;
        }
        return xml;
    }

    public void enableSampleData(boolean value) {
        this.enableSampleData = value;
    }

    public void enableSampleDataExpansion(boolean value) {
        this.enableSampleDataExpansion = value;
    }

    public EObject getClinicalDocument() {
        return this.aClinicalDocument;
    }

    public CDASampler getSampler() {
        return this.sampler;
    }
}

