/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.transform;

import java.util.Collection;
import java.util.Map;
import org.eclipse.mdht.uml.common.util.UMLUtil;
import org.eclipse.mdht.uml.transform.IBaseModelReflection;
import org.eclipse.mdht.uml.transform.TransformerOptions;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.util.UMLSwitch;

public abstract class AbstractTransform
extends UMLSwitch<Object> {
    protected TransformerOptions transformerOptions;
    protected final IBaseModelReflection baseModelReflection;

    public AbstractTransform(TransformerOptions options, IBaseModelReflection baseModelReflection) {
        this.transformerOptions = options;
        this.baseModelReflection = baseModelReflection;
    }

    public void removeModelElement(Element element) {
        if (element != null && !this.isRemoved(element)) {
            this.transformerOptions.getDeletedElementList().add(element);
        }
    }

    public boolean isRemoved(Element element) {
        return this.transformerOptions.getDeletedElementList().contains(element);
    }

    protected <C extends Classifier> C getBaseClass(C userClass) {
        return this.baseModelReflection.getBaseClass(userClass);
    }

    protected Package getBaseModel(Classifier userClass) {
        Classifier baseClass;
        Package result = this.baseModelReflection.getBaseModel((Element)userClass);
        if (result == null && (baseClass = this.getBaseClass(userClass)) != null) {
            result = UMLUtil.getTopPackage((Element)baseClass);
        }
        return result;
    }

    protected boolean isBaseModel(Element userElement, Element baseElement) {
        return this.baseModelReflection.isBaseModelElement(userElement, baseElement);
    }

    protected boolean isDatatypesModelElement(Element context, Element base) {
        return this.baseModelReflection.isDatatypesModelElement(context, base);
    }

    protected Property getBaseProperty(Property templateProperty) {
        return this.baseModelReflection.getBaseProperty((Classifier)templateProperty.getOwner(), templateProperty);
    }

    protected <C extends Classifier> C getBaseDatatype(C umlDatatype, Element context) {
        C result = this.baseModelReflection.getBaseDatatype(umlDatatype);
        if (result != null && (result == umlDatatype || context != null && !UMLUtil.isSameModel(umlDatatype, (Element)context))) {
            result = null;
        }
        return result;
    }

    protected boolean isDatatypesModel(Element userElement, Element baseElement) {
        return this.baseModelReflection.isDatatypesModelElement(userElement, baseElement);
    }

    protected Property getInheritedProperty(Property templateProperty) {
        if (templateProperty.getClass_() == null) {
            return null;
        }
        return UMLUtil.getInheritedProperty((Property)templateProperty);
    }

    public static String normalizeCodeName(String name) {
        String[] parts;
        String result = "";
        String[] stringArray = parts = name.split(" ");
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            result = String.valueOf(result) + part.substring(0, 1).toUpperCase() + part.substring(1);
            ++n2;
        }
        result = UML2Util.getValidJavaIdentifier((String)result);
        return result;
    }

    public static String pluralize(String name) {
        if (name.endsWith("y")) {
            return String.valueOf(name.substring(0, name.length() - 1)) + "ies";
        }
        if (name.endsWith("ia")) {
            return name;
        }
        return String.valueOf(name) + "s";
    }

    public static String capitalize(String name) {
        return String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1);
    }

    public static <E, C extends Collection<? super E>> C addIfNotNull(E element, C collection) {
        if (element != null) {
            collection.add(element);
        }
        return collection;
    }

    public static <K, V, M extends Map<? super K, ? super V>> M putIfNotNull(K key, V element, M map) {
        if (element != null) {
            map.put(key, element);
        }
        return map;
    }
}

