/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.transform.core.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mdht.transform.core.IPhase;
import org.eclipse.mdht.transform.core.IRule;
import org.eclipse.mdht.transform.core.IRuleFragment;
import org.eclipse.mdht.transform.core.ITransformContext;
import org.eclipse.mdht.transform.core.ITransformMonitor;
import org.eclipse.mdht.transform.core.ITransformation;
import org.eclipse.mdht.transform.core.RuleKind;
import org.eclipse.mdht.transform.core.TransformationException;
import org.eclipse.mdht.transform.core.impl.AbstractTransformComponent;

public abstract class AbstractRule
extends AbstractTransformComponent<RuleKind>
implements IRule {
    private IPhase phase;
    private List<IRuleFragment> fragments;
    private int firstAfter;

    public AbstractRule(String id, RuleKind kind, String label) {
        this(null, id, kind, label);
    }

    public AbstractRule(IPhase phase, String id, RuleKind kind, String label) {
        super(id, kind, label);
        this.phase = phase;
    }

    @Override
    public void initialize(ITransformContext ctx) throws TransformationException {
        super.initialize(ctx);
        if (this.fragments != null) {
            for (IRuleFragment next : this.fragments) {
                next.initialize(ctx);
            }
        }
    }

    @Override
    public IPhase getPhase() {
        return this.phase;
    }

    @Override
    public ITransformation getTransformation() {
        return this.getPhase().getTransformation();
    }

    @Override
    public List<? extends IRuleFragment> getRuleFragments() {
        return this.fragments == null ? Collections.emptyList() : Collections.unmodifiableList(this.fragments);
    }

    @Override
    public IRuleFragment getFragment(String id) {
        IRuleFragment result = null;
        if (this.fragments != null) {
            for (IRuleFragment next : this.fragments) {
                if (!next.getID().equals(id)) continue;
                result = next;
                break;
            }
        }
        return result;
    }

    @Override
    public List<? extends IRuleFragment> getBefores() {
        return this.fragments == null ? Collections.emptyList() : Collections.unmodifiableList(this.fragments.subList(0, this.firstAfter));
    }

    @Override
    public List<? extends IRuleFragment> getAfters() {
        return this.fragments == null ? Collections.emptyList() : Collections.unmodifiableList(this.fragments.subList(this.firstAfter, this.fragments.size()));
    }

    @Override
    public Object apply(EObject input, ITransformMonitor monitor) throws TransformationException {
        Object result = null;
        if (this.fragments == null) {
            result = this.doApply(input, monitor);
        } else {
            for (IRuleFragment iRuleFragment : this.getBefores()) {
                Object output = iRuleFragment.apply(input, input, monitor);
                if (!(output instanceof EObject)) continue;
                input = (EObject)output;
            }
            result = this.doApply(input, monitor);
            for (IRuleFragment iRuleFragment : this.getAfters()) {
                result = iRuleFragment.apply(input, result, monitor);
            }
        }
        return result;
    }

    protected abstract Object doApply(EObject var1, ITransformMonitor var2) throws TransformationException;

    public void setPhase(IPhase phase) {
        if (this.phase != null) {
            throw new IllegalStateException("Rule already has a phase.");
        }
        this.phase = phase;
    }

    public void addFragment(IRuleFragment fragment) {
        boolean add = true;
        if (this.fragments == null) {
            this.fragments = new ArrayList<IRuleFragment>(3);
        } else {
            ListIterator<IRuleFragment> iter = this.fragments.listIterator();
            while (iter.hasNext()) {
                IRuleFragment cur = iter.next();
                if (!fragment.getID().equals(cur.getID())) continue;
                if (fragment.getKind() != cur.getKind()) {
                    throw new IllegalArgumentException("Cannot replace a rule fragment with a fragment of a different kind.");
                }
                iter.set(fragment);
                add = false;
                break;
            }
        }
        if (add) {
            switch (fragment.getKind()) {
                case BEFORE: {
                    this.fragments.add(0, fragment);
                    ++this.firstAfter;
                    break;
                }
                case AFTER: {
                    this.fragments.add(fragment);
                }
            }
        }
    }
}

