/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.transform.core.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mdht.transform.core.IPhase;
import org.eclipse.mdht.transform.core.ITransformMonitor;
import org.eclipse.mdht.transform.core.ITransformation;
import org.eclipse.mdht.transform.core.NullTransformMonitor;
import org.eclipse.mdht.transform.core.PhaseKind;
import org.eclipse.mdht.transform.core.TransformationException;
import org.eclipse.mdht.transform.core.impl.AbortTransformationException;
import org.eclipse.mdht.transform.core.impl.Phase;
import org.eclipse.mdht.transform.core.impl.TransformContext;

public class Transformation
implements ITransformation {
    private final List<IPhase> phases = new ArrayList<IPhase>(4);
    private boolean initialized;

    public Transformation() {
        this.phases.add(new Phase(this, "org.eclipse.mdht.transform.core.init", PhaseKind.INITIALIZATION, "Initialize"));
        this.phases.add(new Phase(this, "org.eclipse.mdht.transform.core.fini", PhaseKind.FINALIZATION, "Clean up"));
    }

    @Override
    public void initialize() throws TransformationException {
        if (!this.initialized) {
            this.initialized = true;
            TransformContext ctx = new TransformContext();
            for (IPhase next : this.phases) {
                try {
                    next.initialize(ctx);
                }
                catch (AbortTransformationException e) {
                    throw new TransformationException(String.format("Transformation aborted in initialization of phase '%s' (%s).", next.getLabel(), next.getID()), e);
                }
                catch (RuntimeException e) {
                    throw new TransformationException(String.format("Uncaught exception in initialization of phase '%s' (%s).", next.getLabel(), next.getID()), e);
                }
            }
        }
    }

    @Override
    public List<? extends IPhase> getPhases() {
        return Collections.unmodifiableList(this.phases);
    }

    @Override
    public IPhase getPhase(String id) {
        IPhase result = null;
        for (IPhase next : this.phases) {
            if (!next.getID().equals(id)) continue;
            result = next;
            break;
        }
        return result;
    }

    @Override
    public IPhase getInitialization() {
        IPhase result = null;
        for (IPhase next : this.phases) {
            if (next.getKind() != PhaseKind.INITIALIZATION) continue;
            result = next;
            break;
        }
        return result;
    }

    @Override
    public IPhase getFinalization() {
        IPhase result = null;
        for (IPhase next : this.phases) {
            if (next.getKind() != PhaseKind.FINALIZATION) continue;
            result = next;
            break;
        }
        return result;
    }

    @Override
    public void execute(EObject input, ITransformMonitor monitor) throws TransformationException {
        this.execute(Collections.singleton(input), monitor);
    }

    @Override
    public void execute(Iterable<? extends EObject> inputs, ITransformMonitor monitor) throws TransformationException {
        if (monitor == null) {
            monitor = new NullTransformMonitor();
        }
        this.initialize();
        for (IPhase next : this.phases) {
            try {
                next.execute(inputs, monitor);
            }
            catch (AbortTransformationException e) {
                throw new TransformationException(String.format("Transformation aborted in execution of phase '%s' (%s).", next.getLabel(), next.getID()), e);
            }
            catch (RuntimeException e) {
                throw new TransformationException(String.format("Uncaught exception in execution of phase '%s' (%s).", next.getLabel(), next.getID()), e);
            }
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName()).append('(');
        boolean comma = false;
        for (IPhase next : this.phases) {
            if (comma) {
                result.append(", ");
            } else {
                comma = true;
            }
            result.append((Object)next.getKind()).append('(');
            result.append(next.getLabel());
            result.append(')');
        }
        result.append(')');
        return result.toString();
    }

    public void addPhase(IPhase phase) {
        block0 : switch (phase.getKind()) {
            case INITIALIZATION: {
                this.phases.set(0, phase);
                break;
            }
            case FINALIZATION: {
                this.phases.set(this.phases.size() - 1, phase);
                break;
            }
            default: {
                ListIterator<IPhase> iter = this.phases.listIterator();
                while (iter.hasNext()) {
                    IPhase cur = iter.next();
                    if (phase.getID().equals(cur.getID())) {
                        switch (cur.getKind()) {
                            case INITIALIZATION: 
                            case FINALIZATION: {
                                throw new IllegalArgumentException("Cannot replace init or fini phase with a phase of a different kind.");
                            }
                        }
                        iter.set(phase);
                        break block0;
                    }
                    if (cur.getKind() != PhaseKind.FINALIZATION) continue;
                    iter.previous();
                    iter.add(phase);
                    break block0;
                }
                break block0;
            }
        }
    }
}

