/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.graphql;

import java.util.Collections;
import java.util.List;
import org.eclipse.microprofile.graphql.Description;
import org.eclipse.microprofile.graphql.Name;
import org.eclipse.microprofile.graphql.Query;
import org.testng.Assert;
import org.testng.annotations.Test;

public class NameTest {
    @Test
    public void testSchemaNameAnnotationOnCharacterParameter() throws Exception {
        Name argument = (Name)Character.class.getDeclaredMethod("getFriendsOf", Character.class).getParameterAnnotations()[0][0];
        Description description = (Description)Character.class.getDeclaredMethod("getFriendsOf", Character.class).getParameterAnnotations()[0][1];
        Assert.assertEquals((String)argument.value(), (String)"whomFriends");
        Assert.assertEquals((String)description.value(), (String)"Whom friends to fetch");
    }

    @Test
    public void testSchemaNameAnnotationOnNameField() throws Exception {
        Name inputField = ((Name[])Character.class.getDeclaredField("name").getAnnotationsByType(Name.class))[0];
        Assert.assertEquals((String)inputField.value(), (String)"theName");
    }

    private static class Character {
        @Name(value="theName")
        private String name;

        public Character(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        @Query(value="friendsOf")
        @Description(value="Returns all the friends of a character")
        public List<Character> getFriendsOf(@Name(value="whomFriends") @Description(value="Whom friends to fetch") Character character) {
            if (character.getName().equals("Han Solo")) {
                return Collections.singletonList(new Character("Chewbacca"));
            }
            return Collections.emptyList();
        }
    }
}

