/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.graphql;

import java.util.Collections;
import java.util.List;
import org.eclipse.microprofile.graphql.Description;
import org.eclipse.microprofile.graphql.Query;
import org.testng.Assert;
import org.testng.annotations.Test;

public class QueryTest {
    @Test
    public void testQueryAnnotationOnCharacterMethod() throws Exception {
        Query query = Character.class.getDeclaredMethod("getFriendsOf", Character.class).getAnnotation(Query.class);
        Assert.assertEquals((String)query.value(), (String)"friendsOf");
        Description description = Character.class.getDeclaredMethod("getFriendsOf", Character.class).getAnnotation(Description.class);
        Assert.assertEquals((String)description.value(), (String)"Returns all the friends of a character");
    }

    private static class Character {
        private String name;

        public Character(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        @Query(value="friendsOf")
        @Description(value="Returns all the friends of a character")
        public List<Character> getFriendsOf(Character character) {
            if (character.getName().equals("Han Solo")) {
                return Collections.singletonList(new Character("Chewbacca"));
            }
            return Collections.emptyList();
        }
    }
}

