/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.graphql.tck.dynamic;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonPatchBuilder;
import jakarta.json.JsonReader;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.graphql.tck.dynamic.DeployableUnit;
import org.eclipse.microprofile.graphql.tck.dynamic.execution.GraphQLTestDataProvider;
import org.eclipse.microprofile.graphql.tck.dynamic.execution.PrintUtil;
import org.eclipse.microprofile.graphql.tck.dynamic.execution.TestData;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.json.JSONException;
import org.skyscreamer.jsonassert.JSONAssert;
import org.testng.Assert;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

public class ExecutionDynamicTest
extends Arquillian {
    private static final Logger LOG = Logger.getLogger(ExecutionDynamicTest.class.getName());
    private static final String PATH = "graphql";
    private static final String UTF8 = "utf-8";
    private static final String MEDIATYPE_JSON = "application/json";
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final String HEADER_ACCEPT = "Accept";
    private static final String QUERY = "query";
    private static final String VARIABLES = "variables";
    private static final int CONNECT_TIMEOUT = Integer.getInteger("mp.tck.connect.timeout", 5000);
    private static final int READ_TIMEOUT = Integer.getInteger("mp.tck.read.timeout", 5000);
    private TestData currentTestData = null;
    private String currentOutput = null;
    @ArquillianResource
    private URI uri;

    @Deployment
    public static Archive<?> getDeployment() throws Exception {
        return DeployableUnit.getDeployment("tck-dynamic");
    }

    @RunAsClient
    @Test(dataProvider="specification", dataProviderClass=GraphQLTestDataProvider.class)
    public void testSpecification(TestData testData) {
        this.runTest(testData);
    }

    @RunAsClient
    @Test(dataProvider="implementation", dataProviderClass=GraphQLTestDataProvider.class)
    public void testImplementationSpecific(TestData testData) throws IOException {
        this.runTest(testData);
    }

    private void runTest(TestData testData) {
        if (testData != null && this.isValidInput(testData.getInput())) {
            LOG.info("Running test [" + testData.getName() + "]");
            this.currentTestData = testData;
            HashMap<String, String> httpHeaders = new HashMap<String, String>();
            if (testData.getHttpHeaders() != null && !testData.getHttpHeaders().isEmpty()) {
                for (Map.Entry header : httpHeaders.entrySet()) {
                    httpHeaders.put((String)header.getKey(), (String)header.getValue());
                }
            }
            boolean success = false;
            ArrayList<Throwable> listExceptions = new ArrayList<Throwable>();
            for (String input : testData.getInput()) {
                try {
                    if (this.isValidInput(testData.getPrepare())) {
                        this.postHTTPRequest(testData.getPrepare(), testData.getVariables(), httpHeaders);
                    }
                    this.assertTest(input, testData, httpHeaders);
                    success = true;
                    break;
                }
                catch (AssertionError ae) {
                    listExceptions.add((Throwable)((Object)ae));
                }
            }
            if (!success) {
                Assert.fail((String)this.getErrorMessages(listExceptions));
            }
        } else {
            this.clearGlobals();
            LOG.warning("Could not find any tests to run...");
        }
    }

    private void assertTest(String input, TestData testData, Map<String, String> httpHeaders) {
        HttpResponse httpResponse = this.postHTTPRequest(input, testData.getVariables(), httpHeaders);
        if (httpResponse.isSuccessful()) {
            this.currentOutput = httpResponse.getContent();
            this.validateResponseStructure();
            if (this.isValidInput(testData.getCleanup())) {
                this.postHTTPRequest(testData.getCleanup(), testData.getVariables(), httpHeaders);
            }
            boolean success = false;
            ArrayList<Throwable> listExceptions = new ArrayList<Throwable>();
            for (String output : testData.getOutput()) {
                try {
                    JSONAssert.assertEquals((String)testData.getFailMessage(), (String)output, (String)this.currentOutput, (boolean)testData.beStrict());
                    success = true;
                    break;
                }
                catch (AssertionError ex) {
                    listExceptions.add((Throwable)((Object)ex));
                }
                catch (JSONException je) {
                    Assert.fail((String)je.getMessage());
                }
            }
            if (!success) {
                Assert.fail((String)this.getErrorMessages(listExceptions));
            }
        } else {
            Assert.assertEquals((int)httpResponse.status, (int)testData.getExpectedHttpStatusCode(), (String)httpResponse.getContent());
        }
    }

    @AfterMethod
    public void tearDown(ITestResult result) {
        if (result != null && result.getStatus() == 2) {
            PrintUtil.toDisk(this.currentTestData, this.currentOutput, result.getThrowable());
        }
        this.clearGlobals();
    }

    private void validateResponseStructure() {
        JsonObject received = this.getJsonObject(new StringReader(this.currentOutput));
        JsonArray errors = received.getJsonArray("errors");
        this.validatePart(received, "root", "data", "errors");
        if (errors != null) {
            for (JsonObject errorJsonObject : errors.getValuesAs(JsonObject.class)) {
                JsonArray locations = errorJsonObject.getJsonArray("locations");
                this.validatePart(errorJsonObject, "errors", "message", "locations", "path", "extensions");
                if (locations == null) continue;
                for (JsonObject locationJsonObject : locations.getValuesAs(JsonObject.class)) {
                    this.validatePart(locationJsonObject, "errors/locations", "line", "column");
                }
            }
        }
    }

    private void validatePart(JsonObject jsonObject, String rootName, String ... keys) {
        JsonPatchBuilder jsonPatchBuilder = Json.createPatchBuilder();
        for (String key : keys) {
            jsonPatchBuilder = this.remove(jsonPatchBuilder, jsonObject, key);
        }
        JsonObject emptyObject = (JsonObject)jsonPatchBuilder.build().apply((JsonStructure)jsonObject);
        Assert.assertTrue((boolean)emptyObject.isEmpty(), (String)("Unknown elements in " + rootName + ", only " + Arrays.toString(keys) + " expected"));
    }

    private JsonPatchBuilder remove(JsonPatchBuilder emptyJsonErrorPatchBuilder, JsonObject errorJsonObject, String key) {
        if (errorJsonObject.containsKey((Object)key)) {
            emptyJsonErrorPatchBuilder = emptyJsonErrorPatchBuilder.remove("/" + key);
        }
        return emptyJsonErrorPatchBuilder;
    }

    private void clearGlobals() {
        this.currentTestData = null;
        this.currentOutput = null;
    }

    private JsonObject getJsonObject(Reader input) {
        JsonReader expectedReader = Json.createReader((Reader)input);
        return expectedReader.readObject();
    }

    private boolean isValidInput(String input) {
        return input != null && !input.isEmpty();
    }

    private boolean isValidInput(Set<String> setInput) {
        for (String input : setInput) {
            if (this.isValidInput(input)) continue;
            return false;
        }
        return true;
    }

    private String getErrorMessages(ArrayList<Throwable> listExceptions) {
        StringBuilder sb = new StringBuilder();
        listExceptions.forEach(ex -> sb.append(ex.getMessage()).append('\n'));
        return sb.toString();
    }

    private HttpResponse postHTTPRequest(String graphQL, JsonObject variables, Map<String, String> httpHeaders) {
        try {
            URL url = new URL(this.uri + PATH);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            this.setTimeouts(connection);
            this.addHeaders(connection, httpHeaders);
            connection.setDoOutput(true);
            JsonObject body = this.createRequestBody(graphQL, variables);
            this.postRequest(connection, body);
            int status = connection.getResponseCode();
            if (status == 200) {
                return new HttpResponse(status, this.getResponse(connection));
            }
            return new HttpResponse(status, connection.getResponseMessage());
        }
        catch (ProtocolException pex) {
            LOG.log(Level.SEVERE, "Caught ProtocolException attempting to post an HTTP request", pex);
            throw new RuntimeException(pex);
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, "Caught IOException attempting to post an HTTP request", ex);
            Assert.fail((String)"Could not open a connection to the test server, is it running ?");
            throw new RuntimeException(ex);
        }
    }

    private void addHeaders(HttpURLConnection connection, Map<String, String> httpHeaders) {
        connection.setRequestProperty(HEADER_CONTENT_TYPE, MEDIATYPE_JSON);
        connection.setRequestProperty(HEADER_ACCEPT, MEDIATYPE_JSON);
        if (httpHeaders != null) {
            for (Map.Entry<String, String> header : httpHeaders.entrySet()) {
                connection.setRequestProperty(header.getKey(), header.getValue());
            }
        }
    }

    private void setTimeouts(HttpURLConnection connection) {
        connection.setConnectTimeout(CONNECT_TIMEOUT);
        connection.setReadTimeout(READ_TIMEOUT);
    }

    private JsonObject createRequestBody(String graphQL, JsonObject variables) {
        if (variables == null || variables.isEmpty()) {
            variables = Json.createObjectBuilder().build();
        }
        return Json.createObjectBuilder().add(QUERY, graphQL).add(VARIABLES, (JsonValue)variables).build();
    }

    private void postRequest(HttpURLConnection connection, JsonObject body) throws IOException {
        try (OutputStream os = connection.getOutputStream();){
            byte[] input = body.toString().getBytes(UTF8);
            os.write(input, 0, input.length);
        }
    }

    private String getResponse(HttpURLConnection connection) throws IOException {
        int status = connection.getResponseCode();
        if (status == 200) {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream(), UTF8));){
                String responseLine;
                StringBuilder response = new StringBuilder();
                while ((responseLine = br.readLine()) != null) {
                    response.append(responseLine.trim());
                }
                String jsonResult = response.toString();
                connection.disconnect();
                String string = jsonResult;
                return string;
            }
        }
        connection.disconnect();
        throw new RuntimeException("Status " + status + " - " + connection.getResponseMessage());
    }

    private static class HttpResponse {
        private final int status;
        private final String content;

        public HttpResponse(int status, String content) {
            this.status = status;
            this.content = content;
        }

        public int getStatus() {
            return this.status;
        }

        public String getContent() {
            return this.content;
        }

        public boolean isSuccessful() {
            return this.status == 200;
        }
    }
}

