/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck.interfaces;

import java.lang.reflect.Method;
import javax.annotation.Priority;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.eclipse.microprofile.rest.client.tck.interfaces.Loggable;

@Loggable
@Interceptor
@Priority(value=2000)
public class LoggableInterceptor {
    private static String invocationMessage;

    public static String getInvocationMessage() {
        return invocationMessage;
    }

    public static void setInvocationMessage(String msg) {
        invocationMessage = msg;
    }

    @AroundInvoke
    public Object logInvocation(InvocationContext ctx) throws Exception {
        Method m = ctx.getMethod();
        invocationMessage = m.getDeclaringClass().getName() + "." + m.getName();
        Object returnVal = ctx.proceed();
        invocationMessage = invocationMessage + " " + returnVal;
        return returnVal;
    }
}

